/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Synthetic;

import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_Simple2DSynthetic
extends EnsembleWorker_Base {
    protected Ensemble m_inputEnsemble = null;
    protected ArrayList<Element> m_recList = new ArrayList();
    protected ArrayList<Element> m_shtList = new ArrayList();
    protected int m_nextIndex = 0;
    protected Ensemble m_ensemble = new Ensemble();
    protected LinearLayoutWidget m_mainWidget = null;
    protected JTextField m_txtLineLength;
    protected JTextField m_txtThickness;
    protected JTextField m_txtMinV0;
    protected JTextField m_txtMaxV0;
    protected JTextField m_txtWavelength;
    protected JTextField m_txtV1;
    protected JTextField m_txtMaxOffset;
    protected JTextField m_txtMaxTime;
    protected JTextField[] m_txtEventTime;
    protected JTextField[] m_txtEventVel;

    public EnsembleWorker_Simple2DSynthetic() {
        try {
            this.Abbreviation = "SYN2D";
            this.ShortDescription = "Synthetic 2D";
            this.WorkerType = "Input";
            this.InteractiveFlowsOkay = false;
            this.RequiresRefractionStaticsProject = false;
            this.EnsembleSource = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_Simple2DSynthetic";
    }

    public double getV0(double x, double minV0, double maxV0, double wave) {
        try {
            double x1 = 5000.0;
            double x2 = 6000.0;
            double x3 = x2 + wave;
            double x4 = x3 + 1000.0;
            if (x >= x1 && x <= x2) {
                return minV0 + (maxV0 - minV0) * (x - x1) / (x2 - x1);
            }
            if (x >= x3 && x <= x4) {
                return maxV0 + (minV0 - maxV0) * (x - x3) / (x4 - x3);
            }
            if (x >= x2 && x <= x3) {
                return maxV0;
            }
            return minV0;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 1000.0;
        }
    }

    public double getStatic(double v0, double thickness) {
        try {
            return 1000.0 * thickness / v0;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    @Override
    public boolean prepareSource() {
        try {
            Element e;
            double x;
            this.getParametersFromWidget();
            this.m_recList.clear();
            this.m_shtList.clear();
            this.m_nextIndex = 0;
            double length = this.m_parameterTree.double_get("Length", 20000.0);
            double thickness = this.m_parameterTree.double_get("Thickness", 50.0);
            double maxV0 = this.m_parameterTree.double_get("MaxV0", 1300.0);
            double minV0 = this.m_parameterTree.double_get("MinV0", 1000.0);
            double wavelength = this.m_parameterTree.double_get("Wavelength", 8000.0);
            double v1 = this.m_parameterTree.double_get("V1", 2000.0);
            v1 = Math.max(v1, maxV0 + 200.0);
            this.m_parameterTree.double_put("V1", v1);
            int id = 1000;
            for (x = 0.0; x <= length; x += 50.0) {
                e = new Element();
                e.ID = id++;
                e.X = x;
                e.V0 = this.getV0(x, minV0, maxV0, wavelength);
                e.Static = this.getStatic(e.V0, thickness);
                e.DelayTime = thickness * Math.sqrt(v1 * v1 - e.V0 * e.V0) / (v1 * e.V0);
                this.m_recList.add(e);
            }
            id = 1000;
            for (x = 25.0; x <= length; x += 50.0) {
                e = new Element();
                e.ID = id++;
                e.X = x;
                e.V0 = this.getV0(x, minV0, maxV0, wavelength);
                e.Static = this.getStatic(e.V0, thickness);
                e.DelayTime = thickness * Math.sqrt(v1 * v1 - e.V0 * e.V0) / (v1 * e.V0);
                this.m_shtList.add(e);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return true;
    }

    @Override
    public boolean hasMoreEnsembles() {
        try {
            if (this.m_nextIndex >= this.m_shtList.size()) {
                return false;
            }
            if (this.m_nextIndex == this.m_shtList.size() / 2) {
                System.out.println("_nextIndex == m_shtList.size()/2");
            }
            double maxOff = this.m_parameterTree.double_get("Off", 3000.0);
            double time = this.m_parameterTree.double_get("Time", 3000.0);
            Element sht = this.m_shtList.get(this.m_nextIndex);
            this.m_ensemble.clearTraces(false);
            int indexTraceCode = this.m_ensemble.dictionary().addEntry("Trace", "TraceCode", DataType.Int);
            int indexShotID = this.m_ensemble.dictionary().addEntry("Shot", "PointNumber", DataType.Int);
            int indexShotX = this.m_ensemble.dictionary().addEntry("Shot", "Easting", DataType.Double);
            int indexShotY = this.m_ensemble.dictionary().addEntry("Shot", "Northing", DataType.Double);
            int indexShotZ = this.m_ensemble.dictionary().addEntry("Shot", "Elevation", DataType.Double);
            int indexRecID = this.m_ensemble.dictionary().addEntry("Receiver", "PointNumber", DataType.Int);
            int indexRecX = this.m_ensemble.dictionary().addEntry("Receiver", "Easting", DataType.Double);
            int indexRecY = this.m_ensemble.dictionary().addEntry("Receiver", "Northing", DataType.Double);
            int indexRecZ = this.m_ensemble.dictionary().addEntry("Receiver", "Elevation", DataType.Double);
            double[] ev = new double[this.m_txtEventTime.length];
            double[] et = new double[this.m_txtEventTime.length];
            for (int row = 0; row < this.m_txtEventTime.length; ++row) {
                et[row] = this.m_parameterTree.double_get("Time" + Integer.toString(row), 500 + row * 200);
                ev[row] = this.m_parameterTree.double_get("Vel" + Integer.toString(row), 2000 + row * 200);
            }
            float digi = 4.0f;
            int numSamp = (int)(time / (double)digi);
            float[] data = new float[numSamp];
            double v1 = this.m_parameterTree.double_get("V1", 2000.0);
            for (Element rec : this.m_recList) {
                float v;
                double off = Math.abs(rec.X - sht.X);
                if (!(off <= maxOff)) continue;
                EnsembleTrace trace = this.m_ensemble.addTrace();
                trace.header().putInt(indexTraceCode, 1);
                trace.header().putInt(indexShotID, sht.ID);
                trace.header().putDouble(indexShotX, sht.X);
                trace.header().putDouble(indexShotY, 0.0);
                trace.header().putDouble(indexShotZ, 1000.0);
                trace.header().putInt(indexRecID, rec.ID);
                trace.header().putDouble(indexRecX, rec.X);
                trace.header().putDouble(indexRecY, 0.0);
                trace.header().putDouble(indexRecZ, 1000.0);
                for (int n = 0; n < numSamp; ++n) {
                    data[n] = 0.0f;
                }
                for (int row = 0; row < this.m_txtEventTime.length; ++row) {
                    double t0 = (double)0.001f * et[row];
                    double temp = off / ev[row];
                    double t = Math.sqrt(t0 * t0 + temp * temp);
                    t += 0.001 * (sht.Static + rec.Static);
                    for (int s = 0; s < numSamp; ++s) {
                        float dt = (float)Math.abs(t - (double)s * 0.001 * (double)digi);
                        float exp = (float)(Math.cos(dt / 0.007f) * Math.exp(0.0 - (double)(dt / 0.012f)));
                        float rand = 0.5f * (0.5f - (float)Math.random());
                        v = 3.0f * exp + rand;
                        data[s] = data[s] + v;
                    }
                }
                double tr = sht.DelayTime + rec.DelayTime + off / v1;
                double avgV0 = 0.5 * (rec.V0 + sht.V0);
                double direct = off / avgV0;
                double tmin = Math.min(direct, tr);
                for (int s = 0; s < numSamp; ++s) {
                    float dt = (float)Math.abs(tmin - (double)s * 0.001 * (double)digi);
                    float exp = (float)(Math.cos(dt / 0.007f) * Math.exp(0.0 - (double)(dt / 0.012f)));
                    v = 3.0f * exp;
                    data[s] = data[s] + v;
                }
                trace.data().insertArray(data, numSamp);
                trace.data().setSampleInterval(digi);
                trace.data().setFirstSampleCoord(0.0f);
            }
            ++this.m_nextIndex;
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public double percentDone() {
        return 100.0 * (double)this.m_nextIndex / (0.01 + (double)this.m_shtList.size());
    }

    @Override
    public Ensemble nextEnsemble() {
        return this.m_ensemble;
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            for (int row = 0; row < this.m_txtEventTime.length; ++row) {
                this.m_parameterTree.double_put("Time" + Integer.toString(row), Tools_Widget.extractDouble(this.m_txtEventTime[row], 500.0, 100.0, 3000.0));
                this.m_parameterTree.double_put("Vel" + Integer.toString(row), Tools_Widget.extractDouble(this.m_txtEventVel[row], 2000.0, 500.0, 100000.0));
            }
            this.m_parameterTree.double_put("Thickness", Tools_Widget.extractDouble(this.m_txtThickness, 50.0, 10.0, 200.0));
            this.m_parameterTree.double_put("MinV0", Tools_Widget.extractDouble(this.m_txtMinV0, 1000.0, 800.0, 3000.0));
            this.m_parameterTree.double_put("MaxV0", Tools_Widget.extractDouble(this.m_txtMaxV0, 1500.0, 1000.0, 4000.0));
            this.m_parameterTree.double_put("Wavelength", Tools_Widget.extractDouble(this.m_txtWavelength, 8000.0, 2000.0, 20000.0));
            this.m_parameterTree.double_put("V1", Tools_Widget.extractDouble(this.m_txtV1, 2000.0, 4000.0, 5000.0));
            this.m_parameterTree.double_put("Length", Tools_Widget.extractDouble(this.m_txtLineLength, 40000.0, 10000.0, 100000.0));
            this.m_parameterTree.double_put("Off", Tools_Widget.extractDouble(this.m_txtMaxOffset, 3000.0, 500.0, 6000.0));
            this.m_parameterTree.double_put("Time", Tools_Widget.extractDouble(this.m_txtMaxTime, 3000.0, 1000.0, 10000.0));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = LinearLayoutWidget.vert(3, null);
                this.m_txtThickness = new JTextField("50");
                this.m_txtMinV0 = new JTextField("1000");
                this.m_txtMaxV0 = new JTextField("1300");
                this.m_txtWavelength = new JTextField("9000");
                this.m_txtV1 = new JTextField("2000");
                this.m_txtLineLength = new JTextField("40000");
                this.m_txtMaxOffset = new JTextField("3000");
                this.m_txtMaxTime = new JTextField("3000");
                this.m_txtEventTime = new JTextField[5];
                this.m_txtEventVel = new JTextField[5];
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(3, "Survey description", 0);
                int row = 0;
                grid.addSimple(row++, new JLabel("Survey length (m)"), this.m_txtLineLength);
                grid.addSimple(row++, new JLabel("Weathering thickness (m)"), this.m_txtThickness);
                grid.addSimple(row++, new JLabel("Min V0 (m/s)"), this.m_txtMinV0);
                grid.addSimple(row++, new JLabel("Max V0 (m/s)"), this.m_txtMaxV0);
                grid.addSimple(row++, new JLabel("V0 wavelength (m)"), this.m_txtWavelength);
                grid.addSimple(row++, new JLabel("Refractor velocity"), this.m_txtV1);
                grid.addSimple(row++, new JLabel("Maximum offset (m)"), this.m_txtMaxOffset);
                grid.addSimple(row++, new JLabel("Trace time (ms)"), this.m_txtMaxTime);
                grid = this.m_mainWidget.createGridLayoutWidget(3, "Events", 0);
                for (row = 0; row < this.m_txtEventTime.length; ++row) {
                    this.m_txtEventTime[row] = new JTextField(Integer.toString(500 + 500 * row));
                    this.m_txtEventVel[row] = new JTextField(Integer.toString(2000 + 200 * row));
                    grid.addSimple(row, new JLabel("Time, velocity"), this.m_txtEventTime[row], this.m_txtEventVel[row]);
                }
                this.m_mainWidget.addStretch(10);
                this.getParametersFromWidget();
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }

    protected class Element {
        public int ID;
        public double X;
        public double V0;
        public double Static;
        public double DelayTime;

        protected Element() {
        }
    }
}

