/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Stacks;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Stack.DigiStack2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_DigiStack2D
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener,
ItemListener {
    protected DigiStack2D m_digiStack2D = new DigiStack2D();
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected JTextField m_corrWindowText;
    protected JTextField m_maxShiftText;
    protected JTextField m_traceRadiusText;

    public EnsembleWorker_DigiStack2D() {
        try {
            this.Abbreviation = "DIGISTACK2D";
            this.ShortDescription = "Digistack 2D";
            this.WorkerType = "First break picking";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_DigiStack2D";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                boolean projectOK = project.valid();
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                int radius = this.m_parameterTree.int_get("Radius", 2);
                double corr = this.m_parameterTree.double_get("CorrelationWindow", 48.0);
                double shift = this.m_parameterTree.double_get("MaxShift", 16.0);
                this.m_corrWindowText = new JTextField(Double.toString(corr));
                this.m_maxShiftText = new JTextField(Double.toString(shift));
                this.m_traceRadiusText = new JTextField(Integer.toString(radius));
                this.m_corrWindowText.addActionListener(this);
                this.m_maxShiftText.addActionListener(this);
                this.m_traceRadiusText.addActionListener(this);
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(3, 0);
                int row = 0;
                grid.addSimple(row++, new JLabel("Correlation window(ms)"), this.m_corrWindowText);
                grid.addSimple(row++, new JLabel("Maximum shift(ms)"), this.m_maxShiftText);
                grid.addSimple(row++, new JLabel("Trace radius"), this.m_traceRadiusText);
                this.m_mainWidget.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this.m_mainWidget, -2, null, true);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void getAll() {
        try {
            int radius = Tools_Widget.extractInteger(this.m_traceRadiusText, 1, 1, 10);
            this.m_parameterTree.int_put("Radius", radius);
            double window = Tools_Widget.extractDouble(this.m_corrWindowText, 100.0, 32.0, 500.0);
            this.m_parameterTree.double_put("CorrelationWindow", window);
            double shift = Tools_Widget.extractDouble(this.m_maxShiftText, 8.0, 4.0, 64.0);
            this.m_parameterTree.double_put("MaxShift", shift);
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String getColumnName() {
        try {
            return "FBP_" + this.m_parameterTree.string_get("Name", "");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.getAll();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            int radius = this.m_parameterTree.int_get("Radius", 2);
            double corr = this.m_parameterTree.double_get("CorrelationWindow", 48.0);
            double shift = this.m_parameterTree.double_get("MaxShift", 16.0);
            double percentOriginal = this.m_parameterTree.double_get("PercentOriginal", 0.0);
            shift = Math.min(shift, corr / 2.0);
            this.m_digiStack2D.compute(ensemble, radius, (float)corr, (float)shift);
            this.m_digiStack2D.synthesize(percentOriginal);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

