/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Picker;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Ensemble.Tools_Picking;
import com.PecosLibrary.Refraction.PickEvent;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class EnsembleWorker_ShiftUserPicks
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener,
ItemListener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected SliderWidget m_windowEditor;
    protected JComboBox<String> m_combo;
    protected JButton m_launchButton;
    protected String m_existsString = "Pick with that name already exists";

    public EnsembleWorker_ShiftUserPicks() {
        try {
            this.FirstBreakAutoPicker = true;
            this.Abbreviation = "PickT";
            this.ShortDescription = "Shift user picks";
            this.WorkerType = "First break picking";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_ShiftUserPicks";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                boolean projectOK = project.valid();
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                String info = "<HTML>Shifts the user picks (FPP_USER) by a given amount and snaps to the nearest event</HTML>";
                JLabel lbl = new JLabel(info);
                lbl.setBorder(BorderFactory.createRaisedBevelBorder());
                this.m_mainWidget.addComponent(lbl, 0);
                String event = this.m_parameterTree.string_get("Event", PickEvent.Peak.name());
                double time = this.m_parameterTree.double_get("Time", 0.0);
                this.m_windowEditor = new SliderWidget(this, null, "Shift time, milliseconds", 0, time, -200.0, 200.0);
                this.m_windowEditor.setRangeLocked(false);
                Tools_FontChanger.changeSizeOfFont(this.m_windowEditor, -1, null, true);
                this.m_mainWidget.addComponent(this.m_windowEditor, 0);
                this.m_combo = new JComboBox();
                this.m_combo.addItem(PickEvent.Peak.name());
                this.m_combo.addItem(PickEvent.Trough.name());
                this.m_combo.addItem(PickEvent.NoEvent.name());
                if (event.equalsIgnoreCase(PickEvent.Peak.name())) {
                    this.m_combo.setSelectedIndex(0);
                } else if (event.equalsIgnoreCase(PickEvent.Trough.name())) {
                    this.m_combo.setSelectedIndex(1);
                } else {
                    this.m_combo.setSelectedIndex(2);
                }
                this.m_combo.addItemListener(this);
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(3, 0);
                int row = 0;
                grid.addSimple(row++, new JLabel("Event"), this.m_combo);
                this.m_mainWidget.createGapLabel(20);
                String txt = "";
                txt = projectOK ? "Start batch picker, modify user picks" : "Start batch picker, create ASCII pick file";
                this.m_launchButton = this.m_mainWidget.createButton(txt, this, 0);
                this.m_mainWidget.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this.m_mainWidget, -2, null, true);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void setOverwritePicks() {
    }

    protected void getAll(boolean broadcast) {
        try {
            this.m_parameterTree.double_put("Time", this.m_windowEditor.getDoubleValue());
            this.m_parameterTree.string_put("Event", (String)this.m_combo.getSelectedItem());
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String getColumnName() {
        try {
            return "FBP_" + this.m_parameterTree.string_get("Name", "");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.m_launchButton == e.getSource()) {
                this.broadcast(this, "SendMessageToOwner");
                return;
            }
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            boolean projectOK = project.valid();
            this.m_inputEnsemble = ensemble;
            double time = this.m_parameterTree.double_get("Time", 0.0);
            String event = this.m_parameterTree.string_get("Event", PickEvent.Peak.name());
            if (!this.m_inputEnsemble.dictionary().containsEntry("Trace", "FBP_User")) {
                this.Success = false;
                this.Reason = "User picks do not exist";
                return;
            }
            PickEvent pe = PickEvent.Peak;
            if (event.equalsIgnoreCase(PickEvent.Trough.name())) {
                pe = PickEvent.Trough;
            } else if (event.equalsIgnoreCase(PickEvent.NoEvent.name())) {
                pe = PickEvent.NoEvent;
            }
            Tools_Picking.shiftUserPicks(ensemble, pe, (float)time);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

