/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Picker;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_PickDifferenceStatistics
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener,
ItemListener,
GenericObjectListener.Listener {
    GridLayoutWidget m_mainWidget = null;
    Ensemble m_inputEnsemble;
    JLabel m_lblOutputFileDirectory;
    JTextField m_txtOutputFileDirectory;
    JButton m_btnBrowseOutputFileDirectory;
    JButton m_btnLaunchBatchProcess;
    JLabel m_lblPickVersion1;
    JLabel m_lblPickVersion2;
    JTextField m_txtPickVersion1;
    JTextField m_txtPickVersion2;
    static final String OutputFile = "OutputFile";
    static final String PickVersion1 = "PickVersion1";
    static final String PickVersion2 = "PickVersion2";

    public EnsembleWorker_PickDifferenceStatistics() {
        this.FirstBreakAutoPicker = false;
        this.RequiresShotOrderedData = false;
        this.Abbreviation = "PDS";
        this.ShortDescription = "PickDifferenceStatistics";
        this.WorkerType = "First break picking";
        this.InteractiveFlowsOkay = true;
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_PickDifferenceStatistics";
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        if (this.m_mainWidget == null) {
            this.m_mainWidget = new GridLayoutWidget(3);
            this.m_lblOutputFileDirectory = this.m_mainWidget.createLabel("output dir", 0, 0);
            this.m_txtOutputFileDirectory = this.m_mainWidget.createTextField("", 0, 1, 1.0, 1.0, 1, 1);
            this.m_btnBrowseOutputFileDirectory = this.m_mainWidget.createButton("Browse..", this, 0, 2);
            this.m_lblPickVersion1 = this.m_mainWidget.createLabel("Pick Version 1", 1, 0);
            this.m_txtPickVersion1 = this.m_mainWidget.createTextField("FBP_User", 1, 1, 1.0, 1.0, 1, 1);
            this.m_lblPickVersion2 = this.m_mainWidget.createLabel("Pick Version 2", 2, 0);
            this.m_txtPickVersion2 = this.m_mainWidget.createTextField("FBP_SC", 2, 1, 1.0, 1.0, 1, 1);
            this.m_btnLaunchBatchProcess = this.m_mainWidget.createButton("Run Batch ", this, 3, 0);
            String sHomeDir = System.getProperty("user.home");
            String sTestFile = sHomeDir + "/testpicks.txt";
            this.m_txtOutputFileDirectory.setText(sTestFile);
            this.getAll(false);
        }
        return this.m_mainWidget;
    }

    protected void getAll(boolean broadcast) {
        try {
            this.m_parameterTree.string_put(OutputFile, this.m_txtOutputFileDirectory.getText());
            this.m_parameterTree.string_put(PickVersion1, this.m_txtPickVersion1.getText());
            this.m_parameterTree.string_put(PickVersion2, this.m_txtPickVersion2.getText());
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            int iHeaderSourceDead = ensemble.dictionary().getEntryIndex("Shot", "Killed");
            int iHeaderRecDead = ensemble.dictionary().getEntryIndex("Receiver", "Killed");
            int iHeaderTraceDead = ensemble.dictionary().getEntryIndex("Trace", "Killed");
            String sPick1 = this.m_parameterTree.string_get(PickVersion1);
            String sPick2 = this.m_parameterTree.string_get(PickVersion2);
            String sOutputFile = this.m_parameterTree.string_get(OutputFile);
            int iHeaderPick1 = ensemble.dictionary().getEntryIndex("Trace", sPick1);
            int iHeaderPick2 = ensemble.dictionary().getEntryIndex("Trace", sPick2);
            double dSum = 0.0;
            double dCount = 0.0;
            float fMin = Float.MAX_VALUE;
            float fMax = Float.MIN_VALUE;
            int nTraces = ensemble.traceCount();
            for (int iTrace = 0; iTrace < nTraces; ++iTrace) {
                float fPick2;
                EnsembleTrace trace = ensemble.trace(iTrace);
                Column_Abstract header = trace.header();
                boolean bShotDead = header.getBool(iHeaderSourceDead);
                boolean bRecDead = header.getBool(iHeaderRecDead);
                boolean bTraceDead = header.getBool(iHeaderTraceDead);
                boolean bl = bTraceDead = bShotDead || bRecDead || bTraceDead;
                if (bTraceDead) continue;
                float fPick1 = header.getFloat(iHeaderPick1);
                float fDiff = fPick1 - (fPick2 = header.getFloat(iHeaderPick2));
                float fAbsDiff = Math.abs(fDiff);
                if (fAbsDiff < fMin) {
                    fMin = fAbsDiff;
                }
                if (fAbsDiff > fMax) {
                    fMax = fAbsDiff;
                }
                dSum += (double)fAbsDiff;
                dCount += 1.0;
            }
            if (dCount > 0.0) {
                double dAvg = dSum / dCount;
                FileWriter writer = new FileWriter(sOutputFile, false);
                PrintWriter lineWriter = new PrintWriter(writer);
                lineWriter.printf("min %5.2f max %5.2f avg %5.2f", Float.valueOf(fMin), Float.valueOf(fMax), dAvg);
                lineWriter.close();
                writer.close();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnBrowseOutputFileDirectory) {
                String sFile = Tools_Chooser.getSaveFileName(".txt");
                this.m_txtOutputFileDirectory.setText(sFile);
                this.getAll(true);
            }
            if (e.getSource() != this.m_btnLaunchBatchProcess) return;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

