/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Picker;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class EnsembleWorker_PickAverage
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener {
    protected Ensemble m_inputEnsemble = null;
    protected LinearLayoutWidget m_mainWidget;
    protected JList m_pickList;
    protected JComboBox m_outputPick;
    protected JTextField m_maxStdDev;
    protected JButton m_btnReload;
    protected JButton m_btnApply;
    protected ArrayList<String> m_stringList;

    public EnsembleWorker_PickAverage() {
        try {
            this.Abbreviation = "PICKAVG";
            this.ShortDescription = "Pick average";
            this.WorkerType = "First break picking";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_PickAverage";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnApply) {
                this.getAll(true);
                return;
            }
            if (e.getSource() == this.m_btnReload) {
                this.reload_picks();
                return;
            }
            if (e.getSource() == this.m_maxStdDev) {
                this.getAll(true);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            double m = Tools_Widget.extractDouble(this.m_maxStdDev, 12.0, 6.0, 1000.0);
            this.m_parameterTree.double_put("m_maxStdDev", m);
            String p = this.m_outputPick.getSelectedItem().toString();
            this.m_parameterTree.string_put("m_outputPick", p);
            int[] sel = this.m_pickList.getSelectedIndices();
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(3, 0);
                int row = 0;
                this.m_btnReload = grid.createButton("Reload pick info", this, row++, 1);
                double maxstd = this.m_parameterTree.double_get("m_maxStdDev", 10.0);
                this.m_maxStdDev = new JTextField(Double.toString(maxstd));
                this.m_maxStdDev.addActionListener(this);
                grid.addSimple(row++, new JLabel("Maximum standard deviation"), this.m_maxStdDev);
                this.m_outputPick = new JComboBox();
                grid.addSimple(row++, new JLabel("Output pick name"), this.m_outputPick);
                this.m_mainWidget.createGapLabel(20);
                this.m_mainWidget.createLabel("Select one or more input picks", 2, 0);
                this.m_pickList = new JList();
                this.m_pickList.setSelectionMode(2);
                this.m_mainWidget.addComponent(new JScrollPane(this.m_pickList), 10);
                this.m_btnApply = this.m_mainWidget.createButton("Apply options", this, 0);
                this.m_mainWidget.addStretch(10);
                this.reload_picks();
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void reload_picks() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.m_stringList = p.traceTableWrapper().traceTable().columns("FBP");
            this.m_outputPick.removeAllItems();
            this.m_pickList.removeAll();
            this.m_pickList.setListData(this.m_stringList.toArray());
            for (String s : this.m_stringList) {
                this.m_outputPick.addItem(s);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

