/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Picker;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Ensemble.Tools_Picking;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_EnergyInWindow
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener,
ItemListener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected SliderWidget m_editor;
    protected JTextField m_minText;
    protected JTextField m_maxText;
    protected JTextField m_nameText;
    protected JButton m_launchButton;
    protected String m_existsString = "Pick with that name already exists";

    public EnsembleWorker_EnergyInWindow() {
        try {
            this.Abbreviation = "EnergyInWindow";
            this.ShortDescription = "Energy in time window";
            this.WorkerType = "Amplitude";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_EnergyInWindow";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                boolean projectOK = project.valid();
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(3, 0);
                this.m_minText = new JTextField("0");
                this.m_maxText = new JTextField("50");
                this.m_nameText = new JTextField("Energy1");
                int row = 0;
                grid.addSimple(row++, new JLabel("Minimum time"), this.m_minText);
                grid.addSimple(row++, new JLabel("Maximum time"), this.m_maxText);
                grid.addSimple(row++, new JLabel("Name"), this.m_nameText);
                this.m_minText.setText(this.m_parameterTree.string_get("MinTime", "0"));
                this.m_maxText.setText(this.m_parameterTree.string_get("MaxTime", "50"));
                this.m_nameText.setText(this.m_parameterTree.string_get("Name", "Energy1"));
                this.m_minText.addActionListener(this);
                this.m_maxText.addActionListener(this);
                this.m_mainWidget.createGapLabel(20);
                String txt = "Start batch analysis, add entry to trace table";
                this.m_launchButton = this.m_mainWidget.createButton(txt, this, 0);
                this.m_mainWidget.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this.m_mainWidget, -2, null, true);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.m_parameterTree.double_put("MinTime", Tools_Widget.extractDouble(this.m_minText, 0.0, 0.0, 5000.0));
            this.m_parameterTree.double_put("MaxTime", Tools_Widget.extractDouble(this.m_maxText, 0.0, 0.0, 5000.0));
            this.m_parameterTree.string_put("Name", this.m_nameText.getText());
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.m_launchButton == e.getSource()) {
                this.broadcast(this, "SendMessageToOwner");
                return;
            }
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String getColumnName() {
        try {
            return this.m_parameterTree.string_get("Name", "Energy1");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Energy1";
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            boolean projectOK = project.valid();
            this.m_inputEnsemble = ensemble;
            double min = this.m_parameterTree.double_get("MinTime", 0.0);
            double max = this.m_parameterTree.double_get("MaxTime", 50.0);
            String name = this.m_parameterTree.string_get("Name", "Energy1");
            if (name.length() < 2) {
                this.Success = false;
                this.Reason = "Name must have at least 2 characters";
                return;
            }
            if (!Tools_Strings.isAlphaNumeric(name, true, false)) {
                this.Success = false;
                this.Reason = "Spaces and special characters not allowed";
                return;
            }
            Tools_Picking.energyInWindow(ensemble, name, (float)min, (float)max);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

