/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Picker;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Ensemble.Tools_Picking;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class EnsembleWorker_AmpOnsetPicker_Snap
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener,
ItemListener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected JTabbedPane m_editorWidget;
    protected SliderWidget m_editor;
    protected JTextField m_text_max_shift;
    protected JComboBox<String> m_combo_input;
    protected JComboBox<String> m_combo_output;
    protected JButton m_launchButton;
    protected JCheckBox m_checkOffsetLimit;
    protected JTextField m_textMinOffset;
    protected JTextField m_textMaxOffset;
    public boolean ApplyOffsetLimits = false;
    public double BatchMinOffset = 0.0;
    public double BatchMaxOffset = 0.0;
    protected String m_existsString = "Pick with that name already exists";

    public EnsembleWorker_AmpOnsetPicker_Snap() {
        try {
            this.FirstBreakAutoPicker = true;
            this.Abbreviation = "AMPPICKERSNAP";
            this.ShortDescription = "Amplitude onset picker - modify existing pick";
            this.WorkerType = "First break picking";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_AmpOnsetPicker_Snap";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_editorWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_editorWidget == null) {
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                boolean projectOK = project.valid();
                this.m_editorWidget = new JTabbedPane();
                LinearLayoutWidget page = LinearLayoutWidget.vert(3, null);
                this.m_editorWidget.addTab("Main", page);
                String s = "<HTML>NOTE!! The \"Compute amplitude envelope\" process should be called BEFORE calling this process</HTML>";
                JLabel lbl = new JLabel(s);
                lbl.setBorder(BorderFactory.createRaisedBevelBorder());
                page.addComponent(lbl, 0);
                double threshold = this.m_parameterTree.double_get("Threshold", 20.0);
                this.m_editor = new SliderWidget(this, null, "Amplitude percent", 0, threshold, 0.1, 100.0);
                this.m_editor.setRangeLocked(true);
                Tools_FontChanger.changeSizeOfFont(this.m_editor, -1, null, true);
                page.addComponent(this.m_editor, 0);
                this.m_combo_input = new JComboBox();
                this.m_combo_output = new JComboBox();
                this.m_combo_input.addItem("FBP_AMP");
                this.m_combo_input.addItem("FBP_User");
                this.m_combo_input.addItem("FBP_TAP");
                this.m_combo_input.addItem("FBP_Back1");
                this.m_combo_input.addItem("FBP_Back2");
                this.m_combo_input.addItem("FBP_Back3");
                this.m_combo_output.addItem("FBP_AMP");
                this.m_combo_output.addItem("FBP_User");
                this.m_combo_output.addItem("FBP_TAP");
                this.m_combo_output.addItem("FBP_Back1");
                this.m_combo_output.addItem("FBP_Back2");
                this.m_combo_output.addItem("FBP_Back3");
                String name_in = this.m_parameterTree.string_get("Input", "FBP_TAP");
                String name_out = this.m_parameterTree.string_get("Name", "FBP_AMP");
                this.m_combo_input.setSelectedItem(name_in);
                this.m_combo_output.setSelectedItem(name_out);
                this.m_combo_input.addActionListener(this);
                this.m_combo_output.addActionListener(this);
                LinearLayoutWidget sub = page.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, "Pick name, event", 0);
                LinearLayoutWidget sub2 = sub.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
                sub2.addComponent(new JLabel("Input pick name"), 0);
                sub2.addComponent(this.m_combo_input, 10);
                sub2 = sub.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
                sub2.addComponent(new JLabel("Output pick name"), 0);
                sub2.addComponent(this.m_combo_output, 10);
                String txt = "";
                txt = projectOK ? "Start batch picker, add entry to trace table" : "Start batch picker, create ASCII pick file";
                this.m_launchButton = page.createButton(txt, this, 0);
                page = LinearLayoutWidget.vert(3, null);
                this.m_editorWidget.addTab("Offset", page);
                GridLayoutWidget batchGrid = page.createGridLayoutWidget(0, "Offset limits (BATCH JOB ONLY!)", 0);
                int batchRow = 0;
                this.m_checkOffsetLimit = new JCheckBox("Apply offset limits");
                this.m_checkOffsetLimit.setSelected(this.m_parameterTree.bool_get("BatchApplyOffsetLimits", false));
                batchGrid.addComponent(this.m_checkOffsetLimit, batchRow, 1, 1.0, 10.0);
                this.m_textMinOffset = new JTextField(this.m_parameterTree.string_get("BatchMinOffset", "0"));
                this.m_textMaxOffset = new JTextField(this.m_parameterTree.string_get("BatchMaxOffset", "100000"));
                int n = ++batchRow;
                batchGrid.addSimple(n, new JLabel("Min offset"), this.m_textMinOffset);
                int n2 = ++batchRow;
                ++batchRow;
                batchGrid.addSimple(n2, new JLabel("Max offset"), this.m_textMaxOffset);
                page.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this.m_editorWidget, -2, null, true);
            }
            return this.m_editorWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void setOverwritePicks() {
        try {
            this.m_parameterTree.bool_put("Overwrite", true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            if (this.m_editorWidget == null) {
                return;
            }
            this.m_parameterTree.double_put("Threshold", this.m_editor.getDoubleValue());
            this.m_parameterTree.string_put("Input", this.m_combo_input.getSelectedItem().toString());
            this.m_parameterTree.string_put("Name", this.m_combo_output.getSelectedItem().toString());
            this.m_parameterTree.bool_put("BatchApplyOffsetLimits", this.m_checkOffsetLimit.isSelected());
            this.m_parameterTree.double_put("BatchMinOffset", Tools_Widget.extractDouble(this.m_textMinOffset, 0.0, 0.0, 1000000.0));
            this.m_parameterTree.double_put("BatchMaxOffset", Tools_Widget.extractDouble(this.m_textMaxOffset, 0.0, 0.0, 1000000.0));
            this.ApplyOffsetLimits = this.m_parameterTree.bool_get("BatchApplyOffsetLimits", false);
            this.BatchMinOffset = this.m_parameterTree.double_get("BatchMinOffset", 0.0);
            this.BatchMaxOffset = this.m_parameterTree.double_get("BatchMaxOffset", 1000000.0);
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String getColumnName() {
        try {
            return this.m_parameterTree.string_get("Name", "FBP_AMP");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.m_launchButton == e.getSource()) {
                this.broadcast(this, "SendMessageToOwner");
                return;
            }
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            boolean projectOK = project.valid();
            this.m_inputEnsemble = ensemble;
            double threshold = this.m_parameterTree.double_get("Threshold", 20.0);
            threshold = Math.max(threshold, 0.1);
            threshold = Math.min(threshold, 100.0);
            String input = this.m_parameterTree.string_get("Input", "FBP_User");
            String name = this.m_parameterTree.string_get("Name", "FBP_AMP");
            boolean overwrite = this.m_parameterTree.bool_get("Overwrite", false);
            threshold = (double)0.01f * threshold;
            Tools_Picking.makeAmplitudeOnsetPicks_Snap(ensemble, input, name, (float)threshold);
            ensemble.pickPlotData().addRequiredPick(name);
            if (!projectOK) {
                ensemble.pickPlotData().add(name, Color.red, 9, Java2D_PointSymbol.FilledOval);
            }
            this.IasAutopicker = true;
            this.AutopickerColumnName = name;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

