/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Moveout;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class EnsembleWorker_ApplyLinearMoveout
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected SliderWidget m_editor;
    protected JCheckBox m_checkOn;
    protected JCheckBox m_checkUndo;
    protected JCheckBox m_checkZeroMean;

    public EnsembleWorker_ApplyLinearMoveout() {
        try {
            this.Abbreviation = "LMO";
            this.ShortDescription = "Apply linear moveout";
            this.WorkerType = "Moveout";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_ApplyLinearMoveout";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getParametersFromWidget();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_checkUndo) {
                this.getParametersFromWidget();
                this.broadcast(this, "Modified");
            }
            if (e.getSource() == this.m_checkZeroMean) {
                this.getParametersFromWidget();
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            if (this.m_editor == null) {
                return;
            }
            this.m_parameterTree.double_put("LMO", this.m_editor.getDoubleValue());
            this.m_parameterTree.bool_put("ZeroMean", this.m_checkZeroMean.isSelected());
            this.m_parameterTree.bool_put("Undo", this.m_checkUndo.isSelected());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                double velocity = this.m_parameterTree.double_get("LMO", 2000.0);
                boolean zeroMean = this.m_parameterTree.bool_get("ZeroMean", false);
                boolean undo = this.m_parameterTree.bool_get("Undo", false);
                this.m_editor = new SliderWidget(this, null, "Linear moveout velocity", 0, velocity, 100.0, 30000.0);
                this.m_editor.setRangeLocked(false);
                this.m_checkUndo = new JCheckBox("Undo linear moveout");
                this.m_checkUndo.setSelected(undo);
                this.m_checkUndo.addActionListener(this);
                this.m_mainWidget.addComponent(this.m_checkUndo, 0);
                Tools_FontChanger.changeSizeOfFont(this.m_editor, -1, null, true);
                this.m_mainWidget.addComponent(this.m_editor, 0);
                this.m_mainWidget.createGapLabel(20);
                this.m_mainWidget.addComponent(new JLabel("The zero mean option is useful when viewing offset gathers"), 0);
                this.m_checkZeroMean = new JCheckBox("Force result to be zero mean");
                this.m_checkZeroMean.setSelected(zeroMean);
                this.m_checkZeroMean.addActionListener(this);
                this.m_mainWidget.addComponent(this.m_checkZeroMean, 0);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public JComponent editorWidget(boolean withCheckBox) throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                double velocity = this.m_parameterTree.double_get("LMO", 2000.0);
                boolean zeroMean = this.m_parameterTree.bool_get("ZeroMean", false);
                boolean undo = this.m_parameterTree.bool_get("Undo", false);
                this.m_editor = new SliderWidget(this, null, "Linear moveout velocity", 0, velocity, 100.0, 30000.0);
                this.m_editor.setRangeLocked(false);
                Tools_FontChanger.changeSizeOfFont(this.m_editor, -1, null, true);
                this.m_checkOn = new JCheckBox("Apply linear moveout");
                this.m_checkOn.setSelected(false);
                this.m_checkOn.addActionListener(this);
                this.m_checkUndo = new JCheckBox("Undo linear moveout");
                this.m_checkUndo.setSelected(undo);
                this.m_checkUndo.addActionListener(this);
                this.m_mainWidget.addComponent(this.m_checkOn, 0);
                this.m_mainWidget.addComponent(this.m_checkUndo, 0);
                this.m_mainWidget.addComponent(this.m_editor, 0);
                this.m_mainWidget.addComponent(new JLabel("The zero mean option is useful when viewing offset gathers"), 0);
                this.m_checkZeroMean = new JCheckBox("Force result to be zero mean");
                this.m_checkZeroMean.setSelected(zeroMean);
                this.m_checkZeroMean.addActionListener(this);
                this.m_mainWidget.addComponent(this.m_checkZeroMean, 0);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            boolean undo = this.m_parameterTree.bool_get("Undo", false);
            boolean on = this.m_parameterTree.bool_get("On", true);
            if (!on) {
                return;
            }
            double velocity = this.m_parameterTree.double_get("LMO", 0.0);
            boolean zeroMean = this.m_parameterTree.bool_get("ZeroMean", false);
            if (Math.abs(velocity) < 0.001) {
                this.Success = false;
                this.Reason = "Velocity too small";
                return;
            }
            boolean ok = false;
            ok = zeroMean ? Tools_Ensemble.applyLinearMoveout_ZeroMean(ensemble, velocity, undo) : Tools_Ensemble.applyLinearMoveout(ensemble, velocity, undo);
            if (!ok) {
                this.Success = false;
                this.Reason = "Offset header value not valid";
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

