/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Import;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Shared.FileWidget;
import com.PecosLibrary.Windows.Shared.MultipleFileSelectionWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JComponent;

public class EnsembleWorker_ScanSegy
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener,
ItemListener,
GenericObjectListener.Listener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected ArrayList<String> m_fileList;
    protected ArrayList<Segy> m_segyList = new ArrayList();
    protected long m_traceCount = 0L;
    protected Segy_Dictionary m_dict = new Segy_Dictionary();
    protected int m_currentTraceIndex = 0;
    protected int m_currentFileIndex = 0;
    protected long m_totalRead = 0L;
    protected long[] m_indices = new long[1000];
    protected Ensemble m_scanEnsemble = new Ensemble();
    public boolean isEnsembleSource = false;
    protected LinearLayoutWidget m_mainWidget;
    protected FileWidget m_dictFileWidget;
    protected MultipleFileSelectionWidget m_fileWidget;

    public EnsembleWorker_ScanSegy() {
        try {
            this.Abbreviation = "SEGY";
            this.ShortDescription = "SEG-Y import";
            this.WorkerType = "Input";
            this.InteractiveFlowsOkay = false;
            this.RequiresRefractionStaticsProject = false;
            this.EnsembleSource = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_ScanSegy";
    }

    public void appendSegyFile(String fileName) {
        try {
            ArrayList<String> list = this.m_parameterTree.stringList_get("FileList");
            list.add(fileName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setDictionaryFileName(String fileName) {
        try {
            this.m_parameterTree.string_put("DictionaryFile", fileName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean prepareSource() {
        try {
            Object dictFileName;
            if (this.m_parameterTree.string_exists("DictionaryFile") && Tools_FileSystem.exists_file((String)(dictFileName = this.m_parameterTree.string_get("DictionaryFile", "")))) {
                this.m_dict.setOpenFileName((String)dictFileName);
            }
            this.m_fileList = this.m_parameterTree.stringList_get("FileList");
            for (String fileName : this.m_fileList) {
                Segy segy = new Segy();
                segy.setFileName(fileName);
                if (!segy.isFileOK() || segy.traceCount() <= 0L) continue;
                this.m_traceCount += segy.traceCount();
                this.m_segyList.add(segy);
                segy.setSegyDictionary(this.m_dict);
            }
            this.m_currentFileIndex = 0;
            this.m_currentTraceIndex = 0;
            this.m_totalRead = 0L;
            return this.m_traceCount > 0L;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public boolean hasMoreEnsembles() {
        try {
            this.m_scanEnsemble.clearTraces(false);
            if (this.m_traceCount < 1L) {
                return false;
            }
            if (this.m_currentFileIndex >= this.m_segyList.size()) {
                return false;
            }
            Segy segy = this.m_segyList.get(this.m_currentFileIndex);
            while ((long)this.m_currentTraceIndex >= segy.traceCount()) {
                ++this.m_currentFileIndex;
                if (this.m_currentFileIndex >= this.m_segyList.size()) {
                    return false;
                }
                segy = this.m_segyList.get(this.m_currentFileIndex);
                this.m_currentTraceIndex = 0;
            }
            this.SharedData.Extra.clear();
            this.SharedData.Extra.put("FileName", segy.fileName());
            for (int n = 0; n < this.m_indices.length; ++n) {
                this.m_indices[n] = n + this.m_currentTraceIndex;
            }
            segy.populateEnsemble(this.m_scanEnsemble, this.m_indices, this.m_indices.length, true, true);
            this.m_totalRead += (long)this.m_scanEnsemble.traceCount();
            this.m_currentTraceIndex += this.m_indices.length;
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public double percentDone() {
        if (this.m_traceCount > 0L) {
            return 100.0 * (double)this.m_totalRead / (double)this.m_traceCount;
        }
        return 0.0;
    }

    @Override
    public Ensemble nextEnsemble() {
        return this.m_scanEnsemble;
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.m_parameterTree.stringList_put("FileList", this.m_fileWidget.fileList());
            this.m_parameterTree.string_put("DictionaryFile", this.m_dictFileWidget.getText());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = LinearLayoutWidget.vert(3, null);
                this.m_dictFileWidget = new FileWidget(false, 3, "Select SEG-Y dictionary", this);
                this.m_mainWidget.addComponent(this.m_dictFileWidget, 0);
                this.m_fileWidget = new MultipleFileSelectionWidget("SEG-Y files");
                this.m_mainWidget.addComponent(this.m_fileWidget, 10);
                ArrayList<String> list = this.m_parameterTree.stringList_get("FileList");
                this.m_fileWidget.setFileList(list, false);
                String fileName = this.m_parameterTree.string_get("DictionaryFile", "");
                this.m_dictFileWidget.setText(fileName);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.getParametersFromWidget();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getParametersFromWidget();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

