/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Export;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Seismic.Segy.Segy_Exporter;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Shared.FileWidget;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_ExportSegy_NoProjectRequired
extends EnsembleWorker_Base
implements GenericObjectListener.Listener {
    protected Ensemble m_inputEnsemble = null;
    protected LinearLayoutWidget m_editor = null;
    protected FileWidget m_dictFileWidget;
    protected FileWidget m_outFileWidget;
    protected JTextField m_txtSampleCount;
    protected JTextField m_txtDigi;
    protected Segy_Exporter m_exporter = null;

    public EnsembleWorker_ExportSegy_NoProjectRequired() {
        try {
            this.Abbreviation = "SEGYEXP";
            this.ShortDescription = "SEG-Y file export (project not required)";
            this.WorkerType = "Output";
            this.RequiresRefractionStaticsProject = false;
            this.InteractiveFlowsOkay = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_ExportSegy_NoProjectRequired";
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_editor == null) {
                this.m_editor = LinearLayoutWidget.vert(3, null);
                this.m_dictFileWidget = new FileWidget(false, 3, "Select SEG-Y dictionary", this);
                this.m_outFileWidget = new FileWidget(false, 3, "Select output SEG-Y file name", this);
                this.m_outFileWidget.OpenFile = false;
                this.m_editor.addComponent(this.m_dictFileWidget, 0);
                this.m_editor.addComponent(this.m_outFileWidget, 0);
                GridLayoutWidget grid = new GridLayoutWidget(3, null);
                this.m_txtSampleCount = new JTextField();
                this.m_txtDigi = new JTextField();
                int row = 0;
                grid.addSimple(row++, new JLabel("Output sample count"), this.m_txtSampleCount);
                grid.addSimple(row++, new JLabel("Sample interval (ms)"), this.m_txtDigi);
                this.m_editor.addComponent(grid, 0);
                this.m_editor.addStretch(10);
                String dictName = this.m_parameterTree.string_get("DictFile", "");
                String outName = this.m_parameterTree.string_get("OutFile", "");
                int numSamp = this.m_parameterTree.int_get("NumSamp", 500);
                double digi = this.m_parameterTree.double_get("Digi", 4.0);
                digi = Math.max(digi, 1.0);
                digi = Math.min(digi, 10.0);
                this.m_txtDigi.setText(Double.toString(digi));
                this.m_dictFileWidget.setText(dictName);
                this.m_outFileWidget.setText(outName);
                this.m_txtSampleCount.setText(Integer.toString(numSamp));
            }
            return this.m_editor;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_editor == null) {
                return;
            }
            this.m_parameterTree.string_put("DictFile", this.m_dictFileWidget.getText());
            this.m_parameterTree.string_put("OutFile", this.m_outFileWidget.getText());
            int numSamp = Tools_Widget.extractInteger(this.m_txtSampleCount, 100, 0, 2000);
            this.m_parameterTree.int_put("NumSamp", numSamp);
            double digi = Tools_Widget.extractDouble(this.m_txtDigi, 4.0, 0.25, 10.0);
            this.m_parameterTree.double_put("Digi", digi);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            if (this.SharedData.Type != EnsembleWorker_Sequence.SequenceType.Processing) {
                return;
            }
            if (this.m_exporter == null) {
                this.getParametersFromWidget();
                this.m_exporter = new Segy_Exporter();
                String dictFile = this.m_parameterTree.string_get("DictFile", "");
                this.m_exporter.Dictionary = new Segy_Dictionary();
                this.m_exporter.Dictionary.setOpenFileName(dictFile);
                this.m_exporter.FileName = this.m_parameterTree.string_get("OutFile", "");
                this.m_exporter.OutputSampleCount = this.m_parameterTree.int_get("NumSamp", 500);
                this.m_exporter.OutputDigi = (float)this.m_parameterTree.double_get("Digi", 4.0);
                this.m_exporter.prepareFile();
            }
            this.m_exporter.appendEnsemble(ensemble);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

