/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Amplitude;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_WindowScaling
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected float[] m_valueArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected SliderWidget m_windowSlider;
    protected JTextField m_powerText;

    public EnsembleWorker_WindowScaling() {
        try {
            this.Abbreviation = "FWS";
            this.ShortDescription = "Sliding window scaling";
            this.WorkerType = "Amplitude";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_WindowScaling";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_powerText) {
                this.getAll(true);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            int power = Tools_Widget.extractInteger(this.m_powerText, 2, 1, 20);
            this.m_parameterTree.int_put("Power", power);
            this.m_parameterTree.double_put("Window", this.m_windowSlider.getDoubleValue());
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                double window = this.m_parameterTree.double_get("Window", 50.0);
                this.m_windowSlider = new SliderWidget(this, null, "Foreground window (milliseconds)", 0, window, 1.0, 500.0);
                this.m_windowSlider.setRangeLocked(false);
                Tools_FontChanger.changeSizeOfFont(this.m_windowSlider, -1, null, true);
                this.m_mainWidget.addComponent(this.m_windowSlider, 0);
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(3, 0);
                int power = this.m_parameterTree.int_get("Power", 2);
                this.m_powerText = new JTextField(Integer.toString(power));
                this.m_powerText.addActionListener(this);
                grid.addSimple(1, new JLabel("Foreground/background ratio"), this.m_powerText);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            int power = this.m_parameterTree.int_get("Power", 2);
            double window = this.m_parameterTree.double_get("Window", 50.0);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                int s;
                int s2;
                EnsembleTrace trace = ensemble.trace(n);
                if (!trace.hasData()) continue;
                FloatArrayWrapper data = trace.data();
                if (this.m_tempArray == null) {
                    this.m_tempArray = new float[data.length()];
                }
                if (this.m_tempArray.length != data.length()) {
                    this.m_tempArray = new float[data.length()];
                }
                if (this.m_valueArray == null) {
                    this.m_valueArray = new float[data.length()];
                }
                if (this.m_valueArray.length != data.length()) {
                    this.m_valueArray = new float[data.length()];
                }
                data.copyToArray(this.m_tempArray);
                int len = (int)(window / (double)data.getSampleInterval());
                len = Math.max(2, len);
                int cutoff = 2 * len;
                for (s2 = 0; s2 < cutoff; ++s2) {
                    this.m_valueArray[s2] = 0.0f;
                }
                for (s2 = cutoff; s2 < this.m_tempArray.length; ++s2) {
                    this.m_valueArray[s2] = Math.abs(this.m_tempArray[s2]);
                }
                double sumFore = 0.0;
                double sumBack = 1.0E-40;
                for (s = 0; s < len; ++s) {
                    sumFore += (double)this.m_valueArray[s];
                    sumBack += (double)this.m_valueArray[s];
                }
                for (s = len; s < this.m_tempArray.length; ++s) {
                    sumFore -= (double)this.m_valueArray[s - len];
                    double ratio = (sumFore += (double)this.m_valueArray[s]) / (sumBack += (double)this.m_valueArray[s]);
                    double temp = Math.pow(ratio, power);
                    temp = Math.max(temp, 0.2);
                    this.m_tempArray[s] = this.m_tempArray[s] * (float)temp;
                }
                data.insertArray(this.m_tempArray, this.m_tempArray.length);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

