/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleGroupManager;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Refraction.MoveoutTrendData;
import com.PecosLibrary.Refraction.PickEvent;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class Tools_Picking {
    public static void killPicksUsingTrendLines(Ensemble ensemble, String name, float maxDiff) {
        try {
            MoveoutTrendData trend = null;
            if (RefractionStaticsProject.singleton().valid() && (trend = RefractionStaticsProject.singleton().moveoutTrendData()).numValidLocations(true) < 1) {
                trend = null;
            }
            if (trend == null) {
                return;
            }
            int indexPick = ensemble.dictionary().addEntry("Trace", name, DataType.Float);
            int indexMidX = ensemble.dictionary().getEntryIndex("Trace", "CdpX");
            int indexMidY = ensemble.dictionary().getEntryIndex("Trace", "CdpY");
            int indexOffset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                float off;
                double y;
                Column_Abstract header = ensemble.trace(n).header();
                float pick = header.getFloat(indexPick);
                double x = header.getDouble(indexMidX);
                float trendPick = trend.getTime(x, y = header.getDouble(indexMidY), off = header.getFloat(indexOffset), true);
                float diff = Math.abs(trendPick - pick);
                if (!(diff > maxDiff)) continue;
                header.putFloat(indexPick, -9999.0f);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void killPicksOutsideTimeWindow(Ensemble ensemble, String name, float time, float window) {
        try {
            int indexPick = ensemble.dictionary().addEntry("Trace", name, DataType.Float);
            for (int t = 0; t < ensemble.traceCount(); ++t) {
                EnsembleTrace trace = ensemble.trace(t);
                FloatArrayWrapper samples = trace.data();
                float pick = trace.header().getFloat(indexPick);
                float shiftedTime = time - samples.getFirstSampleCoord_WithShifts();
                float upperLimit = shiftedTime + window;
                float lowerLimit = shiftedTime - window;
                if (!(pick > upperLimit) && !(pick < lowerLimit)) continue;
                trace.header().putFloat(indexPick, -9999.0f);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected static void minimizeDeviancy_RecLine(Ensemble ensemble, String name, PickEvent event) {
        try {
            MoveoutTrendData trend = null;
            if (RefractionStaticsProject.singleton().valid() && (trend = RefractionStaticsProject.singleton().moveoutTrendData()).numValidLocations(true) < 1) {
                trend = null;
            }
            if (trend == null) {
                return;
            }
            int indexPick = ensemble.dictionary().addEntry("Trace", name, DataType.Float);
            int indexMidX = ensemble.dictionary().getEntryIndex("Trace", "CdpX");
            int indexMidY = ensemble.dictionary().getEntryIndex("Trace", "CdpY");
            int indexOffset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            float[] temp = new float[3];
            ensemble.sortInt(0, "Receiver", "PointNumber", "Receiver", "PointIndex");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                ensemble.trace((int)n).pickData().PickValid = false;
                ensemble.trace((int)n).pickData().GoodEdge = false;
                ensemble.trace((int)n).pickData().SetToKilled = false;
                float pick = ensemble.trace(n).header().getFloat(indexPick);
                if (!(pick < -100.0f)) continue;
                ensemble.trace((int)n).pickData().SetToKilled = true;
            }
            int totalOkay = 0;
            for (int n = 1; n < ensemble.traceCount() - 1; ++n) {
                Column_Abstract header = ensemble.trace(n).header();
                Column_Abstract headerLeft = ensemble.trace(n - 1).header();
                Column_Abstract headerRight = ensemble.trace(n + 1).header();
                double x = header.getDouble(indexMidX);
                double y = header.getDouble(indexMidY);
                float pick = header.getFloat(indexPick);
                float pickLeft = headerLeft.getFloat(indexPick);
                float pickRight = headerRight.getFloat(indexPick);
                float offset = header.getFloat(indexOffset);
                float offsetLeft = headerLeft.getFloat(indexOffset);
                float offsetRight = headerRight.getFloat(indexOffset);
                float pickTrend = trend.getTime(x, y, offset, true);
                float velocity = trend.getVelocity(x, y, offset);
                float pickLeft_Pred = pick + 1000.0f * (offsetLeft - offset) / velocity;
                float pickRight_Pred = pick + 1000.0f * (offsetRight - offset) / velocity;
                float pickLeft_Error = Math.abs(pickLeft_Pred - pickLeft);
                float pickRight_Error = Math.abs(pickRight_Pred - pickRight);
                if (!(pickLeft_Error < 15.0f) || !(pickRight_Error < 15.0f) || !(Math.abs(pick - pickTrend) < 300.0f)) continue;
                ++totalOkay;
                ensemble.trace((int)n).pickData().PickValid = true;
                ensemble.trace((int)n).pickData().GoodEdge = false;
            }
            if (totalOkay < 4 || totalOkay >= ensemble.traceCount()) {
                return;
            }
            int totalOkayWithEdges = totalOkay;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                boolean okay = ensemble.trace((int)n).pickData().PickValid;
                int index = n - 1;
                if (!okay && index >= 0 && index < ensemble.traceCount() && ensemble.trace((int)index).pickData().PickValid && !ensemble.trace((int)index).pickData().GoodEdge) {
                    ensemble.trace((int)n).pickData().PickValid = true;
                    ensemble.trace((int)n).pickData().GoodEdge = true;
                    ++totalOkayWithEdges;
                    okay = true;
                }
                index = n + 1;
                if (okay || index < 0 || index >= ensemble.traceCount() || !ensemble.trace((int)index).pickData().PickValid || ensemble.trace((int)index).pickData().GoodEdge) continue;
                ensemble.trace((int)n).pickData().PickValid = true;
                ensemble.trace((int)n).pickData().GoodEdge = true;
                ++totalOkayWithEdges;
                okay = true;
            }
            if (totalOkayWithEdges >= ensemble.traceCount()) {
                return;
            }
            boolean badPicksFound = true;
            while (badPicksFound) {
                badPicksFound = false;
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    if (ensemble.trace((int)n).pickData().PickValid) continue;
                    Column_Abstract header = ensemble.trace(n).header();
                    badPicksFound = true;
                    boolean fixPick = false;
                    if (n >= 1) {
                        boolean bl = fixPick = fixPick || ensemble.trace((int)(n - 1)).pickData().PickValid;
                    }
                    if (n < ensemble.traceCount() - 1) {
                        boolean bl = fixPick = fixPick || ensemble.trace((int)(n + 1)).pickData().PickValid;
                    }
                    if (!fixPick) continue;
                    double x = header.getDouble(indexMidX);
                    double y = header.getDouble(indexMidY);
                    float offset = header.getFloat(indexOffset);
                    float velocity = trend.getVelocity(x, y, offset);
                    double sumPick = 0.0;
                    double sumWeight = 1.0E-40;
                    int minIndex = Math.max(0, n - 5);
                    int maxIndex = Math.min(ensemble.traceCount() - 1, n + 5);
                    for (int index = minIndex; index <= maxIndex; ++index) {
                        if (!ensemble.trace((int)index).pickData().PickValid) continue;
                        Column_Abstract headerTemp = ensemble.trace(index).header();
                        float offsetTemp = headerTemp.getFloat(indexOffset);
                        float pickTemp = headerTemp.getFloat(indexPick);
                        float pickPred = pickTemp + 1000.0f * (offset - offsetTemp) / velocity;
                        double xTemp = headerTemp.getDouble(indexMidX);
                        double yTemp = headerTemp.getDouble(indexMidY);
                        double dx = x - xTemp;
                        double dy = y - yTemp;
                        double w = 100.0 / (100.0 + dx * dx + dy * dy);
                        sumPick += w * (double)pickPred;
                        sumWeight += w;
                    }
                    float pick = (float)(sumPick / sumWeight);
                    header.putFloat(indexPick, pick);
                    FloatArrayWrapper wrapper = ensemble.trace(n).data();
                    if (wrapper.length() > 10) {
                        float t0 = wrapper.getFirstSampleCoord_Initial();
                        float digi = wrapper.getSampleInterval();
                        float startSample = (pick - t0) / digi;
                        if (temp.length != wrapper.length()) {
                            temp = new float[wrapper.length()];
                        }
                        wrapper.copyToArray(temp);
                        float sample = Tools_Picking.getNearestEvent(temp, temp.length, event, startSample, false);
                        pick = t0 + digi * sample;
                        header.putFloat(indexPick, pick);
                    }
                    ensemble.trace((int)n).pickData().PickValid = true;
                }
            }
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                if (!ensemble.trace((int)n).pickData().SetToKilled) continue;
                ensemble.trace(n).header().putFloat(indexPick, -9999.0f);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void minimizeDeviancy(Ensemble ensemble, String name, PickEvent event) {
        try {
            EnsembleGroupManager egm = new EnsembleGroupManager();
            egm.setParentEnsemble(ensemble);
            egm.prepareGroupsBasedOnInteger("Receiver", "LineNumber");
            for (int group = 0; group < egm.GroupList.size(); ++group) {
                Ensemble subEnsemble = egm.GroupList.get((int)group).GroupEnsemble;
                if (subEnsemble.traceCount() < 10) continue;
                Tools_Picking.minimizeDeviancy_RecLine(subEnsemble, name, event);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void makeThresholdPicks(Ensemble ensemble, String name, PickEvent event, float threshold, boolean forceInsideTimeWindow, float timeWindowCenter, float timeWindowSize, boolean applyOffsetLimits, double minOff, double maxOff) {
        try {
            int index = ensemble.dictionary().addEntry("Trace", name, DataType.Float);
            int indexOff = -9999;
            if (applyOffsetLimits) {
                if (ensemble.dictionary().containsEntry("Trace", "Offset")) {
                    indexOff = ensemble.dictionary().getEntryIndex("Trace", "Offset");
                } else {
                    applyOffsetLimits = false;
                }
            }
            float[] temp = new float[3];
            int numFunky = 0;
            int numOkay = 0;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                FloatArrayWrapper wrapper = trace.data();
                if (wrapper.length() < 10 || !trace.traceOkay()) {
                    trace.header().putFloat(index, -9999.0f);
                    continue;
                }
                boolean okay = true;
                if (applyOffsetLimits) {
                    double off = trace.header().getDouble(indexOff);
                    boolean bl = okay = okay && off >= minOff && off <= maxOff;
                }
                if (!okay) continue;
                float t0_initial = wrapper.getFirstSampleCoord_Initial();
                float t0_current = wrapper.getFirstSampleCoord_WithShifts();
                float digi = wrapper.getSampleInterval();
                if (temp.length != wrapper.length()) {
                    temp = new float[wrapper.length()];
                }
                wrapper.copyToArray(temp);
                int sampleWindowCenter = (int)((timeWindowCenter - t0_current) / digi);
                int sampleWindowSize = (int)(timeWindowSize / digi);
                float sample = Tools_Picking.getThreshold(temp, event, threshold, forceInsideTimeWindow, sampleWindowCenter, sampleWindowSize);
                float pick = t0_initial + digi * sample;
                trace.header().putFloat(index, pick);
                if (pick > 1.0f) {
                    ++numOkay;
                    continue;
                }
                ++numFunky;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void energyInWindow(Ensemble ensemble, String name, float minTime, float maxTime) {
        try {
            int index = ensemble.dictionary().addEntry("Trace", name, DataType.Float);
            float[] temp = new float[3];
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                FloatArrayWrapper wrapper = trace.data();
                if (wrapper.length() < 10) {
                    trace.header().putFloat(index, -9999.0f);
                    continue;
                }
                float t0 = wrapper.getFirstSampleCoord_Initial();
                float digi = wrapper.getSampleInterval();
                if (temp.length != wrapper.length()) {
                    temp = new float[wrapper.length()];
                }
                wrapper.copyToArray(temp);
                int minIndex = (int)(0.5f + (minTime - t0) / digi);
                minIndex = Math.max(minIndex, 0);
                int maxIndex = (int)(0.5f + (maxTime - t0) / digi);
                maxIndex = Math.min(maxIndex, wrapper.length() - 1);
                double sumTotal = 1.0E-60;
                for (int k = 0; k < wrapper.length(); ++k) {
                    sumTotal += (double)Math.abs(temp[k]);
                }
                double sum = 0.0;
                for (int k = minIndex; k <= maxIndex; ++k) {
                    sum += (double)Math.abs(temp[k]);
                }
                trace.header().putFloat(index, (float)(100.0 * sum / sumTotal));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void makeAmplitudeOnsetPicks(Ensemble ensemble, String name, float threshold, boolean forceInsideTimeWindow, float timeWindowCenter, float timeWindowSize) {
        try {
            int index = ensemble.dictionary().addEntry("Trace", name, DataType.Float);
            float[] temp = new float[3];
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                FloatArrayWrapper wrapper = trace.data();
                if (!trace.traceOkay() || wrapper.length() < 10) {
                    trace.header().putFloat(index, -9999.0f);
                    continue;
                }
                float t0_initial = wrapper.getFirstSampleCoord_Initial();
                float t0_current = wrapper.getFirstSampleCoord_WithShifts();
                float digi = wrapper.getSampleInterval();
                if (temp.length != wrapper.length()) {
                    temp = new float[wrapper.length()];
                }
                wrapper.copyToArray(temp);
                int sampleWindowCenter = (int)((timeWindowCenter - t0_current) / digi);
                int sampleWindowSize = (int)(timeWindowSize / digi);
                float sample = Tools_Picking.getAmplitudeOnset(temp, threshold, forceInsideTimeWindow, sampleWindowCenter, sampleWindowSize);
                float pick = t0_initial + digi * sample;
                trace.header().putFloat(index, pick);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void makeAmplitudeOnsetPicks_Snap(Ensemble ensemble, String input, String name, float threshold) {
        try {
            int index = ensemble.dictionary().addEntry("Trace", name, DataType.Float);
            int index_in = ensemble.dictionary().addEntry("Trace", input, DataType.Float);
            float[] temp = new float[3];
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                FloatArrayWrapper wrapper = trace.data();
                float input_pick = trace.header().getFloat(index_in);
                if (input_pick < 1.0f || !trace.traceOkay() || wrapper.length() < 10) {
                    trace.header().putFloat(index, -9999.0f);
                    continue;
                }
                float t0_initial = wrapper.getFirstSampleCoord_Initial();
                float t0_current = wrapper.getFirstSampleCoord_WithShifts();
                float digi = wrapper.getSampleInterval();
                float input_sample = (input_pick - t0_initial) / digi;
                if (temp.length != wrapper.length()) {
                    temp = new float[wrapper.length()];
                }
                wrapper.copyToArray(temp);
                float sample = Tools_Picking.getAmplitudeOnset_Snap(temp, threshold, input_sample);
                float pick = t0_initial + digi * sample;
                trace.header().putFloat(index, pick);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void shiftUserPicks(Ensemble ensemble, PickEvent event, float shiftTime) {
        try {
            int index = ensemble.dictionary().addEntry("Trace", "FBP_User", DataType.Float);
            float[] temp = new float[3];
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                FloatArrayWrapper wrapper = trace.data();
                float currentPick = trace.header().getFloat(index);
                if (!(currentPick > -1000.0f)) continue;
                float desiredPick = currentPick + shiftTime;
                float t0 = wrapper.getFirstSampleCoord_Initial();
                float digi = wrapper.getSampleInterval();
                if (temp.length != wrapper.length()) {
                    temp = new float[wrapper.length()];
                }
                wrapper.copyToArray(temp);
                float nearestSample = (desiredPick - t0) / digi;
                float sample = -9999.0f;
                sample = event == PickEvent.Trough ? Tools_Picking.getNearestTrough(temp, temp.length, nearestSample, false) : (event == PickEvent.Peak ? Tools_Picking.getNearestPeak(temp, temp.length, nearestSample, false) : Tools_Picking.getShiftedPickNoSnap(temp, temp.length, nearestSample, true));
                float pick = wrapper.getFirstSampleCoord_Initial() + digi * sample;
                trace.header().putFloat(index, pick);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void pickEventNearestTime(Ensemble ensemble, String name, PickEvent event, float time, boolean branchLimit, int whichBranch) {
        try {
            Tools_Picking.pickEventNearestTime(ensemble, name, event, time, branchLimit, whichBranch, true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void pickEventNearestTime(Ensemble ensemble, String name, PickEvent event, float time, boolean branchLimit, int whichBranch, boolean snap) {
        try {
            int numFunky = 0;
            int numOK = 0;
            int index = ensemble.dictionary().addEntry("Trace", name, DataType.Float);
            int indexBranch = -9999;
            if (ensemble.dictionary().containsEntry("Trace", "Branch_DelayTime")) {
                indexBranch = ensemble.dictionary().getEntryIndex("Trace", "Branch_DelayTime");
            } else {
                branchLimit = false;
            }
            float[] temp = new float[3];
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                float pick;
                float nearestSample;
                EnsembleTrace trace = ensemble.trace(n);
                FloatArrayWrapper wrapper = trace.data();
                int branch = trace.header().getInt(indexBranch);
                boolean branchOK = true;
                if (branchLimit) {
                    if (whichBranch == 0) {
                        branchOK = branch >= 1;
                    } else {
                        boolean bl = branchOK = branch == whichBranch;
                    }
                }
                if (!trace.traceOkay() || !branchOK || wrapper.length() < 10) {
                    trace.header().putFloat(index, -9999.0f);
                    continue;
                }
                float t0 = wrapper.getFirstSampleCoord_WithShifts();
                float digi = wrapper.getSampleInterval();
                if (temp.length != wrapper.length()) {
                    temp = new float[wrapper.length()];
                }
                wrapper.copyToArray(temp);
                float sample = nearestSample = (time - t0) / digi;
                if (snap) {
                    sample = event == PickEvent.Trough ? Tools_Picking.getNearestTrough(temp, temp.length, nearestSample, false) : Tools_Picking.getNearestPeak(temp, temp.length, nearestSample, false);
                }
                if ((pick = wrapper.getFirstSampleCoord_Initial() + digi * sample) < 1.0f) {
                    ++numFunky;
                } else {
                    ++numOK;
                }
                trace.header().putFloat(index, pick);
            }
            if (numFunky > 0) {
                System.out.println("pickEventNearestTime " + numOK + " " + numFunky);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static float getThreshold(float[] data, PickEvent event, float threshold, boolean forceInsideSampleWindow, int sampleWindowCenter, int sampleWindowSize) {
        try {
            if (event == PickEvent.Peak) {
                return Tools_Picking.getThresholdPeak(data, threshold, forceInsideSampleWindow, sampleWindowCenter, sampleWindowSize);
            }
            if (event == PickEvent.Trough) {
                return Tools_Picking.getThresholdTrough(data, threshold, forceInsideSampleWindow, sampleWindowCenter, sampleWindowSize);
            }
            return -9999.0f;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999.0f;
        }
    }

    public static float getThresholdPeak(float[] data, float threshold, boolean forceInsideSampleWindow, int sampleWindowCenter, int sampleWindowSize) {
        try {
            int n;
            float maxGlobal = 1.0E-20f;
            float maxInWindow = 1.0E-20f;
            float maxSampleGlobal = -9999.0f;
            float maxSampleInWindow = -9999.0f;
            int firstIndex = 1;
            int lastIndex = data.length - 2;
            for (n = firstIndex; n <= lastIndex; ++n) {
                if (!(data[n] > maxGlobal)) continue;
                maxSampleGlobal = n;
                maxGlobal = data[n];
            }
            if (forceInsideSampleWindow) {
                int tempFirst = sampleWindowCenter - sampleWindowSize;
                firstIndex = Math.max(firstIndex, tempFirst);
                int tempLast = sampleWindowCenter + sampleWindowSize;
                lastIndex = Math.min(lastIndex, tempLast);
            }
            for (n = firstIndex; n <= lastIndex; ++n) {
                if (!(data[n] > maxInWindow)) continue;
                maxSampleInWindow = n;
                maxInWindow = data[n];
            }
            if (maxSampleGlobal < 0.0f) {
                return -9999.0f;
            }
            threshold *= maxGlobal;
            for (n = firstIndex; n <= lastIndex; ++n) {
                boolean isGlobal;
                boolean isLocalLeft = data[n] >= data[n - 1] && data[n] > data[n + 1];
                boolean isLocalRight = data[n] > data[n - 1] && data[n] >= data[n + 1];
                boolean isLocal = isLocalLeft || isLocalRight;
                boolean bl = isGlobal = isLocal && data[n] >= threshold;
                if (!isGlobal) continue;
                return Tools_Picking.getNearestPeak(data, data.length, n, false);
            }
            return Tools_Picking.getNearestPeak(data, data.length, maxSampleInWindow, false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999.0f;
        }
    }

    public static float getAmplitudeOnset(float[] data, float threshold, boolean forceInsideSampleWindow, int sampleWindowCenter, int sampleWindowSize) {
        try {
            int n;
            float max = 1.0E-20f;
            float maxSample = -9999.0f;
            int firstIndex = 1;
            int lastIndex = data.length - 2;
            if (forceInsideSampleWindow) {
                int tempFirst = sampleWindowCenter - sampleWindowSize;
                firstIndex = Math.max(firstIndex, tempFirst);
                int tempLast = sampleWindowCenter + sampleWindowSize;
                lastIndex = Math.min(lastIndex, tempLast);
            }
            for (n = firstIndex; n <= lastIndex; ++n) {
                if (!(data[n] > max)) continue;
                maxSample = n;
                max = data[n];
            }
            if (maxSample < 0.0f) {
                return -9999.0f;
            }
            if (data[0] >= (threshold *= max)) {
                return 0.0f;
            }
            for (n = firstIndex; n <= lastIndex; ++n) {
                if (!(data[n] >= threshold)) continue;
                double s = (threshold - data[n - 1]) / (data[n] - data[n - 1]);
                return (float)(n - 1) + (float)s;
            }
            return -9999.0f;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999.0f;
        }
    }

    public static float getAmplitudeOnset_Snap(float[] data, float threshold, float input_sample) {
        try {
            int n;
            float max = 1.0E-20f;
            int firstIndex = 1;
            int lastIndex = data.length - 2;
            int nearest = -99999;
            float min_dist = 1000000.0f;
            for (n = firstIndex; n <= lastIndex; ++n) {
                float dist;
                boolean peak = data[n] > data[n - 1] && data[n] >= data[n + 1];
                boolean bl = peak = peak || data[n] >= data[n - 1] && data[n] > data[n + 1];
                if (!peak || !((dist = Math.abs((float)n - input_sample)) < min_dist)) continue;
                min_dist = dist;
                nearest = n;
                max = data[n];
            }
            if (nearest < 0) {
                return -9999.0f;
            }
            if (data[0] >= (threshold *= max)) {
                return 0.0f;
            }
            for (n = nearest; n >= 1; --n) {
                if (data[n] <= threshold) {
                    double s = (threshold - data[n - 1]) / (data[n] - data[n - 1]);
                    return (float)(n - 1) + (float)s;
                }
                if (n > nearest - 1 || !(data[n] > data[n + 1])) continue;
                return 0.5f + (float)n;
            }
            return -9999.0f;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999.0f;
        }
    }

    public static float getThresholdTrough(float[] data, float threshold, boolean forceInsideSampleWindow, int sampleWindowCenter, int sampleWindowSize) {
        try {
            int n;
            float minGlobal = -1.0E-20f;
            float minInWindow = -1.0E-20f;
            float minSampleGlobal = -9999.0f;
            float minSampleInWindow = -9999.0f;
            int firstIndex = 1;
            int lastIndex = data.length - 2;
            int firstIndexClip = 1;
            int lastIndexClip = data.length - 2;
            for (n = firstIndex; n <= lastIndex; ++n) {
                if (!(data[n] < minGlobal)) continue;
                minSampleGlobal = n;
                minGlobal = data[n];
            }
            if (forceInsideSampleWindow) {
                int tempFirst = sampleWindowCenter - sampleWindowSize;
                firstIndexClip = Math.max(firstIndexClip, tempFirst);
                int tempLast = sampleWindowCenter + sampleWindowSize;
                lastIndexClip = Math.min(lastIndexClip, tempLast);
            }
            for (n = firstIndex; n <= lastIndex; ++n) {
                if (!(data[n] < minInWindow)) continue;
                minInWindow = data[n];
                minSampleInWindow = n;
            }
            if (minSampleGlobal < 0.0f) {
                return -9999.0f;
            }
            threshold *= minGlobal;
            for (n = firstIndex; n <= lastIndex; ++n) {
                boolean isGlobal;
                boolean isLocalLeft = data[n] <= data[n - 1] && data[n] < data[n + 1];
                boolean isLocalRight = data[n] < data[n - 1] && data[n] <= data[n + 1];
                boolean isLocal = isLocalLeft || isLocalRight;
                boolean bl = isGlobal = isLocal && data[n] <= threshold;
                if (n <= firstIndexClip || n >= lastIndexClip || !isGlobal) continue;
                return Tools_Picking.getNearestTrough(data, data.length, n, false);
            }
            return -9999.0f;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999.0f;
        }
    }

    public static float getNearestEvent(float[] data, int numValidSamples, PickEvent event, float startSample, boolean localOkay) {
        try {
            if (event == PickEvent.Peak) {
                return Tools_Picking.getNearestPeak(data, numValidSamples, startSample, localOkay);
            }
            if (event == PickEvent.Trough) {
                return Tools_Picking.getNearestTrough(data, numValidSamples, startSample, localOkay);
            }
            if (event == PickEvent.NoEvent) {
                return Tools_Picking.getShiftedPickNoSnap(data, numValidSamples, startSample, localOkay);
            }
            return -9999.0f;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999.0f;
        }
    }

    public static float getNearestTrough(float[] data, int numValidSamples, float startSample, boolean localOkay) {
        try {
            float midDist = 1.0E7f;
            float bestPeak = -9999.0f;
            numValidSamples = Math.min(numValidSamples, data.length);
            for (int n = 1; n < numValidSamples - 1; ++n) {
                boolean isGlobal;
                boolean isLocalLeft = data[n] <= data[n - 1] && data[n] < data[n + 1];
                boolean isLocalRight = data[n] < data[n - 1] && data[n] <= data[n + 1];
                boolean isLocal = isLocalLeft || isLocalRight;
                boolean bl = isGlobal = isLocal && data[n] < 0.0f;
                if (!isGlobal && (!isLocal || !localOkay)) continue;
                float a = 0.5f * (data[n + 1] + data[n - 1]) - data[n];
                float b = 0.5f * (data[n + 1] - data[n - 1]);
                float c = data[n];
                float shift = -b / (2.0f * a);
                float peak = (float)n + shift;
                float diff = Math.abs(startSample - peak);
                if (!(diff < midDist)) continue;
                midDist = diff;
                bestPeak = peak;
            }
            return bestPeak;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999.0f;
        }
    }

    public static float getNearestPeak(float[] data, int numValidSamples, float startSample, boolean localOkay) {
        try {
            float midDist = 1.0E7f;
            float bestPeak = -9999.0f;
            numValidSamples = Math.min(numValidSamples, data.length);
            for (int n = 1; n < numValidSamples - 1; ++n) {
                boolean isGlobal;
                boolean isLocalLeft = data[n] >= data[n - 1] && data[n] > data[n + 1];
                boolean isLocalRight = data[n] > data[n - 1] && data[n] >= data[n + 1];
                boolean isLocal = isLocalLeft || isLocalRight;
                boolean bl = isGlobal = isLocal && data[n] > 0.0f;
                if (!isGlobal && (!isLocal || !localOkay)) continue;
                float a = 0.5f * (data[n + 1] + data[n - 1]) - data[n];
                float b = 0.5f * (data[n + 1] - data[n - 1]);
                float c = data[n];
                float shift = -b / (2.0f * a);
                float peak = (float)n + shift;
                float diff = Math.abs(startSample - peak);
                if (!(diff < midDist)) continue;
                midDist = diff;
                bestPeak = peak;
            }
            return bestPeak;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999.0f;
        }
    }

    public static int getPeaksAndTroughs(boolean bGetPeaks, boolean bGetTroughs, float[] data, int numValidSamples, float traceStartTime, float windowStartTime, float windowLength, float sampleRate, float[] peaks, float[] amplitudes, int[] peakIndices) {
        boolean nPeaks = false;
        int iPeak = 0;
        try {
            float fStopTime = windowStartTime + windowLength;
            int nMaxPeaks = peaks.length;
            if (peaks.length != amplitudes.length) {
                throw new Exception("invalid peak amplitude length");
            }
            for (int i = 0; i < peaks.length; ++i) {
                peaks[i] = -9999.0f;
                amplitudes[i] = 0.0f;
                peakIndices[i] = 0;
            }
            float midDist = 1.0E7f;
            float bestPeak = -9999.0f;
            numValidSamples = Math.min(numValidSamples, data.length);
            for (int n = 1; n < numValidSamples - 1; ++n) {
                boolean isLocal;
                boolean isLocalRight;
                boolean isLocalLeft;
                boolean isPeak = false;
                boolean isTrough = false;
                if (bGetPeaks) {
                    isLocalLeft = data[n] >= data[n - 1] && data[n] > data[n + 1];
                    isLocalRight = data[n] > data[n - 1] && data[n] >= data[n + 1];
                    isLocal = isLocalLeft || isLocalRight;
                    boolean bl = isPeak = isLocal && data[n] > 0.0f;
                }
                if (bGetTroughs) {
                    isLocalLeft = data[n] <= data[n - 1] && data[n] < data[n + 1];
                    isLocalRight = data[n] < data[n - 1] && data[n] <= data[n + 1];
                    isLocal = isLocalLeft || isLocalRight;
                    boolean bl = isTrough = isLocal && data[n] < 0.0f;
                }
                if (!isPeak && !isTrough) continue;
                float a = 0.5f * (data[n + 1] + data[n - 1]) - data[n];
                float b = 0.5f * (data[n + 1] - data[n - 1]);
                float c = data[n];
                float shift = -b / (2.0f * a);
                float peak = (float)n + shift;
                if (!((peak = traceStartTime + peak * sampleRate) >= windowStartTime) || !(peak <= fStopTime) || iPeak >= nMaxPeaks) continue;
                float fAmplitude = data[n] - b * b / (4.0f * a);
                peakIndices[iPeak] = n;
                peaks[iPeak] = peak;
                amplitudes[iPeak] = fAmplitude;
                ++iPeak;
            }
            return iPeak;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0;
        }
    }

    public static float getShiftedPickNoSnap(float[] data, int numValidSamples, float startSample, boolean localOkay) {
        try {
            return startSample;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999.0f;
        }
    }
}

