/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.TraceTable;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Data.TraceTable.TraceTable_ScannerBase;
import com.PecosLibrary.Refraction.MoveoutTrendData;

public class TraceTable_Scanner_KillPicksUsingTrends
extends TraceTable_ScannerBase {
    protected MoveoutTrendData m_moveoutTrendData;
    protected float m_radius;
    protected String m_colName;
    protected int m_colIndex = -9999;

    public TraceTable_Scanner_KillPicksUsingTrends(String colName, float radius, MoveoutTrendData mtd) {
        try {
            this.m_moveoutTrendData = mtd;
            this.m_radius = Math.max(radius, 5.0f);
            this.m_colName = colName;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void work() throws Exception {
        try {
            if (this.m_colIndex > 1000) {
                return;
            }
            if (this.m_colIndex < 0) {
                this.m_colIndex = this.m_traceTable.column_exists(this.m_colName) ? this.m_traceTable.column_indexOfColumn(this.m_colName) : 100000;
            }
            if (this.m_colIndex > 1000) {
                return;
            }
            float time = this.m_moveoutTrendData.getTime(this.m_midX, this.m_midY, (float)this.m_offset, true);
            float min = time - this.m_radius;
            float max = time + this.m_radius;
            float pick = this.m_traceTable.getFloat(this.m_traceRow, this.m_colIndex);
            if (pick < min || pick > max) {
                this.m_traceTable.putFloat(this.m_traceRow, this.m_colIndex, -9999.0f);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void finishScan() throws Exception {
    }
}

