/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.TraceTable;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Data.TraceTable.TraceTable_ScannerBase;

public class TraceTable_Scanner_ComputeBinNumber
extends TraceTable_ScannerBase {
    protected int m_inlineMin = Integer.MAX_VALUE;
    protected int m_inlineMax = Integer.MIN_VALUE;
    protected int m_crosslineMin = Integer.MAX_VALUE;
    protected int m_crosslineMax = Integer.MIN_VALUE;
    protected boolean m_firstScan = true;
    protected int m_indexBinLabel;
    protected int m_minCDP = Integer.MAX_VALUE;
    protected int m_maxCDP = Integer.MIN_VALUE;

    public TraceTable_Scanner_ComputeBinNumber(ITraceTable traceTable) {
        try {
            this.scan(traceTable, null);
            this.m_firstScan = false;
            this.m_indexBinLabel = traceTable.column_append("CDP", DataType.Int);
            this.scan(traceTable, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void finishScan() throws Exception {
        try {
            System.out.println("Min CDP: " + this.m_minCDP);
            System.out.println("Max CDP: " + this.m_maxCDP);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void work() throws Exception {
        try {
            if (this.m_firstScan) {
                this.m_inlineMin = Math.min(this.m_inlineMin, this.m_inlineBin);
                this.m_inlineMax = Math.max(this.m_inlineMax, this.m_inlineBin);
                this.m_crosslineMin = Math.min(this.m_crosslineMin, this.m_crosslineBin);
                this.m_crosslineMax = Math.max(this.m_crosslineMax, this.m_crosslineBin);
                return;
            }
            int numInline = 1 + this.m_inlineMax - this.m_inlineMin;
            int numCrossline = 1 + this.m_crosslineMax - this.m_crosslineMin;
            int crosslineIndex = this.m_crosslineBin - this.m_crosslineMin;
            int inlineIndex = this.m_inlineBin - this.m_inlineMin;
            int bin = 1 + crosslineIndex * numInline + inlineIndex;
            if (bin > this.m_maxCDP) {
                this.m_maxCDP = bin;
            }
            if (bin < this.m_minCDP) {
                this.m_minCDP = bin;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

