/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.TraceTable;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Data.TraceTable.TraceTable_ScannerBase;

public class TraceTable_Scanner_AsciiCoordImport
extends TraceTable_ScannerBase {
    protected HashMap_Integers<ShotCoordData> m_map;
    protected int m_indexCol;
    protected DataType m_type;
    protected double m_scalar;
    protected boolean m_importCoords = false;
    protected boolean m_importFFID = false;
    protected boolean m_importFFIDPointNumber = false;
    protected boolean m_importCombinedLinePoint = false;
    public boolean OverwriteValidPicks = true;
    protected HashMap_Integers<ShotFFIDData> m_mapFFID;
    protected HashMap_Integers<ShotLinePointData> m_mapCombined;
    protected int m_indexFFID = -9999;
    protected int m_indexChannel = -9999;
    protected int m_indexPointNumber = -9999;
    protected int m_numError = 0;

    public TraceTable_Scanner_AsciiCoordImport(ITraceTableScannerMonitor monitor, double scalar, ITraceTable traceTable, HashMap_Integers<ShotCoordData> map, String column) {
        try {
            this.m_importCoords = true;
            this.m_monitor = monitor;
            this.m_scalar = scalar;
            this.m_map = map;
            this.m_indexCol = traceTable.column_indexOfColumn(column);
            this.m_type = traceTable.column_type(this.m_indexCol);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public TraceTable_Scanner_AsciiCoordImport(ITraceTableScannerMonitor monitor, ITraceTable traceTable, HashMap_Integers<ShotFFIDData> map, String column, boolean usePointNumber) {
        try {
            if (usePointNumber) {
                this.m_importFFIDPointNumber = true;
            } else {
                this.m_importFFID = true;
            }
            this.m_monitor = monitor;
            this.m_mapFFID = map;
            this.m_indexCol = traceTable.column_indexOfColumn(column);
            this.m_type = traceTable.column_type(this.m_indexCol);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public TraceTable_Scanner_AsciiCoordImport(ITraceTableScannerMonitor monitor, ITraceTable traceTable, HashMap_Integers<ShotLinePointData> map, String column) {
        try {
            this.m_importCombinedLinePoint = true;
            this.m_monitor = monitor;
            this.m_mapCombined = map;
            this.m_indexCol = traceTable.column_indexOfColumn(column);
            this.m_type = traceTable.column_type(this.m_indexCol);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void finishScan() throws Exception {
    }

    @Override
    public void work() throws Exception {
        try {
            ShotLinePointData sd;
            ShotFFIDData ffidData;
            int ffid;
            int currentPick = this.m_traceTable.getInt(this.m_traceRow, this.m_indexCol);
            if (currentPick >= -800 && !this.OverwriteValidPicks) {
                return;
            }
            if (this.m_importFFIDPointNumber) {
                if (this.m_indexFFID < 0) {
                    this.m_indexFFID = this.m_shotTable.column_indexOfColumn("FFID");
                }
                if (this.m_indexPointNumber < 0) {
                    this.m_indexPointNumber = this.m_recTable.column_indexOfColumn("PointNumber");
                }
                ffid = this.m_shotTable.getInt(this.m_shotRow, this.m_indexFFID);
                int point = this.m_recTable.getInt(this.m_recRow, this.m_indexPointNumber);
                if (!this.m_mapFFID.containsKey(ffid)) {
                    return;
                }
                ffidData = this.m_mapFFID.get(ffid);
                if (ffidData.hasChan(point)) {
                    if (this.m_type == DataType.Float) {
                        this.m_traceTable.putFloat(this.m_traceRow, this.m_indexCol, ffidData.Selected);
                    } else if (this.m_type == DataType.Int) {
                        this.m_traceTable.putInt(this.m_traceRow, this.m_indexCol, (int)ffidData.Selected);
                    }
                }
            }
            if (this.m_importFFID) {
                if (this.m_indexFFID < 0) {
                    this.m_indexFFID = this.m_shotTable.column_indexOfColumn("FFID");
                }
                if (this.m_indexChannel < 0) {
                    this.m_indexChannel = this.m_traceTable.column_indexOfColumn("Channel");
                }
                ffid = this.m_shotTable.getInt(this.m_shotRow, this.m_indexFFID);
                int chan = this.m_traceTable.getInt(this.m_traceRow, this.m_indexChannel);
                if (!this.m_mapFFID.containsKey(ffid)) {
                    return;
                }
                ffidData = this.m_mapFFID.get(ffid);
                if (ffidData.hasChan(chan)) {
                    if (this.m_type == DataType.Float) {
                        if (Math.abs(ffidData.Selected - this.m_fbp) > 2.0f) {
                            ++this.m_numError;
                        }
                        this.m_traceTable.putFloat(this.m_traceRow, this.m_indexCol, ffidData.Selected);
                    } else if (this.m_type == DataType.Int) {
                        if (Math.abs(ffidData.Selected - this.m_fbp) > 2.0f) {
                            ++this.m_numError;
                        }
                        this.m_traceTable.putInt(this.m_traceRow, this.m_indexCol, (int)ffidData.Selected);
                    }
                }
            }
            if (this.m_importCoords) {
                ShotCoordData sd2;
                int isx = (int)(0.5 + this.m_scalar * this.m_shotX);
                int isy = (int)(0.5 + this.m_scalar * this.m_shotY);
                int irx = (int)(0.5 + this.m_scalar * this.m_recX);
                int iry = (int)(0.5 + this.m_scalar * this.m_recY);
                if (this.m_map.containsKey(isx, isy) && (sd2 = this.m_map.get(isx, isy)).hasRec(irx, iry)) {
                    if (this.m_type == DataType.Float) {
                        if (sd2.Selected > 1.0f && Math.abs(sd2.Selected - this.m_fbp) > 2.0f) {
                            ++this.m_numError;
                        }
                        this.m_traceTable.putFloat(this.m_traceRow, this.m_indexCol, sd2.Selected);
                    } else if (this.m_type == DataType.Int) {
                        if (sd2.Selected > 1.0f && Math.abs(sd2.Selected - this.m_fbp) > 2.0f) {
                            ++this.m_numError;
                        }
                        this.m_traceTable.putInt(this.m_traceRow, this.m_indexCol, (int)sd2.Selected);
                    }
                }
            }
            if (this.m_importCombinedLinePoint && this.m_mapCombined.containsKey(this.m_shotLine, this.m_shotPoint) && (sd = this.m_mapCombined.get(this.m_shotLine, this.m_shotPoint)).hasRec(this.m_recLine, this.m_recPoint)) {
                if (this.m_type == DataType.Float) {
                    if (sd.Selected > 1.0f && Math.abs(sd.Selected - this.m_fbp) > 2.0f) {
                        ++this.m_numError;
                    }
                    this.m_traceTable.putFloat(this.m_traceRow, this.m_indexCol, sd.Selected);
                } else if (this.m_type == DataType.Int) {
                    if (sd.Selected > 1.0f && Math.abs(sd.Selected - this.m_fbp) > 2.0f) {
                        ++this.m_numError;
                    }
                    this.m_traceTable.putInt(this.m_traceRow, this.m_indexCol, (int)sd.Selected);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static class ShotFFIDData {
        public int FFID;
        public int Count = 0;
        public int[] Chan;
        public float[] Pick;
        public int Num = 0;
        public float Selected;

        public ShotFFIDData(int ffid) {
            this.FFID = ffid;
        }

        public void allocate() {
            this.Num = 0;
            this.Chan = new int[this.Count];
            this.Pick = new float[this.Count];
        }

        public boolean hasChan(int chan) {
            for (int n = 0; n < this.Num; ++n) {
                if (chan != this.Chan[n]) continue;
                this.Selected = this.Pick[n];
                return true;
            }
            return false;
        }

        public void add(int chan, float pick) {
            try {
                if (this.Num >= this.Count) {
                    return;
                }
                this.Chan[this.Num] = chan;
                this.Pick[this.Num] = pick;
                ++this.Num;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }

    public static class ShotCoordData {
        public int X;
        public int Y;
        public int Count = 0;
        public int[] RX;
        public int[] RY;
        public float[] Pick;
        public int Num = 0;
        public float Selected;

        public ShotCoordData(int x, int y) {
            this.X = x;
            this.Y = y;
        }

        public void allocate() {
            this.Num = 0;
            this.RX = new int[this.Count];
            this.RY = new int[this.Count];
            this.Pick = new float[this.Count];
        }

        public boolean hasRec(int rx, int ry) {
            for (int n = 0; n < this.Num; ++n) {
                if (rx != this.RX[n] || ry != this.RY[n]) continue;
                this.Selected = this.Pick[n];
                return true;
            }
            return false;
        }

        public void add(int rx, int ry, float pick) {
            try {
                if (this.Num >= this.Count) {
                    return;
                }
                this.RX[this.Num] = rx;
                this.RY[this.Num] = ry;
                this.Pick[this.Num] = pick;
                ++this.Num;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }

    public static class ShotLinePointData {
        public int ShotLine;
        public int ShotPoint;
        public int Count = 0;
        public int[] RecLine;
        public int[] RecPoint;
        public float[] Pick;
        public int Num = 0;
        public float Selected;

        public ShotLinePointData(int line, int point) {
            this.ShotLine = line;
            this.ShotPoint = point;
        }

        public void allocate() {
            this.Num = 0;
            this.RecLine = new int[this.Count];
            this.RecPoint = new int[this.Count];
            this.Pick = new float[this.Count];
        }

        public boolean hasRec(int line, int point) {
            for (int n = 0; n < this.Num; ++n) {
                if (line != this.RecLine[n] || point != this.RecPoint[n]) continue;
                this.Selected = this.Pick[n];
                return true;
            }
            return false;
        }

        public void add(int line, int point, float pick) {
            try {
                if (this.Num >= this.Count) {
                    return;
                }
                this.RecLine[this.Num] = line;
                this.RecPoint[this.Num] = point;
                this.Pick[this.Num] = pick;
                ++this.Num;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }
}

