/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class Table_CustomModel
extends AbstractTableModel {
    protected Table_Abstract m_table;
    protected boolean[][] m_editable;

    public Table_CustomModel(Table_Abstract table) {
        try {
            this.m_table = table;
            this.m_editable = new boolean[this.m_table.row_count()][this.m_table.column_count()];
            for (int r = 0; r < this.m_table.row_count(); ++r) {
                Arrays.fill(this.m_editable[r], false);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setRowEditable(int row, boolean editable) {
        for (int c = 0; c < this.m_table.column_count(); ++c) {
            this.m_editable[row][c] = editable;
        }
    }

    public void setColumnEditable(int column, boolean editable) {
        for (int r = 0; r < this.m_table.row_count(); ++r) {
            this.m_editable[r][column] = editable;
        }
    }

    public void setCellEditable(int row, int column, boolean editable) {
        this.m_editable[row][column] = editable;
    }

    public ComboCellEditor getComboCellEditor(List list) {
        return new ComboCellEditor(list);
    }

    public ComboCellRenderer getComboCellRenderer() {
        return new ComboCellRenderer();
    }

    public BoldCellRenderer getBoldCellRenderer() {
        return new BoldCellRenderer();
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        try {
            if (obj == null) {
                return;
            }
            if (!(obj instanceof String)) {
                return;
            }
            String str = (String)obj;
            if (str.length() < 3) {
                return;
            }
            this.m_table.putString(row, col, str);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.m_editable[row][column];
    }

    @Override
    public String getColumnName(int column) {
        try {
            return this.m_table.column_name(column);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    @Override
    public int getRowCount() {
        if (this.m_table == null) {
            return 0;
        }
        return this.m_table.row_count();
    }

    @Override
    public int getColumnCount() {
        if (this.m_table == null) {
            return 0;
        }
        return this.m_table.column_count();
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            return this.m_table.getString(row, column, 5);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    public Table_Abstract getTable() {
        return this.m_table;
    }

    public class ComboCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        protected String m_selectedTable;
        protected List<String> m_tableList;

        public ComboCellEditor(List<String> tableList) {
            this.m_tableList = tableList;
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_selectedTable;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof String) {
                this.m_selectedTable = (String)value;
            }
            JComboBox<String> box = new JComboBox<String>();
            for (String item : this.m_tableList) {
                box.addItem(item);
            }
            box.setSelectedItem(value);
            box.addActionListener(this);
            return box;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JComboBox box = (JComboBox)event.getSource();
            this.m_selectedTable = (String)box.getSelectedItem();
        }
    }

    public class ComboCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof String) {
                String selectedTable = (String)value;
                this.setText(selectedTable);
            }
            return this;
        }
    }

    public class BoldCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cellComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            cellComponent.setFont(cellComponent.getFont().deriveFont(1));
            return this;
        }
    }
}

