/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.Sort;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Shared.ExceptionMonitor;
import java.nio.ByteBuffer;
import java.util.Comparator;

public class SortTrace {
    public int Key1 = -9999;
    public int Key2 = -9999;
    public long TraceTableRow = -9999L;
    public int SampleCount = 0;
    public float SampleInterval = 4.0f;
    public float Time0 = 0.0f;
    public float Scalar = 0.0f;
    public short[] Data = null;
    public static final int HeaderByteCount = 40;
    public static final int Offset_Key1 = 0;
    public static final int Offset_Key2 = 4;
    public static final int Offset_TraceTableRow = 8;
    public static final int Offset_SampleCount = 16;
    public static final int Offset_SampleInterval = 20;
    public static final int Offset_Time0 = 24;
    public static final int Offset_Scalar = 28;

    public SortTrace(int arrayLength) {
        try {
            this.Data = new short[arrayLength];
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setValues(int key1, int key2, long tableRow, FloatArrayWrapper data) {
        try {
            this.Key1 = key1;
            this.Key2 = key2;
            this.TraceTableRow = tableRow;
            this.SampleInterval = data.getSampleInterval();
            this.Time0 = data.getFirstSampleCoord_Initial();
            this.SampleCount = data.length();
            for (int s = 0; s < this.Data.length; ++s) {
                this.Data[s] = 0;
            }
            this.Scalar = data.fillShortArray(this.Data);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void readFromBuffer(ByteBuffer buffer, int offset) {
        try {
            this.Key1 = buffer.getInt(offset + 0);
            this.Key2 = buffer.getInt(offset + 4);
            this.TraceTableRow = buffer.getInt(offset + 8);
            this.SampleCount = buffer.getInt(offset + 16);
            this.SampleInterval = buffer.getFloat(offset + 20);
            this.Time0 = buffer.getFloat(offset + 24);
            this.Scalar = buffer.getFloat(offset + 28);
            if (this.SampleCount > 0) {
                this.Data = new short[this.SampleCount];
                int off = offset + 40;
                for (int n = 0; n < this.SampleCount; ++n) {
                    this.Data[n] = buffer.getShort(off);
                    off += 2;
                }
            } else {
                this.Data = null;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void writeToBuffer(ByteBuffer buffer, int offset) {
        try {
            buffer.putInt(offset + 0, this.Key1);
            buffer.putInt(offset + 4, this.Key2);
            buffer.putLong(offset + 8, this.TraceTableRow);
            buffer.putInt(offset + 16, this.SampleCount);
            buffer.putFloat(offset + 20, this.SampleInterval);
            buffer.putFloat(offset + 24, this.Time0);
            buffer.putFloat(offset + 28, this.Scalar);
            if (this.SampleCount > 0) {
                int off = offset + 40;
                for (int n = 0; n < this.SampleCount; ++n) {
                    buffer.putShort(off, this.Data[n]);
                    off += 2;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static class Sorter
    implements Comparator<SortTrace> {
        @Override
        public int compare(SortTrace t1, SortTrace t2) {
            try {
                if (t1.Key1 > t2.Key1) {
                    return 1;
                }
                if (t1.Key1 < t2.Key1) {
                    return -1;
                }
                if (t1.Key2 > t2.Key2) {
                    return 1;
                }
                if (t1.Key2 < t2.Key2) {
                    return -1;
                }
                return 0;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return 0;
            }
        }
    }
}

