/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.Sort;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Data.Sort.SortEntry;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class SortManager {
    protected HashMap_Integers<SortEntry> m_hash = new HashMap_Integers();
    protected ArrayList<SortEntry> m_list = new ArrayList();
    protected String m_sortPath = "";
    protected String m_fileName_Data = "";
    protected String m_fileName_Dictionary = "";
    protected boolean m_valid = false;
    protected int m_bytesPerTrace;
    protected int m_maxSamplesPerTrace;
    protected float[] m_tempArray = new float[1000];

    public boolean valid() {
        return this.m_valid;
    }

    public SortManager(String path) {
        try {
            this.m_sortPath = path;
            this.m_fileName_Data = this.m_sortPath + "/sort.data";
            this.m_fileName_Dictionary = this.m_sortPath + "/sort.map";
            if (!Tools_FileSystem.exists_file(this.m_fileName_Data)) {
                return;
            }
            if (!Tools_FileSystem.exists_file(this.m_fileName_Dictionary)) {
                return;
            }
            RandomAccessFile dictFile = new RandomAccessFile(this.m_fileName_Dictionary, "rw");
            int version = dictFile.readInt();
            if (version == 1000) {
                this.m_maxSamplesPerTrace = dictFile.readInt();
                this.m_bytesPerTrace = dictFile.readInt();
                int count = dictFile.readInt();
                for (int n = 0; n < count; ++n) {
                    this.m_list.add(new SortEntry(dictFile));
                }
            } else {
                dictFile.close();
                return;
            }
            dictFile.close();
            for (SortEntry entry : this.m_list) {
                this.m_hash.put(entry, entry.Key1, entry.Key2);
            }
            this.m_valid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void populateEnsemble(Ensemble ensemble, int key1, int key2) {
        try {
            if (!this.hasEntry(key1, key2)) {
                return;
            }
            SortEntry entry = this.m_hash.get(key1, key2);
            int totalBytes = entry.Count * this.m_bytesPerTrace;
            ByteBuffer buffer = ByteBuffer_Shared.buffer(0, totalBytes + 10000);
            RandomAccessFile file = new RandomAccessFile(this.m_fileName_Data, "rw");
            long position = entry.FilePosition * (long)this.m_bytesPerTrace;
            file.seek(position);
            file.read(buffer.array(), 0, totalBytes);
            file.close();
            int indexTraceRow = ensemble.dictionary().addEntry("Trace", "TraceIndex", DataType.Long);
            for (int n = 0; n < entry.Count; ++n) {
                int bufferOffset = n * this.m_bytesPerTrace;
                long traceRow = buffer.getInt(bufferOffset + 8);
                int k1 = buffer.getInt(bufferOffset + 0);
                int k2 = buffer.getInt(bufferOffset + 4);
                if (k1 != key1 || k2 != key2) {
                    throw new Exception("((k1 != key1) || (k2 != key2))");
                }
                int sampleCount = buffer.getInt(bufferOffset + 16);
                float scalar = buffer.getFloat(bufferOffset + 28);
                float invScalar = 1.0f / scalar;
                float digi = buffer.getFloat(bufferOffset + 20);
                float time0 = buffer.getFloat(bufferOffset + 24);
                bufferOffset += 40;
                if (this.m_tempArray.length < sampleCount) {
                    this.m_tempArray = new float[sampleCount + 100];
                }
                for (int s = 0; s < sampleCount; ++s) {
                    this.m_tempArray[s] = invScalar * (float)buffer.getShort(bufferOffset + 2 * s);
                }
                EnsembleTrace trace = ensemble.addTrace();
                trace.data().insertArray(this.m_tempArray, sampleCount);
                trace.data().setSampleInterval(digi);
                trace.data().setFirstSampleCoord(time0);
                trace.header().putLong(indexTraceRow, traceRow);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean hasEntry(int key1, int key2) {
        try {
            return this.m_hash.containsKey(key1, key2);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }
}

