/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Application;

import com.PecosCore.Plugins.PluginManager;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Echos.EchosUserDialog;
import com.PecosLibrary.Windows.Segy.AppFrame_Segy;
import com.PecosLibrary.Windows.Shear.AppFrame_PecosShear;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class WhichWizardDialog
extends JDialog
implements ActionListener {
    public Function WhichFunction = Function.Cancel;
    protected JButton m_btnCancel;
    protected JButton m_btnImportGLI;
    protected JButton m_btnImportBinaryPickFiles;
    protected JButton m_btnImportSegyExp;
    protected JButton m_btnImportMarine2D;
    protected JButton m_btnOpenProject;
    protected JButton m_btnImportMultiple;
    protected JButton m_btnImportEchos;
    protected JButton m_btnMerge;
    protected JButton m_btnSegyViewer;
    protected JButton m_btnSetEchosUser;
    protected JButton m_btnSyn2D;
    protected JButton m_btnShearRotate;
    protected JButton m_btnSelectHome;
    protected JLabel m_lblHome = new JLabel();
    protected HashMap<Integer, JButton> m_pluginBtnMap = new HashMap();
    protected HashMap<Integer, String> m_pluginNameMap = new HashMap();

    public WhichWizardDialog(String title) {
        try {
            if (title != null) {
                this.setTitle(title);
            }
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = LinearLayoutWidget.vert(3, null);
            LinearLayoutWidget home = main.createHorizontal(3, "XtremeGeo working directory (CanonHome)", 0);
            home.addComponent(this.m_lblHome, 10);
            this.m_lblHome.setBorder(BorderFactory.createRaisedBevelBorder());
            this.m_lblHome.setText(SharedApplicationData.singleton().homeDirectory());
            this.m_btnSelectHome = home.createButton("Select...", this, 0);
            SharedApplicationData gd = SharedApplicationData.singleton();
            String canonHome = gd.homeDirectory();
            boolean shear = canonHome.toLowerCase().contains("matt") && canonHome.toLowerCase().contains("users");
            LinearLayoutWidget sub = main.createVertical(0, "Select operation", 0);
            this.m_btnOpenProject = sub.createButton("Open existing project", this, 0);
            sub = main.createVertical(0, "New project options", 0);
            this.m_btnImportSegyExp = sub.createButton("Create a new project based on SEG-Y files", this, 0);
            this.m_btnImportEchos = sub.createButton("Create a new project based on Echos", this, 0);
            this.m_btnImportMarine2D = sub.createButton("Create a new project based on SEG-Y files - (Marine 2D test code)", this, 0);
            this.m_btnImportBinaryPickFiles = sub.createButton("Create a new project based on binary pick files", this, 0);
            this.m_btnImportGLI = sub.createButton("Create a new project based on GLI files", this, 0);
            this.m_btnMerge = sub.createButton("Create a new project by merging existing projects", this, 0);
            this.m_btnImportMultiple = sub.createButton("Multiple project creation using SEGY files", this, 0);
            ArrayList pluginList = PluginManager.singleton().getPluginList();
            int index = 0;
            for (String plugin : pluginList) {
                String label = this.getPluginImportLabel(plugin);
                if (label == null || label.length() <= 0) continue;
                JButton button = sub.createButton(label, this, 0);
                this.m_pluginBtnMap.put(index, button);
                this.m_pluginNameMap.put(index, plugin);
                ++index;
            }
            sub = main.createVertical(0, "Additional options", 0);
            this.m_btnSegyViewer = sub.createButton("Open the SEG-Y viewer and dictionary editor", this, 0);
            this.m_btnSetEchosUser = sub.createButton("Set Echos User", this, 0);
            if (shear) {
                this.m_btnShearRotate = sub.createButton("Shear data rotation", this, 0);
            }
            this.m_btnCancel = main.createButton("Cancel", this, 0);
            String txtCopyright = "\u00a9 2010-2025 XtremeGeo LLC.  All rights reserved.";
            JLabel copyright = main.createLabel(txtCopyright, 0, 2);
            this.getContentPane().add((Component)main, "Center");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(this.getWidth() + 150, this.getHeight());
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
            this.setTitle("Flatirons Application Launcher");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object home2;
            if (e.getSource() == this.m_btnSelectHome) {
                String home2 = Tools_Chooser.getDirectory("Select XtremeGeo home directory");
                if (Tools_FileSystem.exists_path(home2)) {
                    SharedApplicationData.singleton().setHomePath(home2);
                    this.m_lblHome.setText(SharedApplicationData.singleton().homeDirectory());
                }
                return;
            }
            if (e.getSource() == this.m_btnImportMarine2D) {
                this.WhichFunction = Function.ImportMarine2D;
                this.dispose();
            }
            if (e.getSource() == this.m_btnSyn2D) {
                this.WhichFunction = Function.Synthetic2D;
                this.dispose();
            }
            if (e.getSource() == this.m_btnShearRotate) {
                home2 = new AppFrame_PecosShear();
            }
            if (e.getSource() == this.m_btnSegyViewer) {
                home2 = new AppFrame_Segy(true);
            }
            if (e.getSource() == this.m_btnSetEchosUser) {
                EchosUserDialog.setEchosUserName();
            }
            if (e.getSource() == this.m_btnOpenProject) {
                this.WhichFunction = Function.OpenProject;
                this.dispose();
            }
            if (e.getSource() == this.m_btnImportBinaryPickFiles) {
                this.WhichFunction = Function.ImportBinaryPickFiles;
                this.dispose();
            }
            if (e.getSource() == this.m_btnImportGLI) {
                this.WhichFunction = Function.ImportGLI;
                this.dispose();
            }
            if (e.getSource() == this.m_btnImportMultiple) {
                this.WhichFunction = Function.ImportMultiple;
                this.dispose();
            }
            if (e.getSource() == this.m_btnImportEchos) {
                this.WhichFunction = Function.ImportECHOS;
                this.dispose();
            }
            if (e.getSource() == this.m_btnImportSegyExp) {
                this.WhichFunction = Function.ImportSegyExp;
                this.dispose();
            }
            if (e.getSource() == this.m_btnMerge) {
                this.WhichFunction = Function.Merge;
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.WhichFunction = Function.Cancel;
                this.dispose();
            }
            if (this.m_pluginBtnMap.keySet() != null) {
                for (Integer key : this.m_pluginBtnMap.keySet()) {
                    JButton button = this.m_pluginBtnMap.get(key);
                    if (e.getSource() != button) continue;
                    String name = this.m_pluginNameMap.get(key);
                    PluginManager.singleton().setCurrentPlugin(name);
                    this.WhichFunction = Function.ImportPlugin;
                    this.dispose();
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected String getPluginImportLabel(String pluginName) {
        try {
            if (pluginName.equalsIgnoreCase("Flatirons_Omega")) {
                return "Create a new project based on DIO files (SLB/Omega)";
            }
            if (pluginName.equalsIgnoreCase("Flatirons_Seisspace")) {
                return "Create a new project based on ProMAX/SeisSpace files";
            }
            return null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static enum Function {
        Cancel,
        ImportSegy,
        ImportSegyExp,
        ImportGLI,
        ImportBinaryPickFiles,
        ImportSei2D,
        ImportMarine2D,
        OpenProject,
        Merge,
        SegyViewer,
        Synthetic2D,
        ImportMultiple,
        ImportECHOS,
        ImportPlugin;

    }
}

