/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Tomography;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3DProfile;

public class Action_Eikonal3D_SimpleThreads
extends Action_Base {
    public int NumThreads = 2;
    public int NumIter = 10;
    public double MaxOffset = 12000.0;
    public double MinOffset = 0.0;
    public double OffsetCorner = 1000.0;
    public int SmoothRadius = 3;
    public boolean SaveAfterEachIter = false;
    public String PickVersion = "FBP_User";
    public double PickShift = 0.0;
    public TomoEikonal3D Model;
    public boolean ApplyAzimuthLimits = false;
    public double AzimuthCenter = 0.0;
    public double AzimuthRadius = 0.7853981633974483;
    public boolean ComputeHybridTimeShifts = false;
    public double HybridLMOVelocity = 20000.0;
    public double HybridTimeShifts = 200.0;
    public boolean ApplyDecimation = false;
    public int Decimation = 1;
    public boolean Uphole_LockShallow = false;
    public String Uphole_Table = "";
    public String Uphole_X = "";
    public String Uphole_Y = "";
    public String Uphole_Z = "";
    public String Uphole_V = "";

    public Action_Eikonal3D_SimpleThreads() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "3D Eikonal model update";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
        this.RequiresCompleteTraceTable = true;
        this.DelayTimeDataModified = false;
    }

    protected HashMap_Integers<TomoEikonal3D.Element> finishMap(Table_Abstract table, String colNameID, HashMap_Integers<TomoEikonal3D.Element> map) {
        try {
            HashMap_Integers<TomoEikonal3D.Element> newMap = new HashMap_Integers<TomoEikonal3D.Element>();
            int index = table.column_indexOfColumn(colNameID);
            for (TomoEikonal3D.Element e : map.getValues()) {
                e.ID = table.getInt(e.ID, index);
                e.Residual /= e.Count;
                e.Error /= e.Count;
                e.ComputedResidual = e.Residual;
                newMap.put(e, e.ID);
            }
            return newMap;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected class LocalThread
    extends Thread {
        protected ThreadData m_td;

        public LocalThread(ThreadData td) {
            this.m_td = td;
        }

        @Override
        public void run() {
            try {
                this.m_td.run();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }

    protected class ThreadData {
        public TomoEikonal3D ThreadModel;
        public TomoEikonal3DProfile Profile;
        public int ID;
        public long TotalTraces = 0L;
        public Table_Abstract ShotTable;
        public int ShotIndexX;
        public int ShotIndexY;
        public int ShotIndexZ;
        public int ShotIndexDepth = -9999;
        public Table_Abstract ReceiverTable;
        public int ReceiverIndexX;
        public int ReceiverIndexY;
        public int ReceiverIndexZ;
        public long[] TraceRow;
        public short[] Hybrid;
        public int[] ShotRow;
        public int[] ReceiverRow;
        public float[] Pick;
        public int NumPicks = 0;
        public HashMap_Integers<TomoEikonal3D.Element> SrcHash = new HashMap_Integers();
        public HashMap_Integers<TomoEikonal3D.Element> RecHash = new HashMap_Integers();
        public int Iteration;
        public int NumIter;
        public double SumError;
        public double AverageError;
        public double ErrorCount;

        public ThreadData(int id, TomoEikonal3D parentModel, int maxPickCount) {
            try {
                this.ID = id;
                this.ThreadModel = new TomoEikonal3D(parentModel);
                this.Profile = this.ThreadModel.createNewProfile();
                maxPickCount = 100 + Math.max(maxPickCount, 1000);
                this.ShotRow = new int[maxPickCount];
                this.ReceiverRow = new int[maxPickCount];
                this.TraceRow = new long[maxPickCount];
                this.Hybrid = new short[maxPickCount];
                this.Pick = new float[maxPickCount];
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                this.ReceiverTable = project.receiverTable();
                this.ReceiverIndexX = this.ReceiverTable.column_indexOfColumn("Easting");
                this.ReceiverIndexY = this.ReceiverTable.column_indexOfColumn("Northing");
                this.ReceiverIndexZ = this.ReceiverTable.column_indexOfColumn("Elevation");
                this.ShotTable = project.shotTable();
                this.ShotIndexX = this.ShotTable.column_indexOfColumn("Easting");
                this.ShotIndexY = this.ShotTable.column_indexOfColumn("Northing");
                this.ShotIndexZ = this.ShotTable.column_indexOfColumn("Elevation");
                if (this.ShotTable.column_exists("PointDepth")) {
                    this.ShotIndexDepth = this.ShotTable.column_indexOfColumn("PointDepth");
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void addPick(float pick, int shotRow, int recRow, long traceRow) {
            try {
                if (this.NumPicks >= this.ShotRow.length) {
                    return;
                }
                this.TraceRow[this.NumPicks] = traceRow;
                this.Pick[this.NumPicks] = pick;
                this.ReceiverRow[this.NumPicks] = recRow;
                this.ShotRow[this.NumPicks] = shotRow;
                ++this.NumPicks;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        protected void updateElement(HashMap_Integers<TomoEikonal3D.Element> map, int row, float error) {
            try {
                if (!map.containsKey(row)) {
                    map.put(new TomoEikonal3D.Element(row), row);
                }
                TomoEikonal3D.Element element = map.get(row);
                element.addError(error);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void updateParentHash(HashMap_Integers<TomoEikonal3D.Element> parent, HashMap_Integers<TomoEikonal3D.Element> map) {
            try {
                for (TomoEikonal3D.Element childElement : map.getValues()) {
                    int row = childElement.ID;
                    if (!parent.containsKey(row)) {
                        parent.put(new TomoEikonal3D.Element(row), row);
                    }
                    TomoEikonal3D.Element parentElement = parent.get(row);
                    parentElement.Count += childElement.Count;
                    parentElement.Error += childElement.Error;
                    parentElement.Residual += childElement.Residual;
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void run() {
            try {
                this.SrcHash.clear();
                this.RecHash.clear();
                System.out.println("run started for ID = " + this.ID);
                int zSpray = 3;
                if (this.Iteration >= 4) {
                    zSpray = 2;
                }
                float scalarSprayZ = 0.5f;
                if (this.Iteration >= 4) {
                    scalarSprayZ = 0.3f;
                }
                this.AverageError = 0.0;
                this.SumError = 0.0;
                this.ErrorCount = 1.0E-10;
                double straightLineTransition = 5.0 * Math.max(this.ThreadModel.binSizeHorz(), this.ThreadModel.binSizeVert());
                for (int n = 0; n < this.NumPicks && !Action_Eikonal3D_SimpleThreads.this.Halt; ++n) {
                    ++this.TotalTraces;
                    int shotRow = this.ShotRow[n];
                    int recRow = this.ReceiverRow[n];
                    float pick = this.Pick[n];
                    double sx = this.ShotTable.getDouble(shotRow, this.ShotIndexX);
                    double sy = this.ShotTable.getDouble(shotRow, this.ShotIndexY);
                    double sz = this.ShotTable.getDouble(shotRow, this.ShotIndexZ);
                    double sd = 0.0;
                    if (this.ShotIndexDepth >= 0) {
                        sd = this.ShotTable.getDouble(shotRow, this.ShotIndexDepth);
                    }
                    double rx = this.ReceiverTable.getDouble(recRow, this.ReceiverIndexX);
                    double ry = this.ReceiverTable.getDouble(recRow, this.ReceiverIndexY);
                    double rz = this.ReceiverTable.getDouble(recRow, this.ReceiverIndexZ);
                    double dx = sx - rx;
                    double dy = sy - ry;
                    double off = Math.sqrt(dx * dx + dy * dy + 0.01);
                    double offsetWeight = Action_Eikonal3D_SimpleThreads.this.OffsetCorner / (Action_Eikonal3D_SimpleThreads.this.OffsetCorner + off);
                    offsetWeight = 100.0 * offsetWeight * offsetWeight;
                    offsetWeight = Math.max(offsetWeight, 0.01);
                    if (off < straightLineTransition) {
                        this.ThreadModel.fireStraightLine(sx, sy, sz - sd, rx, ry, rz);
                        if (this.Iteration < this.NumIter) {
                            this.ThreadModel.updateStatisticsFromStraightLine(pick, (float)offsetWeight);
                        }
                    } else {
                        this.ThreadModel.populateProfile(this.Profile, sx, sy, rx, ry);
                        this.Profile.fireShot((float)(sz - sd));
                        this.Profile.setReceiver((float)rz, pick);
                        if (this.Iteration < this.NumIter && this.Profile.NumPathPoints > 0) {
                            this.ThreadModel.updateStatisticsFromProfile(this.Profile, pick, (float)offsetWeight, zSpray, scalarSprayZ);
                        }
                    }
                    double error = this.Profile.ReceiverTime - (double)pick;
                    if (this.Iteration == this.NumIter) {
                        this.updateElement(this.SrcHash, shotRow, (float)error);
                        this.updateElement(this.RecHash, recRow, (float)error);
                    }
                    if (Action_Eikonal3D_SimpleThreads.this.ComputeHybridTimeShifts) {
                        double hybrid = Action_Eikonal3D_SimpleThreads.this.HybridTimeShifts + 1000.0 * off / Action_Eikonal3D_SimpleThreads.this.HybridLMOVelocity + error;
                        this.Hybrid[n] = (short)hybrid;
                    }
                    error = Math.abs(error);
                    this.SumError += error;
                    this.ErrorCount += 1.0;
                    this.AverageError = this.SumError / this.ErrorCount;
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
            System.out.println("run finished for ID = " + this.ID);
        }
    }
}

