/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Tomography;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Seismic.Segy.Segy_Exporter;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D;

public class Action_Eikonal3D_ExportSegy
extends Action_Base {
    public double TopDatum = 0.0;
    public double BottomDatum = 0.0;
    public double Size = 0.0;
    public String FileName = "";
    public boolean ExportVelocity = false;
    public boolean ExportCounts = false;
    public boolean UseProjectGrid = false;

    public Action_Eikonal3D_ExportSegy() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Export tomo model";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    protected void justReadFromNode() {
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            if (this.UseProjectGrid) {
                return this.work_projectgrid(messageServer);
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            TomoEikonal3D tomo = project.getEikonal3D();
            int numSamples = (int)(1.5 + (this.TopDatum - this.BottomDatum) / this.Size);
            Segy_Exporter exporter = new Segy_Exporter();
            exporter.setUnits(project.units_feet());
            exporter.FileName = this.FileName;
            exporter.OutputDigi = (float)this.Size;
            exporter.OutputSampleCount = numSamples;
            exporter.OutputDigiScalar = 1.0f;
            float[] vel = new float[numSamples];
            exporter.Dictionary = new Segy_Dictionary();
            exporter.Dictionary.addEntry("Trace", "CdpX", DataType.Int, DataType.Int, 200, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "CdpY", DataType.Int, DataType.Int, 204, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "Datum", DataType.Float, DataType.Float, 228, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "Elevation", DataType.Float, DataType.Float, 216, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "SampleInterval", DataType.Short, DataType.Short, 116, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "SamplesPerTrace", DataType.Short, DataType.Short, 114, Segy_Dictionary.Modification.None, 1);
            exporter.prepareFile();
            float[][][] slowness = tomo.slowness();
            float[][][] count = tomo.count();
            float[][] elev = tomo.surfaceElevation();
            double vertNodeSize = tomo.binSizeVert();
            double tomoOriginZ = tomo.originZ();
            for (int ix = 0; ix < tomo.numX(); ++ix) {
                this.PercentDone = 100.0 * (double)ix / (double)tomo.numX();
                Ensemble ensemble = new Ensemble();
                int indexX = ensemble.dictionary().addEntry("Trace", "CdpX", DataType.Int);
                int indexY = ensemble.dictionary().addEntry("Trace", "CdpY", DataType.Int);
                int indexZ = ensemble.dictionary().addEntry("Trace", "Elevation", DataType.Float);
                int indexD = ensemble.dictionary().addEntry("Trace", "Datum", DataType.Float);
                int indexInterval = ensemble.dictionary().addEntry("Trace", "SampleInterval", DataType.Short);
                int indexSamples = ensemble.dictionary().addEntry("Trace", "SamplesPerTrace", DataType.Short);
                for (int iy = 0; iy < tomo.numY(); ++iy) {
                    EnsembleTrace trace = ensemble.addTrace();
                    boolean print = ix == tomo.numX() / 2 && iy == tomo.numY() / 2;
                    tomo.setGridLocation(ix, iy, 0);
                    float surfaceElev = elev[ix][iy];
                    trace.header().putDouble(indexX, tomo.WorldX);
                    trace.header().putDouble(indexY, tomo.WorldY);
                    trace.header().putDouble(indexZ, surfaceElev);
                    trace.header().putDouble(indexD, this.TopDatum);
                    trace.header().putInt(indexInterval, (int)this.Size);
                    trace.header().putInt(indexSamples, numSamples);
                    if (this.ExportCounts) {
                        float[] hit = count[ix][iy];
                        for (int n = 0; n < numSamples; ++n) {
                            float z = (float)this.TopDatum - (float)n * (float)this.Size;
                            boolean valueSet = false;
                            if (z >= surfaceElev) {
                                vel[n] = hit[hit.length - 1];
                                valueSet = true;
                            }
                            if ((double)z <= tomo.originZ()) {
                                vel[n] = hit[0];
                                valueSet = true;
                            }
                            if (!valueSet) {
                                float indexF = (float)(((double)z - tomoOriginZ) / vertNodeSize);
                                int indexI = (int)indexF;
                                float frac = indexF - (float)indexI;
                                vel[n] = (1.0f - frac) * hit[indexI] + frac * hit[indexI + 1];
                            }
                            if (!print) continue;
                            String s = String.format("%d  %f  %f", n, Float.valueOf(z), Float.valueOf(vel[n]));
                            System.out.println(s);
                        }
                        FloatArrayWrapper data = trace.data();
                        data.setSampleInterval((float)this.Size);
                        data.insertArray(vel, numSamples);
                    }
                    if (print) {
                        float[] slowth = slowness[ix][iy];
                        for (int n = 0; n < slowth.length; ++n) {
                            double v = 1000.0f / slowth[n];
                            double z = tomoOriginZ + (double)n * vertNodeSize;
                            String s = String.format("TOMO %d  %f  %f", n, Float.valueOf((float)z), Float.valueOf((float)v));
                            System.out.println(s);
                        }
                    }
                    if (!this.ExportVelocity) continue;
                    float[] slow = slowness[ix][iy];
                    int indexSurface = (int)(0.1 + ((double)surfaceElev - tomoOriginZ) / vertNodeSize);
                    if (indexSurface >= tomo.numZ()) {
                        indexSurface = tomo.numZ() - 1;
                    }
                    indexSurface = Math.max(indexSurface, 0);
                    double surfaceVel = 1000.0f / slow[indexSurface];
                    for (int n = 0; n < numSamples; ++n) {
                        float z = (float)this.TopDatum - (float)n * (float)this.Size;
                        boolean valueSet = false;
                        if (z >= surfaceElev) {
                            vel[n] = (float)surfaceVel;
                            valueSet = true;
                        }
                        if ((double)z <= tomo.originZ()) {
                            vel[n] = 1000.0f / slow[0];
                            valueSet = true;
                        }
                        if (valueSet) continue;
                        float indexF = (float)(((double)z - tomoOriginZ) / vertNodeSize);
                        int indexI = (int)indexF;
                        float frac = indexF - (float)indexI;
                        double s = (1.0f - frac) * slow[indexI] + frac * slow[indexI + 1];
                        double v = 1000.0 / s;
                        vel[n] = (float)v;
                        if (!print) continue;
                        String str = String.format("%d  %f  %d  %f  %f  %f", n, Float.valueOf(indexF), indexI, Float.valueOf(frac), Float.valueOf(z), Float.valueOf(vel[n]));
                        System.out.println(str);
                    }
                    FloatArrayWrapper data = trace.data();
                    data.setSampleInterval((float)this.Size);
                    data.insertArray(vel, numSamples);
                }
                exporter.appendEnsemble(ensemble, false);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public boolean work_projectgrid(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Grid3D grid = project.getEmptyGrid3D();
            int iInlineIncrement = 1;
            int iCrosslineIncrement = 1;
            int iFirstInline = grid.inlineMin();
            int iFirstCrossline = grid.crosslineMin();
            int nCrosslines = grid.numCrossline();
            TomoEikonal3D tomo = project.getEikonal3D();
            int numSamples = (int)(1.5 + (this.TopDatum - this.BottomDatum) / this.Size);
            Segy_Exporter exporter = new Segy_Exporter();
            exporter.setUnits(project.units_feet());
            exporter.FileName = this.FileName;
            exporter.OutputDigi = (float)this.Size;
            exporter.OutputSampleCount = numSamples;
            exporter.OutputDigiScalar = 1.0f;
            float[] vel = new float[numSamples];
            exporter.Dictionary = new Segy_Dictionary();
            exporter.Dictionary.addEntry("Trace", "Inline", DataType.Int, DataType.Int, 208, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "Crossline", DataType.Int, DataType.Int, 212, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "CDP", DataType.Int, DataType.Int, 20, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "CdpX", DataType.Int, DataType.Int, 200, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "CdpY", DataType.Int, DataType.Int, 204, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "Datum", DataType.Float, DataType.Float, 228, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "Elevation", DataType.Float, DataType.Float, 216, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "SampleInterval", DataType.Short, DataType.Short, 116, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "SamplesPerTrace", DataType.Short, DataType.Short, 114, Segy_Dictionary.Modification.None, 1);
            exporter.prepareFile();
            float[][] elev = tomo.surfaceElevation();
            double vertNodeSize = tomo.binSizeVert();
            double tomoOriginZ = tomo.originZ();
            for (int i = grid.inlineMin(); i <= grid.inlineMax(); ++i) {
                this.PercentDone = 100.0 * (double)(i - grid.inlineMin()) / (double)grid.numInline();
                Ensemble ensemble = new Ensemble();
                int indexInline = ensemble.dictionary().addEntry("Trace", "Inline", DataType.Int);
                int indexCrossline = ensemble.dictionary().addEntry("Trace", "Crossline", DataType.Int);
                int indexCDP = ensemble.dictionary().addEntry("Trace", "CDP", DataType.Int);
                int indexX = ensemble.dictionary().addEntry("Trace", "CdpX", DataType.Int);
                int indexY = ensemble.dictionary().addEntry("Trace", "CdpY", DataType.Int);
                int indexZ = ensemble.dictionary().addEntry("Trace", "Elevation", DataType.Float);
                int indexD = ensemble.dictionary().addEntry("Trace", "Datum", DataType.Float);
                int indexInterval = ensemble.dictionary().addEntry("Trace", "SampleInterval", DataType.Short);
                int indexSamples = ensemble.dictionary().addEntry("Trace", "SamplesPerTrace", DataType.Short);
                for (int c = grid.crosslineMin(); c < grid.crosslineMax(); ++c) {
                    EnsembleTrace trace = ensemble.addTrace();
                    int cdp = (i - iFirstInline) / iInlineIncrement * nCrosslines + (c - iFirstCrossline) / iCrosslineIncrement + 1;
                    double x = grid.getWorldX(i, c);
                    double y = grid.getWorldY(i, c);
                    tomo.setWorldLocation(x, y, true, true);
                    float surfaceElev = elev[tomo.LowerIndexX][tomo.LowerIndexY];
                    trace.header().putInt(indexInline, i);
                    trace.header().putInt(indexCrossline, c);
                    trace.header().putInt(indexCDP, cdp);
                    trace.header().putDouble(indexX, x);
                    trace.header().putDouble(indexY, y);
                    trace.header().putDouble(indexZ, surfaceElev);
                    trace.header().putDouble(indexD, this.TopDatum);
                    trace.header().putInt(indexInterval, (int)this.Size);
                    trace.header().putInt(indexSamples, numSamples);
                    if (this.ExportCounts) {
                        float[] hit = tomo.InterpolatedCount;
                        for (int n = 0; n < numSamples; ++n) {
                            float z = (float)this.TopDatum - (float)n * (float)this.Size;
                            boolean valueSet = false;
                            if (z >= surfaceElev) {
                                vel[n] = 0.0f;
                                valueSet = true;
                            }
                            if ((double)z <= tomo.originZ()) {
                                vel[n] = 0.0f;
                                valueSet = true;
                            }
                            if (valueSet) continue;
                            float indexF = (float)(((double)z - tomoOriginZ) / vertNodeSize);
                            int indexI = (int)indexF;
                            float frac = indexF - (float)indexI;
                            vel[n] = (1.0f - frac) * hit[indexI] + frac * hit[indexI + 1];
                        }
                        FloatArrayWrapper data = trace.data();
                        data.setSampleInterval((float)this.Size);
                        data.insertArray(vel, numSamples);
                    }
                    if (!this.ExportVelocity) continue;
                    float[] slow = tomo.InterpolatedSlowness;
                    int indexSurface = (int)(0.1 + ((double)surfaceElev - tomoOriginZ) / vertNodeSize);
                    if (indexSurface >= tomo.numZ()) {
                        indexSurface = tomo.numZ() - 1;
                    }
                    indexSurface = Math.max(indexSurface, 0);
                    double surfaceVel = 1000.0f / slow[indexSurface];
                    for (int n = 0; n < numSamples; ++n) {
                        float z = (float)this.TopDatum - (float)n * (float)this.Size;
                        boolean valueSet = false;
                        if (z >= surfaceElev) {
                            vel[n] = (float)surfaceVel;
                            valueSet = true;
                        }
                        if ((double)z <= tomo.originZ()) {
                            vel[n] = 1000.0f / slow[0];
                            valueSet = true;
                        }
                        if (valueSet) continue;
                        float indexF = (float)(((double)z - tomoOriginZ) / vertNodeSize);
                        int indexI = (int)indexF;
                        float frac = indexF - (float)indexI;
                        double s = (1.0f - frac) * slow[indexI] + frac * slow[indexI + 1];
                        double v = 1000.0 / s;
                        vel[n] = (float)v;
                    }
                    FloatArrayWrapper data = trace.data();
                    data.setSampleInterval((float)this.Size);
                    data.insertArray(vel, numSamples);
                }
                exporter.appendEnsemble(ensemble, false);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }
}

