/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Sort;

import com.PecosCore.Data.Seismic.SparseCmpGatherManager;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class Action_CreateSparseCmpGathers
extends Action_Base {
    public double Spacing = 5000.0;
    public double Radius = 200.0;
    public double MinOffset = 0.0;
    public double MaxOffset = 20000.0;

    public Action_CreateSparseCmpGathers() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Create sparse CMP gathers";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    protected void justReadFromNode() {
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            this.MaxOffset = Math.max(this.MaxOffset, this.MinOffset + 1000.0);
            Ensemble ensemble = new Ensemble();
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            long numTraces = traceTable.rowCount();
            SparseCmpGatherManager sparseCMP = project.sparseCmpGathers();
            sparseCMP.prepare(this.Spacing, this.Radius);
            sparseCMP.MinOffset = this.MinOffset;
            sparseCMP.MaxOffset = this.MaxOffset;
            project.prepSeismicFilesForScanning();
            for (long currentIndex = 0L; !this.Halt && currentIndex < numTraces; currentIndex += 1000L) {
                this.PercentDone = 100.0 * (double)currentIndex / (double)numTraces;
                messageServer.setPercentDone(this.PercentDone);
                messageServer.setMessage_Level1(String.format("Trace %d of %d", currentIndex, numTraces));
                project.ensemble_Sequence(ensemble, currentIndex, 1000, true);
                sparseCMP.append(ensemble);
            }
            sparseCMP.finishAppending();
            project.finishedSeismicFileScanning();
            if (this.Halt) {
                return true;
            }
            traceTable.saveCurrentSection();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            RefractionStaticsProject.singleton().finishedSeismicFileScanning();
            return false;
        }
    }
}

