/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Refraction.DelayTime;

import com.PecosCore.Data.History;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.PolygonUsage;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class Action_DelayTime_SimpleVelocityAnalysis
extends Action_Base {
    public boolean ComputeSmoothRadius = true;
    public int SmoothRadius = 1;
    public boolean ApplyRangeCompression = false;
    public double RangeCompression = 2.0;
    public boolean ApplyVelocityLimits = false;
    public double VelocityMin = 30.0;
    public double VelocityMax = 30000.0;

    public Action_DelayTime_SimpleVelocityAnalysis() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Simple refractor velocity analysis";
        this.RequiresDelayTimeData = true;
        this.MemoryRequired = 512;
        this.RequiresCompleteTraceTable = false;
        this.DelayTimeDataModified = true;
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            double maxVel = 29000.0;
            double minVel = 400.0;
            if (!project.units_feet()) {
                maxVel /= 3.1;
                minVel /= 3.1;
            }
            TraceTable_Huge sharedTraceTable = this.DelayTimeData.SharedTraceTable;
            String pickVersion = this.Hasher.string_get("PickVersion", "FBP_User");
            int branch = this.Hasher.int_get("Branch", 1);
            if (branch < 1 || branch > this.DelayTimeData.MaxBranch) {
                this.FailureReason = "Branch number not valid";
                this.Failed = true;
                return false;
            }
            Grid3D grid = this.DelayTimeData.Grid;
            grid.linearFit_Prep();
            int numBadVel = 0;
            for (long row = 0L; row < sharedTraceTable.rowCount(); ++row) {
                int b = sharedTraceTable.getInt(row, this.DelayTimeData.IndexBranchUser);
                float pick = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexUserPick);
                float off = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexOffset);
                int killed = sharedTraceTable.getInt(row, this.DelayTimeData.IndexKilled);
                if (killed != 0 || branch != b || !(pick >= 0.1f) || !(pick < 6000.0f) || !(off >= 10.0f)) continue;
                double vel = 1000.0 * (double)off / (double)pick;
                if (vel >= minVel && vel <= maxVel) {
                    int midX = sharedTraceTable.getInt(row, this.DelayTimeData.IndexMidX);
                    int midY = sharedTraceTable.getInt(row, this.DelayTimeData.IndexMidY);
                    grid.linearFit_Add(midX, midY, off, pick, 1.0f);
                    continue;
                }
                ++numBadVel;
            }
            System.out.println("numBadVel = " + numBadVel);
            if (this.ComputeSmoothRadius) {
                grid.linearFit_Compute(7.0, true);
                grid.smooth(5);
            } else {
                grid.linearFit_Compute(2.0, true);
                grid.smooth(this.SmoothRadius);
            }
            float[][] data = grid.data();
            float[][] alpha = grid.Alpha;
            int nx = grid.numInline();
            int ny = grid.numCrossline();
            for (int x = 0; x < nx; ++x) {
                for (int y = 0; y < ny; ++y) {
                    data[x][y] = 1000.0f / alpha[x][y];
                }
            }
            if (this.ApplyRangeCompression) {
                grid.rangeCompression(this.RangeCompression);
            }
            if (this.ApplyVelocityLimits) {
                grid.clip((float)this.VelocityMin, (float)this.VelocityMax, PolygonUsage.NotUsed, null);
            }
            this.DelayTimeData.Shot.getVelocityFromGrid(grid, branch);
            this.DelayTimeData.Receiver.getVelocityFromGrid(grid, branch);
            this.DelayTimeData.Shot.ensureVelocityIncrease();
            this.DelayTimeData.Receiver.ensureVelocityIncrease();
            this.DelayTimeData.Shot.update_table_velocity();
            this.DelayTimeData.Receiver.update_table_velocity();
            project.getDelayTimeData().grid_create_all_velocity_grids_from_tables();
            this.DelayTimeData.Shot.Modified_Velocity = true;
            this.DelayTimeData.Receiver.Modified_Velocity = true;
            History hist = project.getDelayTimeData().getHistory();
            hist.addWithTime("Simple, grid-based refractor velocity computation for branch " + Integer.toString(branch));
            hist.save();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }
}

