/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Refraction.DelayTime;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.DelayTime.UpholeCorrection;
import com.PecosLibrary.Refraction.PickHistogram;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.util.ArrayList;

public class Action_DelayTime_PickHistogram
extends Action_Base {
    public String KillVersionName = "";
    public boolean KillAnisotropy = false;
    public int KillBranch = -9999;
    public float KillError = 10000.0f;
    public boolean RequireShotInsidePolygon = false;
    public boolean RequireReceiverInsidePolygon = false;
    public boolean RequireCdpInsidePolygon = false;
    public boolean KillInsidePolygon = true;
    public Java2D_Polygon Polygon;
    protected Table_Abstract m_shotTable = RefractionStaticsProject.singleton().getShotTable();
    protected Table_Abstract m_receiverTable = RefractionStaticsProject.singleton().getRecTable();
    protected HashMap_Integer m_shotHash;
    protected HashMap_Integer m_receiverHash;

    public Action_DelayTime_PickHistogram() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Pick error histogram computation";
        this.RequiresDelayTimeData = true;
        this.MemoryRequired = 512;
        this.RequiresCompleteTraceTable = false;
        try {
            this.m_shotHash = this.m_shotTable.createMapID();
            this.m_receiverHash = this.m_receiverTable.createMapID();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            ITraceTable projectTraceTable = project.traceTableWrapper().traceTable();
            TraceTable_Huge sharedTraceTable = this.DelayTimeData.SharedTraceTable;
            UpholeCorrection.Method method = project.getUpholeCorrectionMethod();
            this.DelayTimeData.Shot.computeUpholeCorrections(method);
            this.DelayTimeData.Shot.computeWaterBottomCorrections(project.getWaterDepthCorrectionMethod());
            this.DelayTimeData.Receiver.computeWaterBottomCorrections(project.getWaterDepthCorrectionMethod());
            PickHistogram pickHistogram = project.pickHistogram();
            pickHistogram.List.clear();
            ArrayList<String> pickVersions = projectTraceTable.columns("FBP_");
            for (String pickName : pickVersions) {
                int index = projectTraceTable.column_indexOfColumn(pickName);
                for (int b = 1; b <= this.DelayTimeData.MaxBranch; ++b) {
                    PickHistogram.Entry e = pickHistogram.addEntry(pickName, index, b, true);
                    e.KillBadPicks = e.PickName.equalsIgnoreCase(this.KillVersionName) && e.UseAnisotropy == this.KillAnisotropy && e.Branch == this.KillBranch;
                    e = pickHistogram.addEntry(pickName, index, b, false);
                    e.KillBadPicks = e.PickName.equalsIgnoreCase(this.KillVersionName) && e.UseAnisotropy == this.KillAnisotropy && e.Branch == this.KillBranch;
                }
            }
            this.KillError = Math.max(this.KillError, 10.0f);
            boolean checkPolygon = this.RequireShotInsidePolygon || this.RequireReceiverInsidePolygon || this.RequireCdpInsidePolygon;
            int indexShotX = this.m_shotTable.column_indexOfColumn("Easting");
            int indexShotY = this.m_shotTable.column_indexOfColumn("Northing");
            int indexReceiverX = this.m_receiverTable.column_indexOfColumn("Easting");
            int indexReceiverY = this.m_receiverTable.column_indexOfColumn("Northing");
            for (long row = 0L; row < sharedTraceTable.rowCount(); ++row) {
                int branch = sharedTraceTable.getInt(row, this.DelayTimeData.IndexBranchUser);
                int killed = sharedTraceTable.getInt(row, this.DelayTimeData.IndexKilled);
                float offset = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexOffset);
                float azimuth = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexAzimuth);
                int shotRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexShotRow);
                int recRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexRecRow);
                for (PickHistogram.Entry pickEntry : pickHistogram.List) {
                    boolean killPick;
                    if (branch != pickEntry.Branch || killed != 0) continue;
                    float pick = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexUserPick);
                    float shotVel = this.DelayTimeData.Shot.getVelocity(branch, shotRow);
                    float recVel = this.DelayTimeData.Receiver.getVelocity(branch, recRow);
                    float averageVel = 0.5f * (shotVel + recVel);
                    float travelTime = 1000.0f * offset / averageVel;
                    float shotDT = this.DelayTimeData.Shot.getDelayTime(branch, shotRow);
                    if (pickEntry.UseAnisotropy) {
                        shotDT = this.DelayTimeData.Shot.getDelayTime(branch, shotRow, azimuth, true, false);
                    }
                    shotDT = Math.max(shotDT, 0.0f);
                    float recDT = this.DelayTimeData.Receiver.getDelayTime(branch, recRow);
                    if (pickEntry.UseAnisotropy) {
                        recDT = this.DelayTimeData.Receiver.getDelayTime(branch, recRow, azimuth, true, false);
                    }
                    recDT = Math.max(recDT, 0.0f);
                    float upholeCorrection = this.DelayTimeData.Shot.UpholeCorrectionTime[shotRow][branch];
                    float shotWbCorrection = this.DelayTimeData.Shot.WaterBottomCorrectionTime[shotRow][branch];
                    float recWbCorrection = this.DelayTimeData.Receiver.WaterBottomCorrectionTime[recRow][branch];
                    pick = pick + upholeCorrection + shotWbCorrection + recWbCorrection;
                    float error = Math.abs(pick - recDT - shotDT - travelTime);
                    boolean badError = pickEntry.KillBadPicks && error > this.KillError;
                    boolean polygonKill = false;
                    if (checkPolygon) {
                        if (this.KillInsidePolygon) {
                            double cdpX;
                            double receiverX;
                            double shotX;
                            if (this.RequireShotInsidePolygon && this.Polygon.contains(shotX = this.m_shotTable.getDouble(shotRow, indexShotX), shotY = this.m_shotTable.getDouble(shotRow, indexShotY))) {
                                polygonKill = true;
                            }
                            if (this.RequireReceiverInsidePolygon && this.Polygon.contains(receiverX = this.m_receiverTable.getDouble(recRow, indexReceiverX), receiverY = this.m_receiverTable.getDouble(recRow, indexReceiverY))) {
                                polygonKill = true;
                            }
                            if (this.RequireCdpInsidePolygon && this.Polygon.contains(cdpX = (double)sharedTraceTable.getFloat(row, this.DelayTimeData.IndexMidX), cdpY = (double)sharedTraceTable.getFloat(row, this.DelayTimeData.IndexMidY))) {
                                polygonKill = true;
                            }
                        } else {
                            double cdpX;
                            double receiverX;
                            double shotX;
                            if (this.RequireShotInsidePolygon && !this.Polygon.contains(shotX = this.m_shotTable.getDouble(shotRow, indexShotX), shotY = this.m_shotTable.getDouble(shotRow, indexShotY))) {
                                polygonKill = true;
                            }
                            if (this.RequireReceiverInsidePolygon && !this.Polygon.contains(receiverX = this.m_receiverTable.getDouble(recRow, indexReceiverX), receiverY = this.m_receiverTable.getDouble(recRow, indexReceiverY))) {
                                polygonKill = true;
                            }
                            if (this.RequireCdpInsidePolygon && !this.Polygon.contains(cdpX = (double)sharedTraceTable.getFloat(row, this.DelayTimeData.IndexMidX), cdpY = (double)sharedTraceTable.getFloat(row, this.DelayTimeData.IndexMidY))) {
                                polygonKill = true;
                            }
                        }
                    }
                    boolean bl = killPick = pick < 0.01f || badError || polygonKill;
                    if (killPick) {
                        int projectTraceTableRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexTraceTableIndex);
                        projectTraceTable.putFloat(projectTraceTableRow, pickEntry.TraceTableIndex, -9999.0f);
                        continue;
                    }
                    int histIndex = (int)error;
                    histIndex = Math.min(histIndex, pickEntry.Count.length - 1);
                    pickEntry.Count[histIndex] = pickEntry.Count[histIndex] + 1;
                }
                if (row % 50000L != 0L) continue;
                String s = String.format("Trace %d of %d", row, projectTraceTable.rowCount());
                messageServer.setMessage_Level2(s);
                messageServer.setPercentDone(100.0 * (double)row / (double)projectTraceTable.rowCount());
            }
            projectTraceTable.saveCurrentSection();
            project.savePickHistogram();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }
}

