/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Refraction.DelayTime;

import com.PecosCore.Data.History;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.DelayTime.UpholeCorrection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class Action_DelayTime_DelayTimeAnisotropy_Grid
extends Action_Base {
    protected int m_numTestAngles = 9;
    protected float m_deltaAz = (float)(Math.PI / (double)this.m_numTestAngles);
    protected int m_branch;
    protected double m_gridSize = 1000.0;
    protected double m_maxAmp = 12.0;
    protected HashMap_Integers<Element> m_hash = new HashMap_Integers();
    protected long m_totalTraces = 0L;
    protected long m_tracesScanned = 0L;

    protected Element getElement(int ix, int iy) throws Exception {
        try {
            if (!this.m_hash.containsKey(ix, iy)) {
                this.m_hash.put(new Element(), ix, iy);
            }
            return this.m_hash.get(ix, iy);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected Element getElementWorld(double x, double y) throws Exception {
        try {
            int ix = (int)(0.5 + x / this.m_gridSize);
            int iy = (int)(0.5 + y / this.m_gridSize);
            return this.getElement(ix, iy);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Action_DelayTime_DelayTimeAnisotropy_Grid() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Grid-based delay time anisotropy analysis";
        this.RequiresDelayTimeData = true;
        this.MemoryRequired = 512;
        this.RequiresCompleteTraceTable = false;
        this.DelayTimeDataModified = true;
    }

    protected void updateAzimuths(IProgressMonitor messageServer) throws Exception {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            TraceTable_Huge sharedTraceTable = this.DelayTimeData.SharedTraceTable;
            UpholeCorrection.Method method = project.getUpholeCorrectionMethod();
            this.DelayTimeData.Shot.computeUpholeCorrections(method);
            this.DelayTimeData.Shot.computeWaterBottomCorrections(project.getWaterDepthCorrectionMethod());
            this.DelayTimeData.Receiver.computeWaterBottomCorrections(project.getWaterDepthCorrectionMethod());
            for (Element elem : this.m_hash.getValues()) {
                elem.clearSums();
            }
            Table_Abstract shotTable = project.shotTable();
            Table_Abstract recTable = project.receiverTable();
            int colShotX = shotTable.column_indexOfColumn("Easting");
            int colShotY = shotTable.column_indexOfColumn("Northing");
            int colRecX = recTable.column_indexOfColumn("Easting");
            int colRecY = recTable.column_indexOfColumn("Northing");
            for (long row = 0L; row < sharedTraceTable.rowCount(); ++row) {
                ++this.m_tracesScanned;
                float offset = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexOffset);
                float azimuth = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexAzimuth);
                float pick = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexUserPick);
                int branch = sharedTraceTable.getInt(row, this.DelayTimeData.IndexBranchUser);
                int killed = sharedTraceTable.getInt(row, this.DelayTimeData.IndexKilled);
                if (killed == 0 && branch == this.m_branch && pick >= 0.1f && pick < 4000.0f) {
                    int shotRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexShotRow);
                    int recRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexRecRow);
                    double shotX = shotTable.getDouble(shotRow, colShotX);
                    double shotY = shotTable.getDouble(shotRow, colShotY);
                    double recX = recTable.getDouble(recRow, colRecX);
                    double recY = recTable.getDouble(recRow, colRecY);
                    Element shotElem = this.getElementWorld(shotX, shotY);
                    Element recElem = this.getElementWorld(recX, recY);
                    float shotVel = this.DelayTimeData.Shot.getVelocity(branch, shotRow);
                    float recVel = this.DelayTimeData.Receiver.getVelocity(branch, recRow);
                    float averageVel = 0.5f * (shotVel + recVel);
                    float travelTime = 1000.0f * offset / averageVel;
                    float shotDT = this.DelayTimeData.Shot.getDelayTime(branch, shotRow);
                    float recDT = this.DelayTimeData.Receiver.getDelayTime(branch, recRow);
                    float shotDTAnis = shotDT + shotElem.getCurrent(azimuth);
                    float recDTAnis = recDT + recElem.getCurrent(azimuth);
                    float upholeCorrection = this.DelayTimeData.Shot.UpholeCorrectionTime[shotRow][branch];
                    float shotWbCorrection = this.DelayTimeData.Shot.WaterBottomCorrectionTime[shotRow][branch];
                    float recWbCorrection = this.DelayTimeData.Receiver.WaterBottomCorrectionTime[recRow][branch];
                    pick = pick + upholeCorrection + shotWbCorrection + recWbCorrection;
                    float predShotDT = Math.max(0.0f, pick - travelTime - recDTAnis);
                    int a = 0;
                    while (a < this.m_numTestAngles) {
                        double cos = Math.cos(2.0f * (azimuth - shotElem.TestAngle[a]));
                        double dt = (double)shotDT + cos * (double)shotElem.TestAmplitude;
                        double error = Math.abs((double)predShotDT - dt);
                        int n = a++;
                        shotElem.ErrorSum[n] = shotElem.ErrorSum[n] + (float)error;
                    }
                    float predRecDT = Math.max(0.0f, pick - travelTime - shotDTAnis);
                    int a2 = 0;
                    while (a2 < this.m_numTestAngles) {
                        double cos = Math.cos(2.0f * (azimuth - recElem.TestAngle[a2]));
                        double dt = (double)recDT + cos * (double)recElem.TestAmplitude;
                        double error = Math.abs((double)predRecDT - dt);
                        int n = a2++;
                        recElem.ErrorSum[n] = recElem.ErrorSum[n] + (float)error;
                    }
                }
                if (this.m_tracesScanned % 50000L != 0L) continue;
                messageServer.setPercentDone(100.0 * (double)this.m_tracesScanned / (double)this.m_totalTraces);
            }
            int half = this.m_numTestAngles / 2;
            this.m_deltaAz = 1.2f * this.m_deltaAz / (float)half;
            for (Element elem : this.m_hash.getValues()) {
                this.updateAzimuthInfo(elem);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void updateAmp(IProgressMonitor messageServer) throws Exception {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            TraceTable_Huge sharedTraceTable = this.DelayTimeData.SharedTraceTable;
            UpholeCorrection.Method method = project.getUpholeCorrectionMethod();
            this.DelayTimeData.Shot.computeUpholeCorrections(method);
            for (Element elem : this.m_hash.getValues()) {
                elem.clearSums();
            }
            Table_Abstract shotTable = project.shotTable();
            Table_Abstract recTable = project.receiverTable();
            int colShotX = shotTable.column_indexOfColumn("Easting");
            int colShotY = shotTable.column_indexOfColumn("Northing");
            int colRecX = recTable.column_indexOfColumn("Easting");
            int colRecY = recTable.column_indexOfColumn("Northing");
            int indexShotKilled = shotTable.column_indexOfColumn("Killed");
            int indexRecKilled = recTable.column_indexOfColumn("Killed");
            for (long row = 0L; row < sharedTraceTable.rowCount(); ++row) {
                ++this.m_tracesScanned;
                float offset = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexOffset);
                float azimuth = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexAzimuth);
                float pick = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexUserPick);
                int branch = sharedTraceTable.getInt(row, this.DelayTimeData.IndexBranchUser);
                int killed = sharedTraceTable.getInt(row, this.DelayTimeData.IndexKilled);
                int shotRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexShotRow);
                int recRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexRecRow);
                if (shotTable.getBool(shotRow, indexShotKilled)) {
                    killed = 1;
                }
                if (recTable.getBool(recRow, indexRecKilled)) {
                    killed = 1;
                }
                if (killed == 0 && branch == this.m_branch && pick >= 0.1f) {
                    double shotX = shotTable.getDouble(shotRow, colShotX);
                    double shotY = shotTable.getDouble(shotRow, colShotY);
                    double recX = recTable.getDouble(recRow, colRecX);
                    double recY = recTable.getDouble(recRow, colRecY);
                    Element shotElem = this.getElementWorld(shotX, shotY);
                    Element recElem = this.getElementWorld(recX, recY);
                    float shotVel = this.DelayTimeData.Shot.getVelocity(branch, shotRow);
                    float recVel = this.DelayTimeData.Receiver.getVelocity(branch, recRow);
                    float averageVel = 0.5f * (shotVel + recVel);
                    float travelTime = 1000.0f * offset / averageVel;
                    float shotDT = this.DelayTimeData.Shot.getDelayTime(branch, shotRow);
                    float recDT = this.DelayTimeData.Receiver.getDelayTime(branch, recRow);
                    float shotDTAnis = shotDT + shotElem.getCurrent(azimuth);
                    float recDTAnis = recDT + recElem.getCurrent(azimuth);
                    float upholeCorrection = this.DelayTimeData.Shot.UpholeCorrectionTime[shotRow][branch];
                    float predShotDT = Math.max(0.0f, (pick += upholeCorrection) - travelTime - recDTAnis);
                    float shotCos = (float)Math.cos(2.0f * (azimuth - shotElem.Azimuth));
                    shotElem.AmpSum1 += shotCos * shotCos;
                    shotElem.AmpSum2 += shotCos * (predShotDT - shotDT);
                    float predRecDT = Math.max(0.0f, pick - travelTime - shotDTAnis);
                    float recCos = (float)Math.cos(2.0f * (azimuth - recElem.Azimuth));
                    recElem.AmpSum1 += recCos * recCos;
                    recElem.AmpSum2 += recCos * (predRecDT - recDT);
                }
                if (this.m_tracesScanned % 50000L != 0L) continue;
                messageServer.setPercentDone(100.0 * (double)this.m_tracesScanned / (double)this.m_totalTraces);
            }
            for (Element elem : this.m_hash.getValues()) {
                float newAmp = elem.AmpSum2 / elem.AmpSum1;
                float change = newAmp - elem.Amplitude;
                elem.Amplitude += 0.5f * change;
                elem.TestAmplitude = elem.Amplitude = Math.max(0.0f, elem.Amplitude);
                elem.Amplitude = (float)Math.min(this.m_maxAmp, (double)elem.Amplitude);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void updateAzimuthInfo(Element elem) {
        try {
            int minIndex = 0;
            float minError = elem.ErrorSum[0];
            for (int n = 0; n < this.m_numTestAngles; ++n) {
                if (!(elem.ErrorSum[n] < minError)) continue;
                minError = elem.ErrorSum[n];
                minIndex = n;
            }
            elem.Azimuth = elem.TestAngle[minIndex];
            int middleIndex = this.m_numTestAngles / 2;
            for (int n = 0; n < this.m_numTestAngles; ++n) {
                elem.TestAngle[n] = elem.Azimuth + this.m_deltaAz * (float)(n - middleIndex);
                elem.ErrorSum[n] = 0.0f;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.m_gridSize = project.units_feet() ? 1000.0 : 400.0;
            this.m_gridSize = this.Hasher.double_get("GridSize", 600.0);
            TraceTable_Huge sharedTraceTable = this.DelayTimeData.SharedTraceTable;
            this.m_maxAmp = this.Hasher.double_get("MaxAnis", 12.0);
            this.m_branch = this.Hasher.int_get("Branch", 1);
            this.Description = "Anisotropy analysis, branch " + Integer.toString(this.m_branch);
            this.DelayTimeData.Receiver.clearDelayTimeAnisotropy();
            this.DelayTimeData.Shot.clearDelayTimeAnisotropy();
            String pickVersion = this.Hasher.string_get("PickVersion", "FBP_User");
            if (!sharedTraceTable.column_exists("FBP_User")) {
                this.FailureReason = "First-break picks not present (pickVersion column)";
                this.Failed = true;
                return false;
            }
            int niter = 3;
            this.m_totalTraces = 2L * (long)niter * sharedTraceTable.rowCount();
            for (int iter = 0; iter < niter; ++iter) {
                this.updateAzimuths(messageServer);
                this.updateAmp(messageServer);
            }
            this.updateTable(project.receiverTable());
            this.updateTable(project.shotTable());
            History hist = project.getDelayTimeData().getHistory();
            hist.addWithTime("Delay time anisotropy term computed");
            hist.save();
            System.gc();
            System.gc();
            System.gc();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected void updateTable(Table_Abstract table) {
        try {
            String colNameAz = Pecos.getColNameDtAnisAz(this.m_branch);
            String colNameMag = Pecos.getColNameDtAnisMag(this.m_branch);
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexAz = table.column_indexOfColumn(colNameAz);
            int indexMag = table.column_indexOfColumn(colNameMag);
            for (int n = 0; n < table.row_count(); ++n) {
                double x = table.getDouble(n, indexX);
                double y = table.getDouble(n, indexY);
                Element elem = this.getElementWorld(x, y);
                while (elem.Azimuth < 0.0f) {
                    elem.Azimuth = (float)((double)elem.Azimuth + Math.PI);
                }
                while ((double)elem.Azimuth > Math.PI) {
                    elem.Azimuth = (float)((double)elem.Azimuth - Math.PI);
                }
                table.putDouble(n, indexAz, elem.Azimuth);
                table.putDouble(n, indexMag, elem.Amplitude);
            }
            RefractionStaticsProject.singleton().geometryDatabase().writeColumnContentsToDatabase(table, colNameAz);
            RefractionStaticsProject.singleton().geometryDatabase().writeColumnContentsToDatabase(table, colNameMag);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class Element {
        public float Azimuth = 1.5707964f;
        public float Amplitude = 0.0f;
        public float AmpSum1 = 0.0f;
        public float AmpSum2 = 0.0f;
        public float TestAmplitude = 10.0f;
        public float[] TestAngle;
        public float[] ErrorSum;
        public float[] WeightSum;

        public Element() {
            this.ErrorSum = new float[Action_DelayTime_DelayTimeAnisotropy_Grid.this.m_numTestAngles];
            this.WeightSum = new float[Action_DelayTime_DelayTimeAnisotropy_Grid.this.m_numTestAngles];
            this.TestAngle = new float[Action_DelayTime_DelayTimeAnisotropy_Grid.this.m_numTestAngles];
            for (int n = 0; n < Action_DelayTime_DelayTimeAnisotropy_Grid.this.m_numTestAngles; ++n) {
                this.TestAngle[n] = (float)((double)n * Math.PI / (double)Action_DelayTime_DelayTimeAnisotropy_Grid.this.m_numTestAngles);
            }
            this.clearSums();
        }

        public float getCurrent(float az) {
            return this.Amplitude * (float)Math.cos(2.0f * (this.Azimuth - az));
        }

        public void clearSums() {
            this.AmpSum1 = 1.0E-20f;
            this.AmpSum2 = 0.0f;
            for (int n = 0; n < this.ErrorSum.length; ++n) {
                this.ErrorSum[n] = 0.0f;
                this.WeightSum[n] = 1.0E-40f;
            }
        }
    }
}

