/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.QC;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Seismic.SeismicProfile;
import com.PecosLibrary.Stack.Semblance;
import com.PecosLibrary.Stack.StackGizmo;

public class Action_ComputeProfileSemblance
extends Action_Base {
    public StackGizmo m_stackGizmo = new StackGizmo();
    public Semblance m_semblance = new Semblance(this.m_stackGizmo);
    public SeismicProfile m_profile;
    public EnsembleWorker_Sequence m_sequence;
    public boolean SaveInProfileVolume = true;
    public boolean ExtractHVA = false;
    protected float[][] m_hva;
    public double[] HvaTimes;

    public float[][] hva() {
        return this.m_hva;
    }

    public Action_ComputeProfileSemblance() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Compute semblance along profile";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    protected void justReadFromNode() {
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Ensemble ensemble = new Ensemble();
            this.m_semblance.prepSemblanceProfileVolume(this.m_profile.binCount(), this.m_profile.semblanceProfileVolume());
            if (this.ExtractHVA) {
                this.m_hva = new float[this.m_profile.binCount()][this.m_semblance.numVels()];
            }
            for (int n = 0; n < this.m_profile.binCount(); ++n) {
                ensemble.clearTraces(false);
                this.m_profile.populateSeismicProfileEnsemble(n, ensemble);
                project.prepGeometryHeaders(ensemble, true, true);
                project.inputDataProcessor_Run(ensemble);
                Ensemble processed = this.m_sequence.work(ensemble.clone());
                this.m_stackGizmo.insertEnsemble(processed, true);
                this.m_semblance.computeSemblance(80, 8);
                if (this.SaveInProfileVolume) {
                    this.m_semblance.setSemblanceProfileVolume(n, this.m_profile.semblanceProfileVolume());
                }
                if (this.ExtractHVA) {
                    this.m_semblance.extractFixedTime(this.HvaTimes[n], this.m_hva[n]);
                }
                double percent = 100.0 * (double)n / (double)this.m_profile.binCount();
                messageServer.setPercentDone(percent);
            }
            if (this.SaveInProfileVolume) {
                this.m_profile.semblanceProfileVolume().save();
            }
            if (this.SaveInProfileVolume) {
                Messenger.broadcast(Messenger.Message.ProfileSemblanceRecomputed, null, null);
            }
            if (this.ExtractHVA) {
                this.m_profile.TempHVA = this.m_hva;
                this.m_profile.HvaMaxVel = this.m_semblance.maxVel();
                this.m_profile.HvaMinVel = this.m_semblance.minVel();
                Messenger.broadcast(Messenger.Message.HvaComputed, this, null);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }
}

