/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Import;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class Action_ImportTraceTableFromCSV
extends Action_Base {
    public Action_ImportTraceTableFromCSV() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Import trace table from CSV file";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    protected void justReadFromNode() {
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            String name = this.Hasher.string_get("Name", "Trace");
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String path = Tools_FileSystem.confirmSubDirectoryExists(project.projectPath(), "TraceTable_CSV");
            String csv = path + "/" + name + ".csv";
            if (!Tools_FileSystem.exists_file(csv)) {
                this.FailureReason = "CSV file does not exist";
                return false;
            }
            messageServer.setMessage_Level1("Import CSV file");
            BufferedReader br = new BufferedReader(new FileReader(csv));
            String line = br.readLine();
            if (line == null) {
                br.close();
                JOptionPane.showMessageDialog(null, "Failed to read first line in file", "Import failed", 0);
                return false;
            }
            Object traceTablePath = project.projectPath() + "/TraceTable";
            project.traceTableWrapper_Clear();
            Tools_FileSystem.deletePathIfExists((String)traceTablePath);
            traceTablePath = Tools_FileSystem.confirmSubDirectoryExists(project.projectPath(), "TraceTable");
            Table_Memory table = new Table_Memory();
            ((Table_Abstract)table).setName("Trace");
            ArrayList<String> originalColumnNames = Tools_Strings.tokenizer_comma(line, true);
            DataType[] colType = new DataType[originalColumnNames.size()];
            int colIndex = 0;
            for (String colNameTemp : originalColumnNames) {
                DataType type = DataType.Float;
                String colName = colNameTemp;
                if (colNameTemp.endsWith("_D")) {
                    type = DataType.Double;
                    colName = colNameTemp.substring(0, colNameTemp.length() - 2);
                }
                if (colNameTemp.endsWith("_F")) {
                    type = DataType.Float;
                    colName = colNameTemp.substring(0, colNameTemp.length() - 2);
                }
                if (colNameTemp.endsWith("_I")) {
                    type = DataType.Int;
                    colName = colNameTemp.substring(0, colNameTemp.length() - 2);
                }
                if (colNameTemp.endsWith("_L")) {
                    type = DataType.Long;
                    colName = colNameTemp.substring(0, colNameTemp.length() - 2);
                }
                ((Table_Abstract)table).column_append(colName, type);
                colType[colIndex++] = type;
            }
            TraceTable_Huge traceTable = new TraceTable_Huge((String)traceTablePath, "Trace", table, 8);
            line = br.readLine();
            int numRead = 0;
            while (line != null) {
                ArrayList<String> tokens = Tools_Strings.tokenizer_improved(line, ',');
                int row = ((Table_Abstract)table).row_increment();
                for (int n = 0; n < tokens.size(); ++n) {
                    String s = tokens.get(n);
                    if (s != null) {
                        if (!s.isEmpty()) {
                            ((Table_Abstract)table).putString(row, n, s);
                            continue;
                        }
                        ((Table_Abstract)table).putString(row, n, "-9999");
                        continue;
                    }
                    ((Table_Abstract)table).putString(row, n, "-9999");
                }
                line = br.readLine();
                if (((Table_Abstract)table).row_count() >= 1000) {
                    traceTable.appendTable(table);
                    ((Table_Abstract)table).row_clear(false);
                }
                if (++numRead % 10000 != 0) continue;
                messageServer.setMessage_Level1("Trace count: " + Integer.toString(numRead));
            }
            if (((Table_Abstract)table).row_count() >= 1) {
                traceTable.appendTable(table);
                ((Table_Abstract)table).row_clear(false);
            }
            traceTable.finishedAppending(null);
            br.close();
            project.traceTableWrapper_Refresh();
            Messenger.broadcast(Messenger.Message.TraceTableReloaded, null, null);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }
}

