/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Import;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;

public class Action_ImportSeisupMatrix
extends Action_Base {
    public String TraceColumnName = "FBP_SeisUP";
    public String FileName = "";
    public double Shift = 0.0;
    protected Ensemble m_ensemble;
    protected int m_indexChan;
    protected int m_indexTrace;
    protected Table_Abstract m_shotTable;
    protected int m_shotIndexSSPN;
    protected int m_shotIndexLine;
    protected int m_shotIndexID;
    protected ITraceTable m_traceTable;
    protected int m_indexPick;

    public Action_ImportSeisupMatrix() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Import SeisUP matrix file";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    protected void prepShot(int line, int sspn) throws Exception {
        try {
            this.m_ensemble = null;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            for (int row = 0; row < this.m_shotTable.row_count(); ++row) {
                int temp1 = this.m_shotTable.getInt(row, this.m_shotIndexSSPN);
                int temp2 = this.m_shotTable.getInt(row, this.m_shotIndexLine);
                if (temp1 != sspn || temp2 != line) continue;
                int id = this.m_shotTable.getInt(row, this.m_shotIndexID);
                this.m_ensemble = new Ensemble();
                project.ensemble_Shot(this.m_ensemble, id, false);
                this.m_indexChan = this.m_ensemble.dictionary().getEntryIndex("Trace", "Channel");
                this.m_indexTrace = this.m_ensemble.dictionary().getEntryIndex("Trace", "TraceIndex");
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void setPick(int chan, float pick) throws Exception {
        try {
            if (this.m_ensemble == null) {
                return;
            }
            pick += (float)this.Shift;
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                int c = this.m_ensemble.trace(n).header().getInt(this.m_indexChan);
                if (c != chan) continue;
                long traceIndex = this.m_ensemble.trace(n).header().getInt(this.m_indexTrace);
                this.m_traceTable.putFloat(traceIndex, this.m_indexPick, pick);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            if (!Tools_FileSystem.exists_file(this.FileName)) {
                return false;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.m_shotTable = project.shotTable();
            this.m_shotIndexSSPN = this.m_shotTable.column_indexOfColumn("SSPN");
            this.m_shotIndexLine = this.m_shotTable.column_indexOfColumn("LineNumber");
            this.m_shotIndexID = this.m_shotTable.column_indexOfColumn("ShotID");
            this.m_traceTable = project.traceTableWrapper().traceTable();
            this.m_indexPick = this.m_traceTable.column_append(this.TraceColumnName, DataType.Float);
            messageServer.setMessage_Level1("Initialize pick column");
            for (long r = 0L; r < this.m_traceTable.rowCount(); ++r) {
                this.m_traceTable.putFloat(r, this.m_indexPick, -9999.0f);
                if (r % 10000L != 0L) continue;
                messageServer.setPercentDone(100.0 * (double)r / (double)this.m_traceTable.rowCount());
            }
            messageServer.setPercentDone(0.0);
            messageServer.setMessage_Level1("Scan file");
            BufferedReader br = new BufferedReader(new FileReader(this.FileName));
            String line = br.readLine();
            int currentChannel = 1;
            int currentSSPN = -9999;
            int currentLineNumber = -9999;
            while (line != null && !this.Halt) {
                ArrayList<String> tokens;
                if (!line.startsWith("*") && (tokens = Tools_Strings.tokenizer(line)).size() >= 1) {
                    if (tokens.get(0).equalsIgnoreCase("V")) {
                        if (tokens.size() == 2) {
                            float pick = Float.parseFloat(tokens.get(1));
                            this.setPick(currentChannel, pick);
                        }
                        ++currentChannel;
                    }
                    if (tokens.size() == 3 && tokens.get(0).equalsIgnoreCase("D")) {
                        currentChannel = 1;
                        int lineNum = Integer.parseInt(tokens.get(1));
                        int sspn = Integer.parseInt(tokens.get(2));
                        this.prepShot(lineNum, sspn);
                    }
                }
                line = br.readLine();
            }
            br.close();
            this.m_traceTable.saveCurrentSection();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    @Override
    protected void justReadFromNode() {
    }
}

