/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Import;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge_Wrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Geometry.TableParser;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Plugins.IPlugin;
import com.PecosCore.Project.ProjectCreator;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_RMS;
import com.PecosLibrary.Ensemble.Worker.Filter.EnsembleWorker_ButterworthLowPass;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;

public class Action_ImportPreStackPlugin
extends Action_Base {
    protected IPlugin m_plugin;
    protected ProjectCreator m_projectCreator;
    protected Ensemble m_ensemble;
    protected String m_projectName = "";
    protected String m_projectPath = "";
    protected String m_parentPath = "";
    protected String m_traceTablePath = "";
    protected ArrayList<String> m_fileList = null;
    protected ArrayList<String> m_fileListChecked = new ArrayList();
    protected String m_dimension = "";
    protected String m_units = "";
    protected TraceTable_Huge m_diskTable;
    protected int m_traceCount = 0;
    protected int m_tracesRead = 0;
    protected int m_channelMax = Integer.MIN_VALUE;
    protected int m_channelMin = Integer.MAX_VALUE;
    protected Table_Abstract m_shotTable = new Table_Memory();
    protected Table_Abstract m_receiverTable = new Table_Memory();
    protected TableParser m_shotParser;
    protected TableParser m_receiverParser;
    protected Table_Abstract m_fileTable = new Table_Memory();
    protected int m_fileIndex_FileID;
    protected int m_fileIndex_Name;
    protected int m_fileIndex_Path;
    protected int m_currentFileID = 999;
    protected Table_Abstract m_datasetTable = new Table_Memory();
    protected int m_datasetIndex_Name;
    protected Grid3D_Conversion m_grid3D = new Grid3D_Conversion();
    public boolean DecimateInput = false;
    public int Decimation = 2;
    public boolean CreateCompressed = false;
    public boolean Resample = false;
    public float MaxTime = 2000.0f;
    public float OutputSampleInterval = 4.0f;
    public boolean RequireFilter = false;
    public boolean KillOffsets = false;
    public double MinOffset = 0.0;
    public double MaxOffset = 100000.0;
    public boolean IsMarine = false;
    public float RecBinSize = 25.0f;
    public int MarineDecimation = 0;
    public int MarineShotLineIncrement = 0;
    public int MarineShotLineNumber = 0;
    public boolean CreateSparse = false;
    public float SparseSpacing = 5000.0f;
    public float SparseRadius = 200.0f;
    public boolean KillNoisy = false;
    public float NoiseWindow = 100.0f;
    public float NoiseCutoff = 10.0f;
    protected ArrayList<MarineFileInfo> MarineFileList = new ArrayList();
    protected EnsembleWorker_ButterworthLowPass m_filterLP = new EnsembleWorker_ButterworthLowPass();
    protected EnsembleWorker_RMS m_rms = new EnsembleWorker_RMS();

    public Action_ImportPreStackPlugin(IPlugin plugin) {
        try {
            this.m_plugin = plugin;
            String fileLabel = plugin.getImportFileType();
            this.Description = "Import Pre-stack " + fileLabel + " files";
            this.MemoryRequired = 1024;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected boolean prepareTables() {
        try {
            this.m_fileTable.setName("FileList");
            this.m_fileIndex_FileID = this.m_fileTable.column_append("FileID", DataType.Int);
            this.m_fileIndex_Name = this.m_fileTable.column_append("Name", DataType.Text);
            this.m_fileIndex_Path = this.m_fileTable.column_append("Directory", DataType.Text);
            this.m_datasetTable.setName("DatasetList");
            this.m_datasetIndex_Name = this.m_datasetTable.column_append("Name", DataType.Text);
            this.m_traceTablePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "TraceTable");
            this.m_shotTable.setName("Shot");
            this.m_shotParser = new TableParser(this.m_shotTable);
            this.m_receiverTable.setName("Receiver");
            this.m_receiverParser = new TableParser(this.m_receiverTable);
            this.m_receiverParser.IsMarine = this.IsMarine;
            this.m_receiverParser.RecBinSize = this.RecBinSize;
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            this.FailureReason = ex.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkDimension() {
        try {
            if (!this.Hasher.string_exists("Dimension")) {
                this.FailureReason = "Dimension not specified";
                this.Failed = true;
                return false;
            }
            this.m_dimension = this.Hasher.string_get("Dimension");
            if (!this.m_dimension.equalsIgnoreCase("3D")) {
                this.m_dimension = "2D";
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            this.FailureReason = ex.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkUnits() {
        try {
            if (!this.Hasher.string_exists("Units")) {
                this.FailureReason = "Units not specified";
                this.Failed = true;
                return false;
            }
            this.m_units = this.Hasher.string_get("Units");
            if (!this.m_units.equalsIgnoreCase("Feet")) {
                this.m_units = "Meters";
            }
            double gridSize = Pecos.gridSize(this.m_units);
            this.m_grid3D.setBinSize(gridSize, gridSize);
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            this.FailureReason = ex.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkFiles() {
        try {
            if (!this.Hasher.stringList_exists("FileList")) {
                this.FailureReason = "Input data file list not specified";
                this.Failed = true;
                return false;
            }
            this.m_fileList = this.Hasher.stringList_get("FileList");
            for (String fileName : this.m_fileList) {
                if (!this.m_plugin.checkFile(fileName)) continue;
                this.m_fileListChecked.add(fileName);
                this.m_traceCount = (int)((long)this.m_traceCount + this.m_plugin.getFileTraceCount(fileName));
            }
            if (this.m_traceCount < 1) {
                this.FailureReason = "No valid input data files specified";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            this.FailureReason = ex.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkParentPath() {
        try {
            if (!this.Hasher.string_exists("ParentPath")) {
                this.FailureReason = "Parent path not specified";
                this.Failed = true;
                return false;
            }
            this.m_parentPath = this.Hasher.string_get("ParentPath");
            if (!Tools_FileSystem.exists_path(this.m_parentPath)) {
                this.FailureReason = "Parent path not valid";
                this.Failed = true;
                return false;
            }
            String projectPath = this.m_parentPath + "/" + this.m_projectName;
            this.m_projectPath = this.m_parentPath + "/" + this.m_projectName + ".xtref";
            if (Tools_FileSystem.exists_path(projectPath)) {
                this.FailureReason = "Project path already exists";
                this.Failed = true;
                return false;
            }
            if (Tools_FileSystem.exists_path(this.m_projectPath)) {
                this.FailureReason = "Project path already exists";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            this.FailureReason = ex.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkName() {
        try {
            if (!this.Hasher.string_exists("ProjectName")) {
                this.FailureReason = "Project name not specified";
                this.Failed = true;
                return false;
            }
            this.m_projectName = this.Hasher.string_get("ProjectName");
            if (this.m_projectName.length() <= 1) {
                this.FailureReason = "Project name is too short";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            this.FailureReason = ex.getMessage();
            this.Failed = true;
            return false;
        }
    }

    public void filterEnsemble(Ensemble ensemble) {
        try {
            if (!ensemble.dictionary().containsEntry("Shot", "Easting")) {
                return;
            }
            if (!ensemble.dictionary().containsEntry("Shot", "Northing")) {
                return;
            }
            if (!ensemble.dictionary().containsEntry("Receiver", "Easting")) {
                return;
            }
            if (!ensemble.dictionary().containsEntry("Receiver", "Northing")) {
                return;
            }
            int indexShotX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexReceiverX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexReceiverY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            for (int t = ensemble.traceCount() - 1; t >= 0; --t) {
                double receiverY;
                double dY;
                EnsembleTrace trace = ensemble.trace(t);
                double shotX = trace.header().getDouble(indexShotX);
                double shotY = trace.header().getDouble(indexShotY);
                double receiverX = trace.header().getDouble(indexReceiverX);
                double dX = receiverX - shotX;
                double offset = Math.sqrt(1.0E-30 + dX * dX + (dY = (receiverY = trace.header().getDouble(indexReceiverY)) - shotY) * dY);
                if (!(offset < this.MinOffset) && !(offset > this.MaxOffset)) continue;
                ensemble.removeTrace(t);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void mergeEnsemble(Ensemble ensemble) {
        try {
            this.updateChannelRange(ensemble);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "Flags", 0, 0, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FileID", 0, this.m_currentFileID, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "Killed", 0, 0, 0);
            this.m_shotParser.handleEnsemble(ensemble);
            this.m_receiverParser.handleEnsemble(ensemble);
            if (!this.m_plugin.importFBP()) {
                Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_User", 0, -9999, 0);
            }
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_Back1", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_Back2", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_Back3", 0, -9999, 0);
            Tools_Ensemble.setHeaderFloat(ensemble, "Trace", "FBP_PickPredDT", -9999.0f);
            Tools_Ensemble.setHeaderFloat(ensemble, "Trace", "FBP_PickPredVNS", -9999.0f);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_AMP", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_PickT", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_TAP", 0, -9999, 0);
            this.m_plugin.addFBPTraceHeaderValues(ensemble);
            Tools_Ensemble.computeInlineCrossline(ensemble, this.m_grid3D);
            if (this.m_diskTable == null) {
                this.m_diskTable = new TraceTable_Huge(this.m_traceTablePath, "Trace", ensemble, 6);
            }
            int tracesAdded = this.m_diskTable.appendEnsemble(ensemble);
            this.m_traceCount += tracesAdded;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void updateChannelRange(Ensemble ensemble) {
        try {
            if (!ensemble.dictionary().containsEntry("Trace", "Channel")) {
                return;
            }
            int index = ensemble.dictionary().getEntryIndex("Trace", "Channel");
            for (int t = 0; t < ensemble.traceCount(); ++t) {
                int channel = ensemble.trace(t).header().getInt(index);
                this.m_channelMax = Math.max(this.m_channelMax, channel);
                this.m_channelMin = Math.min(this.m_channelMin, channel);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            String driverName = "HSQLDB";
            SharedApplicationData.singleton().setDatabaseDriver(driverName);
            System.out.println("Action_ImportPreStackPlugin options: ");
            this.Hasher.print(0);
            if (!this.Hasher.stringList_exists("FileList")) {
                this.FailureReason = "Input data file list not specified";
                this.Failed = true;
                return false;
            }
            this.m_fileList = this.Hasher.stringList_get("FileList");
            System.out.println("Prepare plugin for import...");
            this.m_plugin.prepareForImport(this.m_fileList);
            System.out.println("Prepare plugin for import done");
            if (!this.checkUnits()) {
                return false;
            }
            if (!this.checkDimension()) {
                return false;
            }
            if (!this.checkFiles()) {
                return false;
            }
            if (!this.checkName()) {
                return false;
            }
            if (!this.checkParentPath()) {
                return false;
            }
            System.out.println("All preliminary checks have been passed");
            if (this.CreateCompressed) {
                return this.work_compressed(messageServer);
            }
            System.out.println("creating uncompressed");
            String projectFolder = this.m_projectName + ".xtref";
            this.m_projectPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_parentPath, projectFolder);
            if (!this.prepareTables()) {
                return false;
            }
            System.out.println("Project table prep OK");
            if (this.m_fileListChecked.isEmpty()) {
                return false;
            }
            System.out.println("Project file check OK");
            for (String fileName : this.m_fileListChecked) {
                if (this.Halt) continue;
                this.importFile(fileName, messageServer);
            }
            this.m_diskTable.finishedAppending(null);
            if (this.Halt) {
                Tools_FileSystem.deletePathIfExists(this.m_projectPath);
                this.FailureReason = "Import action halted";
                this.Failed = true;
                return false;
            }
            this.m_diskTable = null;
            messageServer.setMessage_Level1("Creating trace table indices");
            TraceTable_Huge_Wrapper wrapper = new TraceTable_Huge_Wrapper(this.m_traceTablePath);
            messageServer.setMessage_Level1("Saving tables");
            String versionsPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "Versions");
            String currentPath = Tools_FileSystem.confirmSubDirectoryExists(versionsPath, "Default");
            this.m_fileTable.saveToPath(this.m_projectPath);
            this.m_datasetTable.saveToPath(this.m_projectPath);
            String dbFileName = currentPath + "/geometry.db";
            IDatabaseConnection database = Tools_JDBC.getConnection(false, dbFileName);
            long startTime = System.currentTimeMillis();
            database.createDatabaseTable(this.m_shotTable);
            database.appendTable(this.m_shotTable, 0);
            database.createDatabaseTable(this.m_receiverTable);
            database.appendTable(this.m_receiverTable, 0);
            database.createDatabaseTable(this.m_fileTable);
            database.appendTable(this.m_fileTable, 0);
            long endTime = System.currentTimeMillis();
            System.out.println("Write database to disk; time = " + (endTime - startTime) + " ms");
            database.addColumn("Shot", "Killed", DataType.Bool);
            database.executeUpdateStatement(String.format("UPDATE Shot Set %s = FALSE", "Killed"));
            database.addColumn("Shot", "InitialEasting", DataType.Double);
            database.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialEasting", "Easting"));
            database.addColumn("Shot", "InitialNorthing", DataType.Double);
            database.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialNorthing", "Northing"));
            database.addColumn("Shot", "InitialElevation", DataType.Double);
            database.executeUpdateStatement(String.format("UPDATE Shot Set %s = %s", "InitialElevation", "Elevation"));
            database.addColumn("Receiver", "Killed", DataType.Bool);
            database.executeUpdateStatement(String.format("UPDATE Receiver Set %s = FALSE", "Killed"));
            database.addColumn("Receiver", "InitialEasting", DataType.Double);
            database.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialEasting", "Easting"));
            database.addColumn("Receiver", "InitialNorthing", DataType.Double);
            database.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialNorthing", "Northing"));
            database.addColumn("Receiver", "InitialElevation", DataType.Double);
            database.executeUpdateStatement(String.format("UPDATE Receiver Set %s = %s", "InitialElevation", "Elevation"));
            String gridFileName = this.m_projectPath + "/GridDefinition3D.xml";
            this.m_grid3D.save(gridFileName);
            ParameterTree parameterTree = new ParameterTree();
            Date date = new Date();
            String dateCreated = date.toString();
            parameterTree.string_put("DriverName", driverName);
            parameterTree.string_put("Units", this.m_units);
            parameterTree.string_put("Dimension", this.m_dimension);
            parameterTree.bool_put("HasSeismic", true);
            parameterTree.bool_put("HasShots", true);
            parameterTree.bool_put("HasReceivers", true);
            parameterTree.int_put("ShotCount", this.m_shotTable.row_count());
            parameterTree.int_put("ReceiverCount", this.m_receiverTable.row_count());
            parameterTree.int_put("TraceCount", this.m_traceCount);
            parameterTree.string_put("Origin", this.m_plugin.getImportFileType());
            parameterTree.string_put("DateCreated", dateCreated);
            parameterTree.string_put("DateLastOpened", dateCreated);
            parameterTree.int_put("ChannelMax", this.m_channelMax);
            parameterTree.int_put("ChannelMin", this.m_channelMin);
            String parameterTreeFileName = this.m_projectPath + "/ProjectDescription.xml";
            parameterTree.save(parameterTreeFileName);
            String shotConflictsFileName = this.m_projectPath + "/ShotConflicts.xml";
            this.m_shotParser.saveConflicts(shotConflictsFileName);
            String receiverConflictsFileName = this.m_projectPath + "/ReceiverConflicts.xml";
            this.m_receiverParser.saveConflicts(receiverConflictsFileName);
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            this.FailureReason = ex.getMessage();
            this.Failed = true;
            return false;
        }
    }

    public boolean work_compressed(IProgressMonitor messageServer) {
        try {
            this.m_datasetTable.setName("DatasetList");
            this.m_datasetIndex_Name = this.m_datasetTable.column_append("Name", DataType.Text);
            for (String dataset : this.m_fileListChecked) {
                if (this.Halt) continue;
                System.out.println("Importing file (compressed): " + dataset);
                this.importFile_Compressed(dataset, messageServer);
                System.out.println("Successfully imported file): " + dataset);
            }
            this.m_datasetTable.saveToPath(this.m_projectPath);
            this.m_projectCreator.done();
            if (this.IsMarine && this.MarineShotLineIncrement > 0) {
                this.saveMarineFileList();
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            this.FailureReason = ex.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected void importFile(String fileName, IProgressMonitor messageServer) {
        try {
            if (this.Halt) {
                return;
            }
            this.m_plugin.openDataset(fileName);
            if (!this.m_plugin.populateDictionary(this.IsMarine)) {
                this.m_plugin.closeDataset(fileName);
                this.Halt = true;
                return;
            }
            this.m_plugin.addAdditionalHeadersToDictionary();
            ++this.m_currentFileID;
            int fileRow = this.m_fileTable.row_increment();
            this.m_fileTable.putInt(fileRow, this.m_fileIndex_FileID, this.m_currentFileID);
            this.m_fileTable.putString(fileRow, this.m_fileIndex_Name, fileName);
            this.m_fileTable.putString(fileRow, this.m_fileIndex_Path, this.m_plugin.getFileParentPath(fileName));
            int datasetRow = this.m_datasetTable.row_increment();
            this.m_datasetTable.putString(datasetRow, this.m_datasetIndex_Name, fileName);
            Ensemble ensemble = new Ensemble(this.m_plugin.getDictionary().createExactCopy());
            while (!this.m_plugin.allTracesRead() && !this.Halt) {
                long tracesRead = this.m_plugin.readEnsemble(ensemble);
                this.mergeEnsemble(ensemble);
                this.m_tracesRead = (int)((long)this.m_tracesRead + tracesRead);
                String message = String.format("%d traces, %d shots, %d receivers", this.m_tracesRead, this.m_shotTable.row_count(), this.m_receiverTable.row_count());
                messageServer.setMessage_Level1(message);
                message = String.format("Number of geometry conflicts: %d shot, %d receiver", this.m_shotParser.totalConflicts(), this.m_receiverParser.totalConflicts());
                messageServer.setMessage_Level2(message);
                messageServer.setPercentDone(100.0 * (double)this.m_tracesRead / (double)this.m_traceCount);
            }
            this.m_plugin.closeDataset(fileName);
            System.gc();
            System.gc();
            System.gc();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void importFile_Compressed(String fileName, IProgressMonitor messageServer) {
        try {
            if (this.Halt) {
                return;
            }
            System.out.println("Starting import for file: " + fileName);
            System.out.println("Starting import IsMarine: " + this.IsMarine);
            this.m_plugin.openDataset(fileName);
            System.out.println("m_plugin.openDataset: ok ");
            if (!this.m_plugin.populateDictionary(this.IsMarine)) {
                this.m_plugin.closeDataset(fileName);
                this.Halt = true;
                return;
            }
            this.m_plugin.addAdditionalHeadersToDictionary();
            int datasetRow = this.m_datasetTable.row_increment();
            String datasetName = Tools_FileSystem.convertToUnixFileName(fileName);
            this.m_datasetTable.putString(datasetRow, this.m_datasetIndex_Name, datasetName);
            Ensemble ensemble = new Ensemble(this.m_plugin.getDictionary().createExactCopy());
            ensemble.dictionary().print();
            Logger logger = Logger.getLogger("ImportLogger");
            if (this.m_projectCreator != null && this.IsMarine && this.MarineShotLineIncrement > 0) {
                this.addMarineFileInfo(this.MarineShotLineNumber, fileName);
                this.m_projectCreator.shotParser().DefaultLineNumber = this.MarineShotLineNumber;
                this.MarineShotLineNumber += this.MarineShotLineIncrement;
            }
            int num_gathers_read = 0;
            int num_gathers = 0;
            while (!this.m_plugin.allTracesRead() && !this.Halt) {
                if (num_gathers_read < 10 || num_gathers_read % 1000 == 0) {
                    System.out.println("reading gather: " + num_gathers_read);
                }
                long tracesRead = this.m_plugin.readEnsemble(ensemble);
                if (num_gathers_read < 10 || num_gathers_read % 1000 == 0) {
                    System.out.println("num_gathers_read: " + num_gathers_read);
                }
                ++num_gathers_read;
                this.m_rms.performWork(ensemble);
                ensemble = this.m_rms.output(0);
                if (ensemble.traceCount() > 0) {
                    ++num_gathers;
                    if (this.m_projectCreator == null) {
                        int inputSampleCount = ensemble.trace(0).data().length();
                        float inputSampleInterval = ensemble.trace(0).data().getSampleInterval();
                        double dSampleInterval = Math.abs(inputSampleInterval - this.OutputSampleInterval);
                        this.RequireFilter = dSampleInterval > (double)0.1f;
                        double nyquist = 500.0f / this.OutputSampleInterval;
                        double cutoff = 0.6 * nyquist;
                        cutoff = Math.max(cutoff, 25.0);
                        cutoff = Math.min(cutoff, 80.0);
                        this.m_filterLP.parameterTree().int_put("Length", 41);
                        this.m_filterLP.parameterTree().int_put("PoleCount", 4);
                        this.m_filterLP.parameterTree().double_put("Frequency", cutoff);
                        String canonHome = SharedApplicationData.singleton().homeDirectory();
                        this.m_projectCreator = new ProjectCreator(logger, canonHome, this.m_projectName, this.m_plugin.getImportFileType(), true, this.MaxTime, inputSampleCount, inputSampleInterval, ensemble.dictionary(), this.m_units.equalsIgnoreCase("Meters"), this.m_dimension.equalsIgnoreCase("3D"), this.Resample, this.OutputSampleInterval);
                        if (this.IsMarine) {
                            this.m_projectCreator.prepareReceiverMarineOptions(this.RecBinSize, this.MarineDecimation);
                            if (this.MarineShotLineIncrement > 0) {
                                this.MarineShotLineNumber = this.MarineShotLineIncrement;
                                this.m_projectCreator.shotParser().ForceLineToBeDefault = true;
                                this.m_projectCreator.shotParser().DefaultLineNumber = this.MarineShotLineNumber;
                                this.addMarineFileInfo(this.MarineShotLineNumber, fileName);
                                this.MarineShotLineNumber += this.MarineShotLineIncrement;
                            }
                        }
                        if (this.CreateSparse) {
                            this.m_projectCreator.prepareSparseCmpOptions(this.SparseSpacing, this.SparseRadius);
                        }
                        if (this.KillNoisy) {
                            this.m_projectCreator.killNoisyTraces(this.NoiseWindow, this.NoiseCutoff);
                        }
                    }
                    if (this.KillOffsets) {
                        this.filterEnsemble(ensemble);
                    }
                    if (this.RequireFilter) {
                        this.m_filterLP.performWork(ensemble);
                    }
                    if (this.DecimateInput) {
                        ensemble.decimate(this.Decimation);
                    }
                    this.m_projectCreator.mergeEnsemble(ensemble);
                }
                this.m_tracesRead = (int)((long)this.m_tracesRead + tracesRead);
                if (this.m_projectCreator != null) {
                    String message = String.format("%d traces, %d shots, %d receivers", this.m_tracesRead, this.m_projectCreator.shotTable().row_count(), this.m_projectCreator.receiverTable().row_count());
                    messageServer.setMessage_Level1(message);
                    message = String.format("Number of geometry conflicts: %d shot, %d receiver", this.m_projectCreator.shotParser().totalConflicts(), this.m_projectCreator.receiverParser().totalConflicts());
                    messageServer.setMessage_Level2(message);
                }
                messageServer.setPercentDone(100.0 * ((double)this.m_tracesRead / (double)this.m_traceCount));
            }
            System.out.println("Finishing import for file: " + fileName);
            this.m_plugin.closeDataset(fileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void saveMarineFileList() {
        try {
            if (this.MarineFileList.size() < 1) {
                return;
            }
            String fileName = this.m_projectPath + "/MarineShotFile.txt";
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            for (MarineFileInfo info : this.MarineFileList) {
                String line = String.format("%d    %s", info.ShotLineNumber, info.FileName);
                writer.write(line);
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void addMarineFileInfo(int shotLine, String fileName) {
        try {
            this.MarineFileList.add(new MarineFileInfo(shotLine, fileName));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class MarineFileInfo {
        public int ShotLineNumber = 0;
        public String FileName = "";

        public MarineFileInfo(int shotLine, String fileName) {
            this.ShotLineNumber = shotLine;
            this.FileName = fileName;
        }
    }
}

