/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Geometry;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import java.io.File;

public class Action_ExportAllProjects
extends Action_Base {
    public String ExportPath = "";
    protected String m_prefix1 = "SELECT LINENUMBER, POINTNUMBER, POINTINDEX,  DISTANCEMOVED, EASTING, NORTHING, INITIALEASTING, INITIALNORTHING";
    protected String m_prefix2 = "SELECT LINENUMBER, POINTNUMBER, POINTINDEX,  EASTING, NORTHING, KILLED";
    protected String m_prefix3 = "SELECT LINENUMBER, POINTNUMBER, POINTINDEX,  EASTING, NORTHING, POLARITY, KILLED";
    protected String m_temp2 = " WHERE KILLED = false AND DISTANCEMOVED > 20 AND DISTANCEMOVED < 50000 ORDER BY DISTANCEMOVED";
    protected Table_Abstract m_summaryTable;
    protected int m_indexName;
    protected int m_recMoveCount;
    protected int m_recKillCount;
    protected int m_recPolarityCount;
    protected int m_shotMoveCount;
    protected int m_shotKillCount;

    public Action_ExportAllProjects() {
        this.Description = "Export info for all projects";
        this.MemoryRequired = 1024;
    }

    @Override
    protected void justReadFromNode() {
    }

    public void exportProject(String exportPath, String projectName, IDatabaseConnection geometryConn, IProgressMonitor messageServer) {
        try {
            Table_Abstract receiverTable = geometryConn.extractTableDataUsingQuery("Receiver", "SELECT * FROM Receiver", Pecos.MaxQueryRowCount);
            Table_Abstract shotTable = geometryConn.extractTableDataUsingQuery("Shot", "SELECT * FROM Shot", Pecos.MaxQueryRowCount);
            int row = -9999;
            if (this.m_summaryTable != null) {
                row = this.m_summaryTable.row_increment();
                this.m_summaryTable.putString(row, this.m_indexName, projectName);
            }
            String pr = exportPath + "/";
            if (messageServer != null) {
                messageServer.setMessage_Level2("Compute distance moved");
            }
            Tools_RefractionStaticsProject.computeDistanceMoved(shotTable);
            geometryConn.writeColumnContentsToDatabase(shotTable, "DistanceMoved");
            Tools_RefractionStaticsProject.computeDistanceMoved(receiverTable);
            geometryConn.writeColumnContentsToDatabase(receiverTable, "DistanceMoved");
            String sql = this.m_prefix1 + " FROM RECEIVER " + this.m_temp2;
            Table_Abstract tbl = geometryConn.extractTableDataUsingQuery("Receiver", sql, Pecos.MaxQueryRowCount);
            if (row >= 0) {
                this.m_summaryTable.putInt(row, this.m_recMoveCount, tbl.row_count());
            }
            if (tbl.row_count() > 0) {
                tbl.exportColumn(pr + projectName + "_rec_moves.txt");
            }
            sql = this.m_prefix2 + " FROM RECEIVER WHERE KILLED = true";
            tbl = geometryConn.extractTableDataUsingQuery("Receiver", sql, Pecos.MaxQueryRowCount);
            if (row >= 0) {
                this.m_summaryTable.putInt(row, this.m_recKillCount, tbl.row_count());
            }
            if (tbl.row_count() > 0) {
                tbl.exportColumn(pr + projectName + "_rec_kills.txt");
            }
            sql = this.m_prefix3 + " FROM RECEIVER WHERE KILLED = false AND POLARITY < 0";
            tbl = geometryConn.extractTableDataUsingQuery("Receiver", sql, Pecos.MaxQueryRowCount);
            if (row >= 0) {
                this.m_summaryTable.putInt(row, this.m_recPolarityCount, tbl.row_count());
            }
            if (tbl.row_count() > 0) {
                tbl.exportColumn(pr + projectName + "_rec_polarity.txt");
            }
            sql = this.m_prefix1 + " FROM SHOT " + this.m_temp2;
            tbl = geometryConn.extractTableDataUsingQuery("Shot", sql, Pecos.MaxQueryRowCount);
            if (row >= 0) {
                this.m_summaryTable.putInt(row, this.m_shotMoveCount, tbl.row_count());
            }
            if (tbl.row_count() > 0) {
                tbl.exportColumn(pr + projectName + "_shot_moves.txt");
            }
            sql = this.m_prefix2 + " FROM SHOT WHERE KILLED = true";
            tbl = geometryConn.extractTableDataUsingQuery("Shot", sql, Pecos.MaxQueryRowCount);
            if (row >= 0) {
                this.m_summaryTable.putInt(row, this.m_shotKillCount, tbl.row_count());
            }
            if (tbl.row_count() > 0) {
                tbl.exportColumn(pr + projectName + "_shot_kills.txt");
            }
            this.exportTraceKill(pr, projectName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void exportProject(IProgressMonitor messageServer, String projectName) {
        try {
            IDatabaseConnection geometryConn;
            if (projectName.equalsIgnoreCase("mergefulltest")) {
                return;
            }
            messageServer.setMessage_Level1("Working on project " + projectName);
            messageServer.setMessage_Level2("Loading project");
            System.out.println("Working on project " + projectName);
            String currentName = RefractionStaticsProject.singleton().name();
            if (currentName.equalsIgnoreCase(projectName)) {
                geometryConn = RefractionStaticsProject.singleton().geometryDatabase();
            } else {
                String parentPath = SharedApplicationData.staticsProjectPath();
                String projectPath = parentPath + "/" + projectName;
                String paramFileName = projectPath + "/ProjectDescription.xml";
                ParameterTree information = new ParameterTree();
                information.read(paramFileName);
                String version = information.string_get("Version", "Default");
                String versionContainerPath = projectPath + "/Versions";
                String currentVersionPath = versionContainerPath + "/" + version;
                String fileNameDB = currentVersionPath + "/geometry.db";
                geometryConn = Tools_JDBC.getConnection(false, fileNameDB);
            }
            this.exportProject(this.ExportPath, projectName, geometryConn, messageServer);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void exportTraceKill(String pr, String projectName) {
        try {
            Table_Memory table = new Table_Memory();
            int indexFFID = table.column_append("FFID", DataType.Int);
            int indexChan = table.column_append("Channel", DataType.Int);
            int indexKilled = table.column_append("Killed", DataType.Bool);
            int indexPolarity = table.column_append("Polarity", DataType.Int);
            int indexSX = table.column_append("ShotX", DataType.Double);
            int indexSY = table.column_append("ShotY", DataType.Double);
            int indexRX = table.column_append("ReceiverX", DataType.Double);
            int indexRY = table.column_append("ReceiverY", DataType.Double);
            Table_Abstract shotTable = RefractionStaticsProject.singleton().getShotTable();
            HashMap_Integer shotMap = shotTable.createMapID();
            int indexShotFFID = shotTable.column_indexOfColumn("FFID");
            int indexShotX = shotTable.column_indexOfColumn("Easting");
            int indexShotY = shotTable.column_indexOfColumn("Northing");
            Table_Abstract receiverTable = RefractionStaticsProject.singleton().getRecTable();
            HashMap_Integer receiverMap = receiverTable.createMapID();
            int indexReceiverX = receiverTable.column_indexOfColumn("Easting");
            int indexReceiverY = receiverTable.column_indexOfColumn("Northing");
            ITraceTable traceTable = RefractionStaticsProject.singleton().getTraceTable();
            int indexTraceShot = traceTable.column_indexOfColumn("ShotID");
            int indexTraceReceiver = traceTable.column_indexOfColumn("ReceiverID");
            int indexTraceChan = traceTable.column_indexOfColumn("Channel");
            int indexTraceKilled = traceTable.column_indexOfColumn("Killed");
            int indexTracePolarity = traceTable.column_indexOfColumn("Flags");
            int tracker = 0;
            for (long n = 0L; n < traceTable.rowCount(); ++n) {
                int killed = traceTable.getInt(n, indexTraceKilled);
                if (killed != 1) continue;
                table.row_increment();
                int shotID = traceTable.getInt(n, indexTraceShot);
                int receiverID = traceTable.getInt(n, indexTraceReceiver);
                int chan = traceTable.getInt(n, indexTraceChan);
                int polarity = traceTable.getInt(n, indexTracePolarity);
                int shotRow = shotMap.get(shotID);
                int ffid = shotTable.getInt(shotRow, indexShotFFID);
                double shotX = shotTable.getDouble(shotRow, indexShotX);
                double shotY = shotTable.getDouble(shotRow, indexShotY);
                int receiverRow = receiverMap.get(receiverID);
                double receiverX = receiverTable.getDouble(receiverRow, indexReceiverX);
                double receiverY = receiverTable.getDouble(receiverRow, indexReceiverY);
                table.putInt(tracker, indexFFID, ffid);
                table.putInt(tracker, indexChan, chan);
                table.putBool(tracker, indexKilled, true);
                table.putInt(tracker, indexPolarity, polarity);
                table.putDouble(tracker, indexSX, shotX);
                table.putDouble(tracker, indexSY, shotY);
                table.putDouble(tracker, indexRX, receiverX);
                table.putDouble(tracker, indexRY, receiverY);
                ++tracker;
            }
            if (table.row_count() > 0) {
                table.exportColumn(pr + projectName + "_trace_kills.txt");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            this.m_summaryTable = new Table_Memory();
            this.m_indexName = this.m_summaryTable.column_append("ProjectName", DataType.Text);
            this.m_recMoveCount = this.m_summaryTable.column_append("ReceiverMoveCount", DataType.Int);
            this.m_recKillCount = this.m_summaryTable.column_append("ReceiverKillCount", DataType.Int);
            this.m_recPolarityCount = this.m_summaryTable.column_append("ReceiverPolarityCount", DataType.Int);
            this.m_shotMoveCount = this.m_summaryTable.column_append("ShotMoveCount", DataType.Int);
            this.m_shotKillCount = this.m_summaryTable.column_append("ShotKillCount", DataType.Int);
            String parentPath = SharedApplicationData.staticsProjectPath();
            File parentFile = new File(parentPath);
            File[] files = parentFile.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    String name = files[i].getName();
                    this.exportProject(messageServer, name);
                }
                if (!this.Halt) continue;
                i = 10000000;
            }
            String fileName = this.ExportPath + "/summary.txt";
            this.m_summaryTable.exportColumn(fileName);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }
}

