/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Export;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class Action_ExportTomoData
extends Action_Base {
    protected Table_Abstract m_shotTable;
    protected int m_numShots = 0;
    protected int m_columnShotID;
    protected int m_columnShotKilled;
    protected int m_columnShotX;
    protected int m_columnShotY;
    protected int m_columnShotZ;
    protected int m_columnShotUphole = -9999;
    protected int m_columnShotDepth = -9999;
    protected Table_Abstract m_recTable;
    protected HashMap_Integer m_recHash = new HashMap_Integer();
    protected int m_numRecs = 0;
    protected int m_columnRecID;
    protected int m_columnRecKilled;
    protected int m_columnRecX;
    protected int m_columnRecY;
    protected int m_columnRecZ;
    protected int m_columnRecUphole = -9999;
    protected int m_columnRecDepth = -9999;
    public String Directory;
    public double GridSize = 50.0;
    public double Depth = 500.0;
    public double VelTop = 3000.0;
    public double VelBottom = 9000.0;
    protected double m_maxZ = Double.MIN_VALUE;

    public Action_ExportTomoData() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Export tomography analysis file";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    protected void justReadFromNode() {
    }

    protected void comment(BufferedWriter writer, String s) {
    }

    protected void exportModelData() {
        try {
            String fileName = this.Directory + "/grid.txt";
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            this.comment(writer, "=============================================================");
            this.comment(writer, "The first line  describes the grid:");
            this.comment(writer, "FORMAT:  Angle   GridSize  X   Y  Z  NumInline  NumCrossline");
            Grid3D grid = Tools_RefractionStaticsProject.getInterpolatedGrid(this.GridSize, this.GridSize, "Elevation", true);
            double bestAngle = grid.inlineAngle();
            double cornerX = grid.getWorldX(grid.inlineMin(), grid.crosslineMin());
            double cornerY = grid.getWorldY(grid.inlineMin(), grid.crosslineMin());
            int numInline = grid.numInline();
            int numCrossline = grid.numCrossline();
            writer.write(Double.toString(bestAngle) + " ");
            writer.write(Double.toString(this.GridSize) + " ");
            writer.write(Integer.toString((int)cornerX) + " ");
            writer.write(Integer.toString((int)cornerY) + " ");
            writer.write(Integer.toString((int)(1.0 + this.m_maxZ)) + " ");
            writer.write(Integer.toString(numInline) + " ");
            writer.write(Integer.toString(numCrossline));
            writer.newLine();
            writer.write(Double.toString(this.VelTop) + " ");
            writer.write(Double.toString(this.VelBottom) + " ");
            writer.newLine();
            this.comment(writer, "=============================================================");
            this.comment(writer, "Now export the surface elevation at each grid location");
            this.comment(writer, "FORMAT:  InlineIndex  CrosslineIndex  Elevation");
            for (int i = 0; i < numInline; ++i) {
                for (int c = 0; c < numCrossline; ++c) {
                    cornerX = grid.getWorldX(i + grid.inlineMin(), c + grid.crosslineMin());
                    cornerY = grid.getWorldY(i + grid.inlineMin(), c + grid.crosslineMin());
                    float elev = grid.getNearestValue(cornerX, cornerY, true);
                    writer.write(Integer.toString(i) + " ");
                    writer.write(Integer.toString(c) + " ");
                    writer.write(Integer.toString((int)elev));
                    writer.newLine();
                }
            }
            writer.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepShot() {
        try {
            this.m_shotTable = RefractionStaticsProject.singleton().shotTable();
            this.m_columnShotID = this.m_shotTable.column_indexOfColumn("ShotID");
            this.m_columnShotKilled = this.m_shotTable.column_indexOfColumn("Killed");
            this.m_columnShotX = this.m_shotTable.column_indexOfColumn("Easting");
            this.m_columnShotY = this.m_shotTable.column_indexOfColumn("Northing");
            this.m_columnShotZ = this.m_shotTable.column_indexOfColumn("Elevation");
            if (this.m_shotTable.column_exists("UpholeTime")) {
                this.m_columnShotUphole = this.m_shotTable.column_indexOfColumn("UpholeTime");
            }
            if (this.m_shotTable.column_exists("PointDepth")) {
                this.m_columnShotDepth = this.m_shotTable.column_indexOfColumn("PointDepth");
            }
            this.m_numShots = 0;
            for (int n = 0; n < this.m_shotTable.row_count(); ++n) {
                if (this.m_shotTable.getBool(n, this.m_columnShotKilled)) continue;
                ++this.m_numShots;
            }
            String fileName = this.Directory + "/shot.txt";
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            this.comment(writer, "=============================================================");
            this.comment(writer, "Shot information:");
            this.comment(writer, "FORMAT: S  ShotID  X  Y  Z  DEPTH  UPHOLE");
            for (int n = 0; n < this.m_shotTable.row_count(); ++n) {
                if (this.m_shotTable.getBool(n, this.m_columnShotKilled)) continue;
                int shotID = this.m_shotTable.getInt(n, this.m_columnShotID);
                writer.write("S ");
                writer.write(Integer.toString(shotID) + " ");
                writer.write(this.m_shotTable.getString(n, this.m_columnShotX) + " ");
                writer.write(this.m_shotTable.getString(n, this.m_columnShotY) + " ");
                writer.write(this.m_shotTable.getString(n, this.m_columnShotZ) + " ");
                this.m_maxZ = Math.max(this.m_maxZ, this.m_shotTable.getDouble(n, this.m_columnShotZ));
                if (this.m_columnShotDepth >= 0) {
                    writer.write(this.m_shotTable.getString(n, this.m_columnShotDepth) + " ");
                } else {
                    writer.write("0 ");
                }
                if (this.m_columnShotUphole >= 0) {
                    writer.write(this.m_shotTable.getString(n, this.m_columnShotUphole));
                } else {
                    writer.write("0");
                }
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepRec() {
        try {
            this.m_recTable = RefractionStaticsProject.singleton().receiverTable();
            this.m_columnRecID = this.m_recTable.column_indexOfColumn("ReceiverID");
            this.m_columnRecKilled = this.m_recTable.column_indexOfColumn("Killed");
            this.m_columnRecX = this.m_recTable.column_indexOfColumn("Easting");
            this.m_columnRecY = this.m_recTable.column_indexOfColumn("Northing");
            this.m_columnRecZ = this.m_recTable.column_indexOfColumn("Elevation");
            if (this.m_recTable.column_exists("UpholeTime")) {
                this.m_columnRecUphole = this.m_recTable.column_indexOfColumn("UpholeTime");
            }
            if (this.m_recTable.column_exists("PointDepth")) {
                this.m_columnRecDepth = this.m_recTable.column_indexOfColumn("PointDepth");
            }
            this.m_numRecs = 0;
            for (int n = 0; n < this.m_recTable.row_count(); ++n) {
                if (this.m_recTable.getBool(n, this.m_columnRecKilled)) continue;
                ++this.m_numRecs;
            }
            String fileName = this.Directory + "/rec.txt";
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            this.comment(writer, "=============================================================");
            this.comment(writer, "Receiver information:");
            this.comment(writer, "FORMAT: R  RecID  X  Y  Z  DEPTH  UPHOLE");
            for (int n = 0; n < this.m_recTable.row_count(); ++n) {
                if (this.m_recTable.getBool(n, this.m_columnRecKilled)) continue;
                int recID = this.m_recTable.getInt(n, this.m_columnRecID);
                this.m_recHash.put(recID, n);
                writer.write("R ");
                writer.write(Integer.toString(recID) + " ");
                writer.write(this.m_recTable.getString(n, this.m_columnRecX) + " ");
                writer.write(this.m_recTable.getString(n, this.m_columnRecY) + " ");
                writer.write(this.m_recTable.getString(n, this.m_columnRecZ) + " ");
                this.m_maxZ = Math.max(this.m_maxZ, this.m_recTable.getDouble(n, this.m_columnRecZ));
                if (this.m_columnRecDepth >= 0) {
                    writer.write(this.m_recTable.getString(n, this.m_columnRecDepth) + " ");
                } else {
                    writer.write("0 ");
                }
                if (this.m_columnRecUphole >= 0) {
                    writer.write(this.m_recTable.getString(n, this.m_columnRecUphole));
                } else {
                    writer.write("0");
                }
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            this.prepShot();
            this.prepRec();
            messageServer.setMessage_Level1("Export model and grid data");
            this.exportModelData();
            messageServer.setMessage_Level1("Export picks");
            String fileName = this.Directory + "/picks.txt";
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            this.comment(writer, "=============================================================");
            this.comment(writer, "Picks");
            this.comment(writer, "FORMAT: S  ShotID  TraceCount");
            this.comment(writer, "FORMAT: T  RecID  PickTime (repeated TraceCount times....)");
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Ensemble ensemble = new Ensemble();
            for (int n = 0; n < this.m_shotTable.row_count(); ++n) {
                float pick;
                int recID;
                EnsembleTrace trace;
                int k;
                double percent = 100.0 * (double)n / (double)this.m_shotTable.row_count();
                messageServer.setPercentDone(percent);
                if (this.m_shotTable.getBool(n, this.m_columnShotKilled)) continue;
                int shotID = this.m_shotTable.getInt(n, this.m_columnShotID);
                ensemble.clearTraces(false);
                project.ensemble_Shot(ensemble, shotID, false);
                int indexRecID = ensemble.dictionary().getEntryIndex("Trace", "ReceiverID");
                int indexPick = ensemble.dictionary().getEntryIndex("Trace", "FBP_User");
                int traceCount = 0;
                for (k = 0; k < ensemble.traceCount(); ++k) {
                    trace = ensemble.trace(k);
                    recID = trace.header().getInt(indexRecID);
                    pick = trace.header().getFloat(indexPick);
                    if (!this.m_recHash.containsKey(recID) || !(pick > 5.0f) || !(pick < 7000.0f)) continue;
                    ++traceCount;
                }
                if (traceCount < true) continue;
                writer.write("S ");
                writer.write(Integer.toString(shotID) + " ");
                writer.write(Integer.toString(traceCount));
                writer.newLine();
                for (k = 0; k < ensemble.traceCount(); ++k) {
                    trace = ensemble.trace(k);
                    recID = trace.header().getInt(indexRecID);
                    pick = trace.header().getFloat(indexPick);
                    if (!this.m_recHash.containsKey(recID) || !(pick > 5.0f) || !(pick < 7000.0f)) continue;
                    writer.write("T ");
                    writer.write(Integer.toString(recID) + " ");
                    writer.write(Float.toString(pick));
                    writer.newLine();
                }
            }
            writer.close();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }
}

