/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Action.Action_Messenger;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Action.Action_SharedDelayTimeData;
import com.PecosLibrary.Action.Action_Status;
import com.PecosLibrary.Data.Table_SimpleModel;
import java.lang.ref.WeakReference;

public class Action_Thread
extends Thread {
    protected Action_Sequence m_sequence = null;
    protected Table_Abstract m_table = new Table_Memory();
    protected Table_SimpleModel m_model = new Table_SimpleModel(this.m_table);
    public int m_colIndex_Description;
    public int m_colIndex_Status;
    public int m_colIndex_Message;
    public int m_colIndex_RunTime;
    public Action_SharedDelayTimeData SharedDelayTimeData;
    protected Action_Base m_currentAction = null;
    protected boolean m_finished = false;
    protected String m_sandboxPath = null;
    protected boolean m_bStopAllActions = false;
    public boolean ComputingShearWaveDelayTimes = false;
    protected long m_startTime;
    protected Action_Messenger m_messenger = new Action_Messenger();

    public Action_Thread() throws Exception {
        try {
            this.m_colIndex_Description = this.m_table.column_append("Description", DataType.Text);
            this.m_colIndex_Status = this.m_table.column_append("Status", DataType.Text);
            this.m_colIndex_Message = this.m_table.column_append("Message", DataType.Text);
            this.m_colIndex_RunTime = this.m_table.column_append("Run time", DataType.Text);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Action_Sequence sequence() {
        return this.m_sequence;
    }

    public void setSequence(Action_Sequence sequence) throws Exception {
        try {
            this.m_sequence = sequence;
            this.m_table.row_clear(true);
            for (int n = 0; n < sequence.size(); ++n) {
                int row = this.m_table.row_increment();
                Action_Base action = sequence.action(n);
                this.m_table.putString(row, this.m_colIndex_Description, action.Description);
                this.m_table.putString(row, this.m_colIndex_Status, action.Status.name());
                this.m_table.putString(row, this.m_colIndex_Message, " ");
                this.m_table.putString(row, this.m_colIndex_RunTime, " ");
            }
            this.m_model.fireTableDataChanged();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Table_SimpleModel tableModel() {
        return this.m_model;
    }

    public boolean finished() {
        return this.m_finished;
    }

    public String sandboxPath() {
        return this.m_sandboxPath;
    }

    public void stopCurrentAction() {
        try {
            if (this.m_currentAction != null) {
                this.m_currentAction.Halt = true;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void stopAllActions() {
        try {
            this.m_bStopAllActions = true;
            if (this.m_currentAction != null) {
                this.m_currentAction.Halt = true;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected String createNewSandbox() {
        try {
            String sandBoxParent = SharedApplicationData.singleton().homeSubDirectory("TempPaths");
            for (int n = 1000; n < 1000000; ++n) {
                String dir = "Temp" + Integer.toString(n);
                String path = sandBoxParent + "/" + dir;
                if (Tools_FileSystem.exists_path(path)) continue;
                return Tools_FileSystem.confirmSubDirectoryExists(sandBoxParent, dir);
            }
            return "ERROR";
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "ERROR";
        }
    }

    public void createSharedDelayTimeDataIfNeeded() {
        try {
            boolean bNeedDelayTimeTable = false;
            boolean completeTraceTable = false;
            for (int n = 0; n < this.m_sequence.size(); ++n) {
                this.m_currentAction = this.m_sequence.action(n);
                bNeedDelayTimeTable = bNeedDelayTimeTable || this.m_currentAction.RequiresDelayTimeData;
                completeTraceTable = completeTraceTable || this.m_currentAction.RequiresCompleteTraceTable;
                this.ComputingShearWaveDelayTimes = this.ComputingShearWaveDelayTimes || this.m_currentAction.ComputingShearWaveDelayTimes;
            }
            if (!bNeedDelayTimeTable) {
                return;
            }
            this.SharedDelayTimeData = new Action_SharedDelayTimeData();
            this.SharedDelayTimeData.Messenger = this.m_messenger;
            this.SharedDelayTimeData.createSharedDelayTimeData(this.m_sandboxPath, completeTraceTable);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void run() {
        try {
            this.m_finished = false;
            this.m_sandboxPath = this.createNewSandbox();
            this.createSharedDelayTimeDataIfNeeded();
            for (int n = 0; n < this.m_sequence.size() && !this.m_bStopAllActions; ++n) {
                this.m_currentAction = this.m_sequence.action(n);
                this.m_currentAction.SandboxPath = this.m_sandboxPath;
                this.m_currentAction.ThreadRef = new WeakReference<Action_Thread>(this);
                this.m_currentAction.DelayTimeData = this.SharedDelayTimeData;
                this.m_currentAction.Status = Action_Status.Running;
                this.m_messenger.setPercentDone(0.0);
                this.m_messenger.resetTaskStartTime();
                this.m_messenger.setMessage(0, this.m_currentAction.Description);
                this.m_messenger.setMessage(2, "");
                this.m_messenger.setMessage(3, "");
                this.m_messenger.setMessage(4, "");
                this.m_table.putString(n, this.m_colIndex_Status, this.m_currentAction.Status.name());
                this.m_messenger.setTableModified(true);
                long startTime = System.currentTimeMillis();
                this.runCurrentAction();
                long endTime = System.currentTimeMillis();
                String runTimeString = Tools_Strings.runTimeMessage((int)(endTime - startTime) / 1000);
                this.m_table.putString(n, this.m_colIndex_RunTime, runTimeString);
                System.out.println("Action_Thread " + this.m_currentAction.Description + " run time: " + runTimeString);
                if (this.m_currentAction.Failed) {
                    this.m_currentAction.Status = Action_Status.Failed;
                    this.m_table.putString(n, this.m_colIndex_Message, this.m_currentAction.FailureReason);
                } else {
                    this.m_currentAction.Status = Action_Status.Finished;
                    this.m_table.putString(n, this.m_colIndex_Message, this.m_currentAction.FinishMessage);
                }
                this.m_table.putString(n, this.m_colIndex_Status, this.m_currentAction.Status.name());
                this.m_currentAction.ThreadRef = null;
            }
            if (this.SharedDelayTimeData != null) {
                this.m_messenger.setMessage(2, "Update database tables");
                this.SharedDelayTimeData.finalizeDelayTimeData(this.ComputingShearWaveDelayTimes);
            }
            this.m_currentAction = null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            this.m_messenger.setPercentDone(0.0);
            this.m_messenger.setMessage(0, "");
            this.m_messenger.setMessage(2, "");
            this.m_messenger.setMessage(3, "");
            this.m_messenger.setMessage(4, "");
            Tools_FileSystem.deletePathIfExists(this.m_sandboxPath);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        this.m_finished = true;
    }

    public void startThread() throws Exception {
        try {
            if (this.isAlive()) {
                throw new Exception("Thread already running");
            }
            if (this.m_sequence == null) {
                throw new Exception("m_sequence == null");
            }
            this.m_finished = false;
            this.m_bStopAllActions = false;
            this.m_currentAction = null;
            this.m_startTime = System.currentTimeMillis();
            this.start();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void runCurrentAction() {
        try {
            this.m_currentAction.work(this.m_messenger);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Action_Messenger messenger() {
        return this.m_messenger;
    }
}

