/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_TableDataV2;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeData;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import java.io.Serializable;

public class Action_SharedDelayTimeData
implements Serializable {
    public int MaxBranch;
    public double[] BranchMaxOffset = new double[20];
    public double[] BranchMinOffset = new double[20];
    public String SandboxPath;
    public IProgressMonitor Messenger;
    public Action_TableDataV2 Shot;
    public Action_TableDataV2 Receiver;
    public TraceTable_Huge SharedTraceTable;
    public int IndexKilled;
    public int IndexBranchUser;
    public int IndexBranchComputed;
    public int IndexMidX;
    public int IndexMidY;
    public int IndexOffset;
    public int IndexAzimuth;
    public int IndexShotRow;
    public int IndexRecRow;
    public int[] IndexTravelTime = new int[10];
    public int IndexTraceTableIndex;
    public int IndexUserPick;
    public Grid3D Grid;

    protected void prepareTablesAndArrays() throws Exception {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.Shot = new Action_TableDataV2(project.shotTable(), project.shotMap(), this.MaxBranch);
            this.Receiver = new Action_TableDataV2(project.receiverTable(), project.receiverMap(), this.MaxBranch);
            if (project.units_feet()) {
                this.Receiver.RadiusSquared = 10000.0;
                this.Shot.RadiusSquared = 10000.0;
            } else {
                this.Receiver.RadiusSquared = 1600.0;
                this.Shot.RadiusSquared = 1600.0;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Grid3D_Conversion grid = project.getGrid3D_Conversion().clone();
            double binSize = project.delayTimeData().getAnalysisGridBinSize();
            grid.setBinSize(binSize, binSize);
            grid.prepareRangeFinder();
            Tools_RefractionStaticsProject.gridRange3D(grid);
            this.Grid = new Grid3D(grid);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void ensureNoBias(boolean applyShift) {
        try {
            for (int branch = 1; branch <= this.MaxBranch; ++branch) {
                double shotAverage = this.Shot.computeAverageDelayTime(branch);
                double recAverage = this.Receiver.computeAverageDelayTime(branch);
                double shift = (shotAverage - recAverage) / 2.0;
                System.out.println("Delay time bias = " + shift);
                if (!applyShift) continue;
                this.Shot.shiftDelayTimes(branch, -shift);
                this.Receiver.shiftDelayTimes(branch, shift);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void finalizeDelayTimeData(boolean ComputingShearWaveDelayTimes) throws Exception {
        try {
            boolean modVel;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            DelayTimeData dtd = project.delayTimeData();
            if (!ComputingShearWaveDelayTimes) {
                this.Shot.updateTables(ComputingShearWaveDelayTimes);
            }
            this.Receiver.updateTables(ComputingShearWaveDelayTimes);
            boolean modDT = dtd.forceIncreasingDelayTimes();
            if (modDT) {
                this.Shot.Modified_DelayTime = true;
                this.Receiver.Modified_DelayTime = true;
            }
            if (modVel = dtd.forceIncreasingVelocities()) {
                this.Shot.Modified_Velocity = true;
                this.Receiver.Modified_Velocity = true;
            }
            if (ComputingShearWaveDelayTimes) {
                Tools_RefractionStaticsProject t = new Tools_RefractionStaticsProject();
                for (int b = 1; b <= this.MaxBranch; ++b) {
                    t.interpolateFromTableToTable(this.Receiver.Table, this.Shot.Table, Pecos.getConvWave_DT(b));
                }
            }
            this.Shot.updateDatabase(dtd.WeatherVelocityModified, ComputingShearWaveDelayTimes);
            this.Receiver.updateDatabase(dtd.WeatherVelocityModified, ComputingShearWaveDelayTimes);
            project.reloadAllData();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void smooth(double radius, double[] x1, double[] y1, double[] v1, double[] x2, double[] y2, double[] v2) throws Exception {
        try {
            int n;
            int n2;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Grid3D grid = project.getEmptyGrid3D(0.1 * radius, 0.1 * radius, 0.1 * radius);
            grid.interp_Prep();
            grid.interp_ZeroArrays();
            if (x1 == null && x2 == null) {
                return;
            }
            if (x1 != null) {
                for (n2 = 0; n2 < x1.length; ++n2) {
                    grid.interp_Add(x1[n2], y1[n2], (float)v1[n2], 0.0f);
                }
            }
            if (x2 != null) {
                for (n2 = 0; n2 < x2.length; ++n2) {
                    grid.interp_Add(x2[n2], y2[n2], (float)v2[n2], 0.0f);
                }
            }
            int smoothRad = 10;
            grid.interp_Finish(smoothRad);
            if (x1 != null) {
                for (n = 0; n < x1.length; ++n) {
                    v1[n] = grid.getNearestValue(x1[n], y1[n]);
                }
            }
            if (x2 != null) {
                for (n = 0; n < x2.length; ++n) {
                    v2[n] = grid.getNearestValue(x2[n], y2[n]);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void createSharedDelayTimeData(String sandboxPath, boolean completeTraceTable) {
        try {
            int b;
            this.SandboxPath = sandboxPath;
            this.Messenger.setPercentDone(0.0);
            this.Messenger.setDescription("Creating shared trace table");
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            project.reloadAllData();
            DelayTimeData dtd = project.delayTimeData();
            dtd.forceIncreasingDelayTimes();
            dtd.forceIncreasingVelocities();
            this.MaxBranch = dtd.branchAssignment().maxBranch();
            this.prepareTablesAndArrays();
            for (b = 0; b < this.BranchMinOffset.length; ++b) {
                this.BranchMinOffset[b] = Double.MAX_VALUE;
                this.BranchMaxOffset[b] = Double.MIN_VALUE;
            }
            for (b = 0; b < this.IndexTravelTime.length; ++b) {
                this.IndexTravelTime[b] = -9999;
            }
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            Table_Memory tempTable = new Table_Memory();
            this.IndexKilled = ((Table_Abstract)tempTable).column_append("Killed", DataType.Int);
            this.IndexBranchUser = ((Table_Abstract)tempTable).column_append("Branch_DelayTime", DataType.Int);
            this.IndexBranchComputed = ((Table_Abstract)tempTable).column_append("Branch_Computed", DataType.Int);
            this.IndexMidX = ((Table_Abstract)tempTable).column_append("CdpX", DataType.Int);
            this.IndexMidY = ((Table_Abstract)tempTable).column_append("CdpY", DataType.Int);
            this.IndexShotRow = ((Table_Abstract)tempTable).column_append("ShotRow", DataType.Int);
            this.IndexRecRow = ((Table_Abstract)tempTable).column_append("RecRow", DataType.Int);
            this.IndexTraceTableIndex = ((Table_Abstract)tempTable).column_append("TraceTableIndex", DataType.Int);
            this.IndexUserPick = ((Table_Abstract)tempTable).column_append("FBP_User", DataType.Float);
            for (int b2 = 1; b2 <= this.MaxBranch; ++b2) {
                String ttname = "tt" + Integer.toString(b2);
                this.IndexTravelTime[b2] = ((Table_Abstract)tempTable).column_append(ttname, DataType.Float);
            }
            this.IndexOffset = ((Table_Abstract)tempTable).column_append("Offset", DataType.Float);
            this.IndexAzimuth = ((Table_Abstract)tempTable).column_append("Azimuth", DataType.Float);
            String tempTraceTablePath = Tools_FileSystem.confirmSubDirectoryExists(this.SandboxPath, "Trace");
            this.SharedTraceTable = new TraceTable_Huge(tempTraceTablePath, "Trace", tempTable, 4);
            BranchAssignment ba = project.getDelayTimeData().branchAssignment();
            int traceKilledIndex = -9999;
            if (traceTable.column_exists("Killed")) {
                traceKilledIndex = traceTable.column_indexOfColumn("Killed");
            }
            int indexPick = -9999;
            if (traceTable.column_exists("FBP_User")) {
                indexPick = traceTable.column_indexOfColumn("FBP_User");
            }
            int indexTraceShotID = traceTable.column_indexOfColumn("ShotID");
            int indexTraceRecID = traceTable.column_indexOfColumn("ReceiverID");
            int badID = 0;
            for (long row = 0L; row < traceTable.rowCount(); ++row) {
                boolean indexOK;
                int shotID = traceTable.getInt(row, indexTraceShotID);
                int recID = traceTable.getInt(row, indexTraceRecID);
                boolean bl = indexOK = this.Shot.Map.containsKey(shotID) && this.Receiver.Map.containsKey(recID);
                if (!indexOK) {
                    ++badID;
                }
                if (!indexOK) continue;
                int shotRow = this.Shot.Map.get(shotID);
                int recRow = this.Receiver.Map.get(recID);
                boolean shotKilled = !this.Shot.Alive[shotRow];
                boolean recKilled = !this.Receiver.Alive[recRow];
                boolean traceKilled = false;
                if (traceKilledIndex >= 0) {
                    traceKilled = traceTable.getInt(row, traceKilledIndex) != 0;
                }
                int killed = 0;
                if (shotKilled) {
                    ++killed;
                }
                if (recKilled) {
                    ++killed;
                }
                if (traceKilled) {
                    ++killed;
                }
                double rx = this.Receiver.X[recRow];
                double ry = this.Receiver.Y[recRow];
                double sx = this.Shot.X[shotRow];
                double sy = this.Shot.Y[shotRow];
                double mx = 0.5 * (rx + sx);
                double my = 0.5 * (ry + sy);
                double dx = rx - sx;
                double dy = ry - sy;
                double off = Math.sqrt(dx * dx + dy * dy + 1.0E-20);
                double az = 0.0;
                if (off > 1.0E-5) {
                    az = Math.atan2(dy, dx);
                }
                int branch = ba.getBranch(mx, my, off);
                boolean branchOkay = false;
                if (branch >= 1 && branch < this.BranchMinOffset.length) {
                    branchOkay = true;
                    this.BranchMinOffset[branch] = Math.min(this.BranchMinOffset[branch], off);
                    this.BranchMaxOffset[branch] = Math.max(this.BranchMaxOffset[branch], off);
                }
                boolean pickOkay = true;
                if (indexPick >= 0) {
                    float pick = traceTable.getInt(row, indexPick);
                    boolean bl2 = pickOkay = pick > -200.0f;
                }
                if (!completeTraceTable && (!branchOkay || !pickOkay)) continue;
                int r = ((Table_Abstract)tempTable).row_increment();
                ((Table_Abstract)tempTable).putLong(r, this.IndexTraceTableIndex, row);
                ((Table_Abstract)tempTable).putInt(r, this.IndexKilled, killed);
                ((Table_Abstract)tempTable).putInt(r, this.IndexBranchUser, branch);
                ((Table_Abstract)tempTable).putFloat(r, this.IndexUserPick, -9999.0f);
                if (indexPick >= 0) {
                    ((Table_Abstract)tempTable).putFloat(r, this.IndexUserPick, traceTable.getFloat(row, indexPick));
                }
                ((Table_Abstract)tempTable).putFloat(r, this.IndexOffset, (float)off);
                ((Table_Abstract)tempTable).putFloat(r, this.IndexAzimuth, (float)az);
                ((Table_Abstract)tempTable).putInt(r, this.IndexShotRow, shotRow);
                ((Table_Abstract)tempTable).putInt(r, this.IndexRecRow, recRow);
                ((Table_Abstract)tempTable).putInt(r, this.IndexMidX, (int)mx);
                ((Table_Abstract)tempTable).putInt(r, this.IndexMidY, (int)my);
                if (((Table_Abstract)tempTable).row_count() <= 50000) continue;
                this.SharedTraceTable.appendTable(tempTable);
                ((Table_Abstract)tempTable).row_clear(false);
                double percent = 100.0 * (double)row / (double)traceTable.rowCount();
                this.Messenger.setPercentDone(percent);
            }
            System.out.println("badID = " + badID);
            if (((Table_Abstract)tempTable).row_count() > 0) {
                this.SharedTraceTable.appendTable(tempTable);
                ((Table_Abstract)tempTable).row_clear(false);
            }
            this.SharedTraceTable.finishedAppending(null);
            this.SharedTraceTable = null;
            this.SharedTraceTable = new TraceTable_Huge(tempTraceTablePath, "Trace");
            this.IndexKilled = this.SharedTraceTable.column_indexOfColumn("Killed");
            this.IndexBranchUser = this.SharedTraceTable.column_indexOfColumn("Branch_DelayTime");
            this.IndexBranchComputed = this.SharedTraceTable.column_indexOfColumn("Branch_Computed");
            this.IndexMidX = this.SharedTraceTable.column_indexOfColumn("CdpX");
            this.IndexMidY = this.SharedTraceTable.column_indexOfColumn("CdpY");
            this.IndexShotRow = this.SharedTraceTable.column_indexOfColumn("ShotRow");
            this.IndexRecRow = this.SharedTraceTable.column_indexOfColumn("RecRow");
            for (int b3 = 1; b3 <= this.MaxBranch; ++b3) {
                String ttname = "tt" + Integer.toString(b3);
                this.IndexTravelTime[b3] = this.SharedTraceTable.column_indexOfColumn(ttname);
            }
            this.IndexOffset = this.SharedTraceTable.column_indexOfColumn("Offset");
            this.IndexAzimuth = this.SharedTraceTable.column_indexOfColumn("Azimuth");
            this.Messenger.setPercentDone(0.0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

