/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.Padding;
import javax.crypto.BadPaddingException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class PKCS5Padding
extends Padding {
    public static final String ALGORITHM_NAME = "PKCS5Padding";

    public PKCS5Padding(int n2) throws NoSuchPaddingException {
        super(ALGORITHM_NAME, n2);
        if (n2 < 1 || n2 > 255) {
            throw new NoSuchPaddingException("Invalid block size");
        }
    }

    public int pad(byte[] byArray, int n2, int n3) throws ShortBufferException {
        int n4 = this.a - n3 % this.a;
        if (byArray.length - (n2 += n3) < n4) {
            throw new ShortBufferException("Output buffer too small");
        }
        byte by = (byte)n4;
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray[n2 + i2] = by;
        }
        return n4;
    }

    public int unpad(byte[] byArray, int n2, int n3) throws BadPaddingException, ShortBufferException {
        if (n3 == 0) {
            return 0;
        }
        int n4 = byArray[n2 + n3 - 1] & 0xFF;
        if (n4 < 1 || n4 > this.a) {
            throw new BadPaddingException("Invalid pad size");
        }
        if (n3 < n4) {
            throw new ShortBufferException("Output buffer too small");
        }
        byte by = (byte)n4;
        for (int i2 = n2 + n3 - n4; i2 < n2 + n3; ++i2) {
            if (byArray[i2] == by) continue;
            throw new BadPaddingException("Invalid pad data");
        }
        return n4;
    }
}

