/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GridLayoutWidget
extends JPanel {
    protected int m_insets = 2;
    protected GridBagLayout m_layout = new GridBagLayout();

    public GridLayoutWidget(int insets, String borderLabel) {
        try {
            this.m_insets = Math.max(0, insets);
            if (borderLabel != null) {
                this.setBorder(BorderFactory.createTitledBorder(borderLabel));
            } else {
                this.setBorder(BorderFactory.createRaisedBevelBorder());
            }
            this.setLayout(this.m_layout);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public GridLayoutWidget(int insets) {
        try {
            this.m_insets = Math.max(0, insets);
            this.setLayout(this.m_layout);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public JLabel createLabel(String lbl, int row, int col) throws Exception {
        try {
            return this.createLabel(lbl, row, col, 0.0, 0.0, 1, 1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public JLabel createLabel(String lbl, int row, int col, double rowWeight, double colWeight, int rowSpan, int colSpan) throws Exception {
        try {
            JLabel w = new JLabel(lbl);
            this.addComponent(w, row, col, rowWeight, colWeight, rowSpan, colSpan);
            return w;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public JLabel createLabel(String lbl, int row, int col, int sizeChange, int position) throws Exception {
        try {
            JLabel w = new JLabel(lbl, position);
            this.addComponent(w, row, col, 0.0, 0.0, 1, 1);
            return w;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public JTextField createTextField(String lbl, int row, int col, double rowWeight, double colWeight, int rowSpan, int colSpan) throws Exception {
        try {
            JTextField w = new JTextField(lbl);
            this.addComponent(w, row, col, rowWeight, colWeight, rowSpan, colSpan);
            return w;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public JButton createButton(String lbl, ActionListener listener, int row, int col) throws Exception {
        try {
            JButton w = new JButton(lbl);
            if (listener != null) {
                w.addActionListener(listener);
            }
            this.addComponent(w, row, col);
            return w;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void addComponent(Component child, int row, int col) throws Exception {
        try {
            this.addComponent(child, row, col, 0.0, 0.0, 1, 1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void addSimple(int row, Component c1, Component c2) {
        try {
            this.addComponent(c1, row, 0, 0.0, 0.0);
            this.addComponent(c2, row, 1, 0.0, 9.0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addSimple(int row, Component c1, Component c2, Component c3) {
        try {
            this.addComponent(c1, row, 0, 0.0, 0.0);
            this.addComponent(c2, row, 1, 0.0, 9.0);
            this.addComponent(c3, row, 2, 0.0, 9.0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addSimple(int row, Component c1, Component c2, Component c3, int stretch1, int stretch2, int stretch3) {
        try {
            this.addComponent(c1, row, 0, 0.0, stretch1);
            this.addComponent(c2, row, 1, 0.0, stretch2);
            this.addComponent(c3, row, 2, 0.0, stretch3);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addSimple(int row, Component c1, Component c2, Component c3, Component c4) {
        try {
            this.addComponent(c1, row, 0, 0.0, 9.0);
            this.addComponent(c2, row, 1, 0.0, 9.0);
            this.addComponent(c3, row, 2, 0.0, 9.0);
            this.addComponent(c4, row, 3, 0.0, 9.0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addSimple(int row, Component c1, Component c2, Component c3, Component c4, Component c5) {
        try {
            this.addComponent(c1, row, 0, 0.0, 9.0);
            this.addComponent(c2, row, 1, 0.0, 9.0);
            this.addComponent(c3, row, 2, 0.0, 9.0);
            this.addComponent(c4, row, 3, 0.0, 9.0);
            this.addComponent(c5, row, 4, 0.0, 9.0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addSimple(int row, Component c1, Component c2, Component c3, Component c4, int stretch1, int stretch2, int stretch3, int stretch4) {
        try {
            this.addComponent(c1, row, 0, 0.0, stretch1);
            this.addComponent(c2, row, 1, 0.0, stretch2);
            this.addComponent(c3, row, 2, 0.0, stretch3);
            this.addComponent(c4, row, 3, 0.0, stretch4);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addSimple(int row, Component c1, Component c2, Component c3, Component c4, Component c5, int stretch1, int stretch2, int stretch3, int stretch4, int stretch5) {
        try {
            this.addComponent(c1, row, 0, 0.0, stretch1);
            this.addComponent(c2, row, 1, 0.0, stretch2);
            this.addComponent(c3, row, 2, 0.0, stretch3);
            this.addComponent(c4, row, 3, 0.0, stretch4);
            this.addComponent(c5, row, 4, 0.0, stretch5);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addSimple(int row, Component c1, Component c2, Component c3, Component c4, Component c5, Component c6) {
        try {
            this.addComponent(c1, row, 0, 0.0, 9.0);
            this.addComponent(c2, row, 1, 0.0, 9.0);
            this.addComponent(c3, row, 2, 0.0, 9.0);
            this.addComponent(c4, row, 3, 0.0, 9.0);
            this.addComponent(c5, row, 4, 0.0, 9.0);
            this.addComponent(c6, row, 5, 0.0, 9.0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addSimple(int row, Component c1, Component c2, Component c3, Component c4, Component c5, Component c6, int stretch1, int stretch2, int stretch3, int stretch4, int stretch5, int stretch6) {
        try {
            this.addComponent(c1, row, 0, 0.0, stretch1);
            this.addComponent(c2, row, 1, 0.0, stretch2);
            this.addComponent(c3, row, 2, 0.0, stretch3);
            this.addComponent(c4, row, 3, 0.0, stretch4);
            this.addComponent(c5, row, 4, 0.0, stretch5);
            this.addComponent(c6, row, 5, 0.0, stretch6);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addComponent(Component child, int row, int col, double rowWeight, double colWeight) throws Exception {
        try {
            this.addComponent(child, row, col, rowWeight, colWeight, 1, 1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void addComponent(Component child, int row, int col, double rowWeight, double colWeight, int rowSpan, int colSpan) throws Exception {
        try {
            GridBagConstraints gbcon = new GridBagConstraints();
            gbcon.gridx = col;
            gbcon.gridy = row;
            gbcon.weightx = Math.max(colWeight, 0.0);
            gbcon.weighty = Math.max(rowWeight, 0.0);
            gbcon.anchor = 10;
            gbcon.fill = 1;
            gbcon.gridheight = Math.max(rowSpan, 1);
            gbcon.gridwidth = Math.max(colSpan, 1);
            int inset = Math.max(this.m_insets, 0);
            gbcon.insets = new Insets(inset, inset, inset, inset);
            this.m_layout.setConstraints(child, gbcon);
            this.add(child);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }
}

