/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JComboBox;

public class ComboStringListWrapper
extends JComboBox<String>
implements ItemListener {
    protected String m_selected = "";
    protected boolean m_ignore = true;
    protected GenericObjectListener m_listener = new GenericObjectListener();

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public ComboStringListWrapper(String selected) {
        try {
            this.m_selected = selected;
            this.addItemListener(this);
            this.setEditable(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public ComboStringListWrapper() {
        try {
            this.addItemListener(this);
            this.setEditable(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public String getSelectedString() throws Exception {
        try {
            if (this.getItemCount() < 1) {
                return this.m_selected;
            }
            this.m_selected = (String)this.getSelectedItem();
            return this.m_selected;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void setPreferredSelected(String pref) {
        try {
            if (this.getItemCount() < 1) {
                this.m_selected = pref;
                return;
            }
            this.m_ignore = true;
            for (int n = 0; n < this.getItemCount(); ++n) {
                String s = (String)this.getItemAt(n);
                if (!s.equalsIgnoreCase(pref)) continue;
                this.setSelectedIndex(n);
                this.m_selected = pref;
                this.m_ignore = false;
                return;
            }
            this.m_ignore = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setStringArray(ArrayList<String> list) {
        try {
            this.m_ignore = true;
            this.removeAllItems();
            if (list == null) {
                return;
            }
            if (list.size() < 1) {
                return;
            }
            int selIndex = -1;
            for (int n = 0; n < list.size(); ++n) {
                String s = list.get(n);
                if (s.equalsIgnoreCase(this.m_selected)) {
                    selIndex = n;
                }
                this.addItem(s);
            }
            if (selIndex >= 0) {
                this.setSelectedIndex(selIndex);
            } else {
                this.setSelectedIndex(0);
            }
            this.m_selected = (String)this.getSelectedItem();
            this.m_ignore = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (this.m_ignore) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.getItemCount() < 1) {
                return;
            }
            System.out.println("ComboStringListWrapper  itemStateChanged(ItemEvent e)");
            this.m_selected = (String)this.getSelectedItem();
            this.m_listener.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

