/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Windows.Parameter;

import com.PecosCore.Data.DataType;
import com.PecosCore.Shared.ExceptionMonitor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class TextFieldBase
extends JTextField
implements ActionListener,
DocumentListener {
    protected ArrayList<WeakReference<Listener>> m_listeners = new ArrayList();
    protected boolean m_ok = false;
    protected String m_badnessReason = "";
    protected boolean m_ignoreDoc = false;
    protected DataType m_type;

    public void clearListeners() {
        this.m_listeners.clear();
    }

    public void addListener(Listener listener) {
        try {
            if (listener != null) {
                this.m_listeners.add(new WeakReference<Listener>(listener));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void broadcastModified() {
        try {
            for (WeakReference<Listener> wr : this.m_listeners) {
                Listener listener = (Listener)wr.get();
                if (listener == null) continue;
                listener.handleTextFieldModified(this, this.m_ok);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void broadcastEnterPressed() {
        try {
            for (WeakReference<Listener> wr : this.m_listeners) {
                Listener listener = (Listener)wr.get();
                if (listener == null) continue;
                listener.handleTextFieldEnter(this, this.m_ok);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public TextFieldBase(DataType type) {
        try {
            this.addActionListener(this);
            this.getDocument().addDocumentListener(this);
            this.m_type = type;
            if (this.m_type == DataType.Float) {
                this.m_type = DataType.Double;
            }
            if (this.m_type == DataType.Short) {
                this.m_type = DataType.Int;
            }
            boolean bl = type == DataType.Double || type == DataType.Int || type == DataType.Text || type == DataType.Long;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean ok() {
        return this.m_ok;
    }

    public String badnessReason() {
        if (this.m_badnessReason == null) {
            this.m_badnessReason = "";
        }
        return this.m_badnessReason;
    }

    public abstract boolean checkText();

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.checkText();
            if (!this.m_ok) {
                return;
            }
            this.broadcastEnterPressed();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            if (this.m_ignoreDoc) {
                return;
            }
            this.checkText();
            this.broadcastModified();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            if (this.m_ignoreDoc) {
                return;
            }
            this.checkText();
            this.broadcastModified();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            if (this.m_ignoreDoc) {
                return;
            }
            this.checkText();
            this.broadcastModified();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static interface Listener {
        public void handleTextFieldEnter(TextFieldBase var1, boolean var2);

        public void handleTextFieldModified(TextFieldBase var1, boolean var2);
    }
}

