/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Windows.Parameter;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Parameter.ParameterTreeModelNodeType;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class ParameterTreeModelNode
extends DefaultMutableTreeNode {
    public ParameterTreeModelNodeType NodeType;
    public final String ParameterDescription;
    public final String ParameterName;
    public final boolean Required;
    public final DataType Datatype;
    public final List<String> Options;
    String _sParameterHelp = "help message";
    String _sParameterError = "error message";
    String _sValue = "0";
    String _sDefaultValue = "0";
    boolean _bActivated;
    String _sDeactivatedText = "NOT_USED";

    public ParameterTreeModelNode(ParameterTree parameterTree, ParameterTreeModelNodeType nodeType, String sName, String sDescription, DataType dt, boolean bRequired, boolean bActivated, String sValue, String sDeactivatedText) {
        this.NodeType = nodeType;
        this.ParameterDescription = sDescription;
        this.ParameterName = sName;
        this.Datatype = dt;
        this.Required = bRequired;
        this._sDefaultValue = this._sValue = sValue;
        this.Options = null;
        this._bActivated = bActivated;
        this._sDeactivatedText = sDeactivatedText;
        this.initializeFromParameterTree(parameterTree);
    }

    public ParameterTreeModelNode(ParameterTree parameterTree, ParameterTreeModelNodeType nodeType, String sName, String sDescription, DataType dt, boolean bRequired, boolean bActivated, String sValue) {
        this.NodeType = nodeType;
        this.ParameterDescription = sDescription;
        this.ParameterName = sName;
        this.Datatype = dt;
        this.Required = bRequired;
        this._sDefaultValue = this._sValue = sValue;
        this.Options = null;
        this._bActivated = bActivated;
        this.initializeFromParameterTree(parameterTree);
    }

    public ParameterTreeModelNode(ParameterTree parameterTree, ParameterTreeModelNodeType nodeType, String sName, String sDescription, DataType dt, boolean bRequired, boolean bActivated, List<String> options, String sValue) {
        this.NodeType = nodeType;
        this.ParameterDescription = sDescription;
        this.ParameterName = sName;
        this.Datatype = dt;
        this.Required = bRequired;
        this._sDefaultValue = this._sValue = sValue;
        this.Options = options;
        this._bActivated = bActivated;
        this.initializeFromParameterTree(parameterTree);
    }

    void initializeFromParameterTree(ParameterTree parameterTree) {
        try {
            String sEnabledName = this.ParameterName + "_Activated";
            if (parameterTree.bool_exists(sEnabledName)) {
                this._bActivated = parameterTree.bool_get(sEnabledName);
            } else {
                parameterTree.bool_put(sEnabledName, this._bActivated);
            }
            if (this.Datatype == DataType.Bool) {
                if (parameterTree.bool_exists(this.ParameterName)) {
                    boolean bVal = parameterTree.bool_get(this.ParameterName);
                    this._sValue = Boolean.toString(bVal);
                } else {
                    boolean bVal = Boolean.parseBoolean(this._sValue);
                    parameterTree.bool_put(this.ParameterName, bVal);
                }
            } else if (this.Datatype == DataType.Double) {
                if (parameterTree.double_exists(this.ParameterName)) {
                    double dVal = parameterTree.double_get(this.ParameterName);
                    this._sValue = Double.toString(dVal);
                } else {
                    double dVal = Double.parseDouble(this._sValue);
                    parameterTree.double_put(this.ParameterName, dVal);
                }
            } else if (this.Datatype == DataType.Int) {
                if (parameterTree.int_exists(this.ParameterName)) {
                    int iVal = parameterTree.int_get(this.ParameterName);
                    this._sValue = Integer.toString(iVal);
                } else {
                    int iVal = Integer.parseInt(this._sValue);
                    parameterTree.int_put(this.ParameterName, iVal);
                }
            } else if (this.Datatype == DataType.Long) {
                if (parameterTree.long_exists(this.ParameterName)) {
                    long lVal = parameterTree.long_get(this.ParameterName);
                    this._sValue = Long.toString(lVal);
                } else {
                    int iVal = Integer.parseInt(this._sValue);
                    parameterTree.int_put(this.ParameterName, iVal);
                }
            } else if (this.Datatype == DataType.Text) {
                if (parameterTree.string_exists(this.ParameterName)) {
                    this._sValue = parameterTree.string_get(this.ParameterName);
                } else {
                    parameterTree.string_put(this.ParameterName, this._sValue);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static boolean getIsParameterActive(String sParameterName, ParameterTree parameterTree) throws Exception {
        try {
            boolean bActive = true;
            String sEnabledName = sParameterName + "_Activated";
            if (parameterTree.bool_exists(sEnabledName)) {
                bActive = parameterTree.bool_get(sEnabledName);
            }
            return bActive;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public boolean getIsParameterActive(ParameterTree parameterTree) throws Exception {
        try {
            boolean bActive = true;
            String sEnabledName = this.ParameterName + "_Activated";
            if (parameterTree.bool_exists(sEnabledName)) {
                bActive = parameterTree.bool_get(sEnabledName);
            }
            return bActive;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void writeToParameterTree(ParameterTree parameterTree) {
        try {
            String sEnabledName = this.ParameterName + "_Activated";
            parameterTree.bool_put(sEnabledName, this._bActivated);
            if (this._sValue.equals(this.getDeactivatedText())) {
                return;
            }
            if (this.Datatype == DataType.Bool) {
                boolean bVal = Boolean.parseBoolean(this._sValue);
                parameterTree.bool_put(this.ParameterName, bVal);
            } else if (this.Datatype == DataType.Double) {
                double dVal = Double.parseDouble(this._sValue);
                parameterTree.double_put(this.ParameterName, dVal);
            } else if (this.Datatype == DataType.Int) {
                double dVal = Double.parseDouble(this._sValue);
                int iVal = (int)dVal;
                parameterTree.int_put(this.ParameterName, iVal);
            } else if (this.Datatype == DataType.Long) {
                double dVal = Double.parseDouble(this._sValue);
                long lVal = (long)dVal;
                parameterTree.long_put(this.ParameterName, lVal);
            } else if (this.Datatype == DataType.Text) {
                parameterTree.string_put(this.ParameterName, this._sValue);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public String getStringValue() {
        return this._sValue;
    }

    public void setStringValue(String sVal) {
        this._sValue = sVal;
    }

    public String getDefaultValue() {
        return this._sDefaultValue;
    }

    public void setDefaultValue(String sVal) {
        this._sDefaultValue = sVal;
    }

    public boolean getActivated() {
        return this._bActivated;
    }

    public void setActivated(boolean bActivated) {
        this._bActivated = bActivated;
    }

    public String getDeactivatedText() {
        return this._sDeactivatedText;
    }

    public String getHelpMessage() {
        return this._sParameterHelp;
    }

    public void setHelpMessage(String sHelp) {
        this._sParameterHelp = sHelp;
    }

    public String getErrorMessage() {
        return this._sParameterError;
    }

    public void setErrorMessage(String sHelp) {
        this._sParameterError = sHelp;
    }
}

