/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Tools;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Shared.ExceptionMonitor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;

public class Tools_FileSystem {
    public static void saveAscii(String fileName, ArrayList<String> arr) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            for (String s : arr) {
                writer.write(s);
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static ArrayList<String> readAscii(String fileName) {
        try {
            ArrayList<String> arr = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            while (line != null) {
                arr.add(line);
                line = br.readLine();
            }
            return arr;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return new ArrayList<String>();
        }
    }

    public static boolean[][] readArray_Bool2D(String fileName, int defNumX, int defNumY) throws Exception {
        try {
            if (!Tools_FileSystem.exists_file(fileName)) {
                return new boolean[defNumX][defNumY];
            }
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            boolean[][] arr = Tools_FileSystem.readArray_Bool2D(file);
            file.close();
            return arr;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static float[][] readArray_Float2D(String fileName, int defNumX, int defNumY) throws Exception {
        try {
            if (!Tools_FileSystem.exists_file(fileName)) {
                return new float[defNumX][defNumY];
            }
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            float[][] arr = Tools_FileSystem.readArray_Float2D(file);
            file.close();
            return arr;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void saveArray_Double3D(RandomAccessFile file, double[][][] array) throws Exception {
        try {
            int magic = 0x5EEEEF;
            int version = 1000;
            int d1 = array.length;
            int d2 = array[0].length;
            int d3 = array[0][0].length;
            int num = d1 * d2 * d3;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * num);
            int off = 0;
            for (int n = 0; n < d1; ++n) {
                for (int m = 0; m < d2; ++m) {
                    for (int k = 0; k < d3; ++k) {
                        buff.putFloat(off, (float)array[n][m][k]);
                        off += 4;
                    }
                }
            }
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(d1);
                file.writeInt(d2);
                file.writeInt(d3);
                file.write(buff.array(), 0, 4 * num);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static double[][][] readArray_Double3D(RandomAccessFile file) throws Exception {
        try {
            int magic = file.readInt();
            if (magic != 0x5EEEEF) {
                throw new Exception("magic != 6221551");
            }
            int version = file.readInt();
            if (version == 1000) {
                int d1 = file.readInt();
                int d2 = file.readInt();
                int d3 = file.readInt();
                double[][][] array = new double[d1][d2][d3];
                int num = d1 * d2 * d3;
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * num);
                file.read(buff.array(), 0, 4 * num);
                int off = 0;
                for (int n = 0; n < d1; ++n) {
                    for (int m = 0; m < d2; ++m) {
                        for (int k = 0; k < d3; ++k) {
                            array[n][m][k] = buff.getFloat(off);
                            off += 4;
                        }
                    }
                }
                return array;
            }
            throw new Exception("Bad version");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void saveArray_Float3D(RandomAccessFile file, float[][][] array) throws Exception {
        try {
            int magic = 0x5EEEEF;
            int version = 1000;
            int d1 = array.length;
            int d2 = array[0].length;
            int d3 = array[0][0].length;
            int num = d1 * d2 * d3;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * num);
            int off = 0;
            for (int n = 0; n < d1; ++n) {
                for (int m = 0; m < d2; ++m) {
                    for (int k = 0; k < d3; ++k) {
                        buff.putFloat(off, array[n][m][k]);
                        off += 4;
                    }
                }
            }
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(d1);
                file.writeInt(d2);
                file.writeInt(d3);
                file.write(buff.array(), 0, 4 * num);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static float[][][] readArray_Float3D(RandomAccessFile file) throws Exception {
        try {
            int magic = file.readInt();
            if (magic != 0x5EEEEF) {
                throw new Exception("magic != 6221551");
            }
            int version = file.readInt();
            if (version == 1000) {
                int d1 = file.readInt();
                int d2 = file.readInt();
                int d3 = file.readInt();
                float[][][] array = new float[d1][d2][d3];
                int num = d1 * d2 * d3;
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * num);
                file.read(buff.array(), 0, 4 * num);
                int off = 0;
                for (int n = 0; n < d1; ++n) {
                    for (int m = 0; m < d2; ++m) {
                        for (int k = 0; k < d3; ++k) {
                            array[n][m][k] = buff.getFloat(off);
                            off += 4;
                        }
                    }
                }
                return array;
            }
            throw new Exception("Bad version");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static float[][] readArray_Float2D(RandomAccessFile file) throws Exception {
        try {
            int magic = file.readInt();
            if (magic != 6001551) {
                throw new Exception("magic != 6001551");
            }
            int version = file.readInt();
            if (version == 1000) {
                int d1 = file.readInt();
                int d2 = file.readInt();
                float[][] array = new float[d1][d2];
                int num = d1 * d2;
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * num);
                file.read(buff.array(), 0, 4 * num);
                int off = 0;
                for (int n = 0; n < d1; ++n) {
                    for (int m = 0; m < d2; ++m) {
                        array[n][m] = buff.getFloat(off);
                        off += 4;
                    }
                }
                return array;
            }
            throw new Exception("Bad version");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static boolean[][] readArray_Bool2D(RandomAccessFile file) throws Exception {
        try {
            int magic = file.readInt();
            if (magic != 4567876) {
                throw new Exception("magic != 4567876");
            }
            int version = file.readInt();
            if (version == 1000) {
                int d1 = file.readInt();
                int d2 = file.readInt();
                boolean[][] array = new boolean[d1][d2];
                int num = d1 * d2;
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, num);
                file.read(buff.array(), 0, num);
                int off = 0;
                for (int n = 0; n < d1; ++n) {
                    for (int m = 0; m < d2; ++m) {
                        array[n][m] = buff.get(off) != 0;
                        ++off;
                    }
                }
                return array;
            }
            throw new Exception("Bad version");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void saveArray_Int(RandomAccessFile file, int[] array, int count) throws Exception {
        try {
            int magic = 9007333;
            int version = 1000;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * count);
            int off = 0;
            for (int n = 0; n < count; ++n) {
                buff.putInt(off, array[n]);
                off += 4;
            }
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(count);
                file.write(buff.array(), 0, 4 * count);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static int[] readArray_Int(RandomAccessFile file) throws Exception {
        try {
            int magic = file.readInt();
            if (magic != 9007333) {
                throw new Exception("magic != 9007333");
            }
            int version = file.readInt();
            if (version == 1000) {
                int count = file.readInt();
                int[] array = new int[count];
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * count);
                file.read(buff.array(), 0, 4 * count);
                int off = 0;
                for (int n = 0; n < count; ++n) {
                    array[n] = buff.getInt(off);
                    off += 4;
                }
                return array;
            }
            throw new Exception("Bad version");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void saveArray_Float(String fileName, float[] array) throws Exception {
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            Tools_FileSystem.saveArray_Float(file, array, array.length);
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void saveArray_Float(RandomAccessFile file, float[] array, int count) throws Exception {
        try {
            int magic = 4545227;
            int version = 1000;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * count);
            int off = 0;
            for (int n = 0; n < count; ++n) {
                buff.putFloat(off, array[n]);
                off += 4;
            }
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(count);
                file.write(buff.array(), 0, 4 * count);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static float[] readArray_Float(String fileName) throws Exception {
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            float[] arr = Tools_FileSystem.readArray_Float(file);
            file.close();
            return arr;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static float[] readArray_Float(RandomAccessFile file) throws Exception {
        try {
            int magic = file.readInt();
            if (magic != 4545227) {
                throw new Exception("magic != 4545227");
            }
            int version = file.readInt();
            if (version == 1000) {
                int count = file.readInt();
                float[] array = new float[count];
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * count);
                file.read(buff.array(), 0, 4 * count);
                int off = 0;
                for (int n = 0; n < count; ++n) {
                    array[n] = buff.getFloat(off);
                    off += 4;
                }
                return array;
            }
            throw new Exception("Bad version");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void saveArray_Long(RandomAccessFile file, long[] array, int count) throws Exception {
        try {
            int magic = 43534534;
            int version = 1000;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, 8 * count);
            int off = 0;
            for (int n = 0; n < count; ++n) {
                buff.putLong(off, array[n]);
                off += 8;
            }
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(count);
                file.write(buff.array(), 0, 8 * count);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static long[] readArray_Long(RandomAccessFile file) throws Exception {
        try {
            int magic = file.readInt();
            if (magic != 43534534) {
                throw new Exception("magic != 43534534");
            }
            int version = file.readInt();
            if (version == 1000) {
                int count = file.readInt();
                long[] array = new long[count];
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, 8 * count);
                file.read(buff.array(), 0, 8 * count);
                int off = 0;
                for (int n = 0; n < count; ++n) {
                    array[n] = buff.getLong(off);
                    off += 8;
                }
                return array;
            }
            throw new Exception("Bad version");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void saveArray_Double(RandomAccessFile file, double[] array, int count) throws Exception {
        try {
            int magic = 78934289;
            int version = 1000;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, 8 * count);
            int off = 0;
            for (int n = 0; n < count; ++n) {
                buff.putDouble(off, array[n]);
                off += 8;
            }
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(count);
                file.write(buff.array(), 0, 8 * count);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static double[] readArray_Double(RandomAccessFile file) throws Exception {
        try {
            int magic = file.readInt();
            if (magic != 78934289) {
                throw new Exception("magic != 78934289");
            }
            int version = file.readInt();
            if (version == 1000) {
                int count = file.readInt();
                double[] array = new double[count];
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, 8 * count);
                file.read(buff.array(), 0, 8 * count);
                int off = 0;
                for (int n = 0; n < count; ++n) {
                    array[n] = buff.getDouble(off);
                    off += 8;
                }
                return array;
            }
            throw new Exception("Bad version");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static double[][] readArray_Double2D(RandomAccessFile file) throws Exception {
        try {
            int magic = file.readInt();
            if (magic != 33331551) {
                throw new Exception("magic != 33331551");
            }
            int version = file.readInt();
            if (version == 1000) {
                int d1 = file.readInt();
                int d2 = file.readInt();
                double[][] array = new double[d1][d2];
                int num = d1 * d2;
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, 8 * num);
                file.read(buff.array(), 0, 8 * num);
                int off = 0;
                for (int n = 0; n < d1; ++n) {
                    for (int m = 0; m < d2; ++m) {
                        array[n][m] = buff.getDouble(off);
                        off += 8;
                    }
                }
                return array;
            }
            throw new Exception("Bad version");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void saveArray_Double2D(RandomAccessFile file, double[][] array) throws Exception {
        try {
            int magic = 33331551;
            int version = 1000;
            int d1 = array.length;
            int d2 = array[0].length;
            int num = d1 * d2;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, 8 * num);
            int off = 0;
            for (int n = 0; n < d1; ++n) {
                for (int m = 0; m < d2; ++m) {
                    buff.putDouble(off, array[n][m]);
                    off += 8;
                }
            }
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(d1);
                file.writeInt(d2);
                file.write(buff.array(), 0, 8 * num);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void saveArray_Bool2D(String fileName, boolean[][] array) throws Exception {
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            Tools_FileSystem.saveArray_Bool2D(file, array);
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void saveArray_Bool2D(RandomAccessFile file, boolean[][] array) throws Exception {
        try {
            int magic = 4567876;
            int version = 1000;
            int d1 = array.length;
            int d2 = array[0].length;
            int num = d1 * d2;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, num);
            int off = 0;
            for (int n = 0; n < d1; ++n) {
                for (int m = 0; m < d2; ++m) {
                    if (array[n][m]) {
                        buff.put(off, (byte)1);
                    } else {
                        buff.put(off, (byte)0);
                    }
                    ++off;
                }
            }
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(d1);
                file.writeInt(d2);
                file.write(buff.array(), 0, num);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void saveArray_Float2D(String fileName, float[][] array) throws Exception {
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            Tools_FileSystem.saveArray_Float2D(file, array);
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void saveArray_Float2D(RandomAccessFile file, float[][] array) throws Exception {
        try {
            int magic = 6001551;
            int version = 1000;
            int d1 = array.length;
            int d2 = array[0].length;
            int num = d1 * d2;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * num);
            int off = 0;
            for (int n = 0; n < d1; ++n) {
                for (int m = 0; m < d2; ++m) {
                    buff.putFloat(off, array[n][m]);
                    off += 4;
                }
            }
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(d1);
                file.writeInt(d2);
                file.write(buff.array(), 0, 4 * num);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static int[][] readArray_Int2D(RandomAccessFile file) throws Exception {
        try {
            int magic = file.readInt();
            if (magic != 4437823) {
                throw new Exception("magic != 4437823");
            }
            int version = file.readInt();
            if (version == 1000) {
                int d1 = file.readInt();
                int d2 = file.readInt();
                int[][] array = new int[d1][d2];
                int num = d1 * d2;
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * num);
                file.read(buff.array(), 0, 4 * num);
                int off = 0;
                for (int n = 0; n < d1; ++n) {
                    for (int m = 0; m < d2; ++m) {
                        array[n][m] = buff.getInt(off);
                        off += 4;
                    }
                }
                return array;
            }
            throw new Exception("Bad version");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void saveArray_Int2D(RandomAccessFile file, int[][] array) throws Exception {
        try {
            int magic = 4437823;
            int version = 1000;
            int d1 = array.length;
            int d2 = array[0].length;
            int num = d1 * d2;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * num);
            int off = 0;
            for (int n = 0; n < d1; ++n) {
                for (int m = 0; m < d2; ++m) {
                    buff.putInt(off, array[n][m]);
                    off += 4;
                }
            }
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(d1);
                file.writeInt(d2);
                file.write(buff.array(), 0, 4 * num);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static long[][] readArray_Long2D(RandomAccessFile file) throws Exception {
        try {
            int magic = file.readInt();
            if (magic != 86565865) {
                throw new Exception("magic != 86565865");
            }
            int version = file.readInt();
            if (version == 1000) {
                int d1 = file.readInt();
                int d2 = file.readInt();
                long[][] array = new long[d1][d2];
                int num = d1 * d2;
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, 8 * num);
                file.read(buff.array(), 0, 8 * num);
                int off = 0;
                for (int n = 0; n < d1; ++n) {
                    for (int m = 0; m < d2; ++m) {
                        array[n][m] = buff.getLong(off);
                        off += 8;
                    }
                }
                return array;
            }
            throw new Exception("Bad version");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void saveArray_Long2D(RandomAccessFile file, long[][] array) throws Exception {
        try {
            int magic = 86565865;
            int version = 1000;
            int d1 = array.length;
            int d2 = array[0].length;
            int num = d1 * d2;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, 8 * num);
            int off = 0;
            for (int n = 0; n < d1; ++n) {
                for (int m = 0; m < d2; ++m) {
                    buff.putLong(off, array[n][m]);
                    off += 8;
                }
            }
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(d1);
                file.writeInt(d2);
                file.write(buff.array(), 0, 8 * num);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static String convertToUnixFileName(String fileName) {
        return fileName.replaceAll("\\\\+", "/");
    }

    public static void copyDirectoryRecursive(String fromFullPath, String toFullPath) throws Exception {
        try {
            if (!Tools_FileSystem.exists_path(fromFullPath)) {
                throw new Exception("source path invalid");
            }
            if (!Tools_FileSystem.exists_path(toFullPath)) {
                File f = new File(toFullPath);
                f.mkdirs();
            }
            if (!Tools_FileSystem.exists_path(toFullPath)) {
                throw new Exception("target path invalid");
            }
            ArrayList<String> fromFileList = Tools_FileSystem.files(fromFullPath, false, true);
            for (String fileName : fromFileList) {
                String s1 = fromFullPath + "/" + fileName;
                String s2 = toFullPath + "/" + fileName;
                Tools_FileSystem.copyFile(s1, s2);
            }
            ArrayList<String> fromPathList = Tools_FileSystem.subdirectories(fromFullPath, false);
            for (String pathName : fromPathList) {
                Tools_FileSystem.copyDirectoryRecursive(fromFullPath + "/" + pathName, toFullPath + "/" + pathName);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void copySubdirectory(String fromPath, String toPath, String subdirName) {
        try {
            String fromFullPath = fromPath + "/" + subdirName;
            String toFullPath = Tools_FileSystem.confirmSubDirectoryExists(toPath, subdirName);
            ArrayList<String> fromFileList = Tools_FileSystem.files(fromFullPath, false, true);
            for (String fileName : fromFileList) {
                String s1 = fromFullPath + "/" + fileName;
                String s2 = toFullPath + "/" + fileName;
                Tools_FileSystem.copyFile(s1, s2);
            }
            ArrayList<String> fromPathList = Tools_FileSystem.subdirectories(fromFullPath, false);
            for (String pathName : fromPathList) {
                Tools_FileSystem.copySubdirectory(fromFullPath, toFullPath, pathName);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static String confirmSubDirectoryExists(String parentDirectory, String subDirName) throws Exception {
        try {
            if (parentDirectory == null || subDirName == null) {
                throw new Exception("path names invalid");
            }
            if (parentDirectory.length() < 2 || subDirName.length() < 1) {
                throw new Exception("path names not long enough");
            }
            String path = parentDirectory + "/" + subDirName;
            if (Tools_FileSystem.exists_path(path)) {
                return path;
            }
            File f = new File(path);
            if (f.mkdirs()) {
                return path;
            }
            throw new Exception("Failed to create sub directory");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public static String getObjectName(String fullPath) {
        try {
            File f = new File(fullPath);
            return f.getName();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return fullPath;
        }
    }

    public static ArrayList<String> subdirectories(String path, boolean fullPath) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            File f = new File(path);
            if (!f.exists()) {
                return list;
            }
            if (!f.isDirectory()) {
                return list;
            }
            File[] files = f.listFiles();
            if (files == null) {
                return list;
            }
            for (File temp : files) {
                if (!temp.isDirectory()) continue;
                if (fullPath) {
                    list.add(temp.getAbsolutePath());
                    continue;
                }
                list.add(temp.getName());
            }
            Collections.sort(list);
            return list;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return new ArrayList<String>();
        }
    }

    public static ArrayList<String> files(String path, boolean fullPath, boolean okToStartWithPeriod) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            File f = new File(path);
            if (!f.exists()) {
                return list;
            }
            if (!f.isDirectory()) {
                return list;
            }
            File[] files = f.listFiles();
            if (files == null) {
                return list;
            }
            for (File temp : files) {
                boolean periodOK;
                String name = temp.getName();
                boolean startsWithPeriod = name.startsWith(".");
                boolean bl = periodOK = okToStartWithPeriod || !startsWithPeriod;
                if (!periodOK || !temp.isFile()) continue;
                if (fullPath) {
                    list.add(temp.getAbsolutePath());
                    continue;
                }
                list.add(temp.getName());
            }
            return list;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return new ArrayList<String>();
        }
    }

    public static ArrayList<String> files(String path, boolean fullPath) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            File f = new File(path);
            if (!f.exists()) {
                return list;
            }
            if (!f.isDirectory()) {
                return list;
            }
            File[] files = f.listFiles();
            if (files == null) {
                return list;
            }
            for (File temp : files) {
                if (!temp.isFile()) continue;
                if (fullPath) {
                    list.add(temp.getAbsolutePath());
                    continue;
                }
                list.add(temp.getName());
            }
            return list;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return new ArrayList<String>();
        }
    }

    public static ArrayList<String> files(String path, String suffix, boolean fullPath) {
        try {
            return Tools_FileSystem.files(path, suffix, fullPath, false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return new ArrayList<String>();
        }
    }

    public static ArrayList<String> files(String path, String suffix, boolean fullPath, boolean removeSuffix) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            File f = new File(path);
            if (!f.exists()) {
                return list;
            }
            if (!f.isDirectory()) {
                return list;
            }
            File[] files = f.listFiles();
            if (files == null) {
                return list;
            }
            for (File temp : files) {
                if (!temp.isFile() || !temp.getName().endsWith(suffix)) continue;
                if (fullPath) {
                    list.add(temp.getAbsolutePath());
                    continue;
                }
                String name = temp.getName();
                if (removeSuffix) {
                    int index = name.lastIndexOf(suffix);
                    name = name.substring(0, index);
                }
                list.add(name);
            }
            return list;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return new ArrayList<String>();
        }
    }

    public static String findFile(String fileName, String path, boolean recursive) {
        try {
            ArrayList<String> files = Tools_FileSystem.files(path, false, true);
            for (String s : files) {
                if (!s.equalsIgnoreCase(fileName)) continue;
                return path + "/" + s;
            }
            if (recursive) {
                ArrayList<String> subPaths = Tools_FileSystem.subdirectories(path, true);
                for (String subPath : subPaths) {
                    String subFile = Tools_FileSystem.findFile(fileName, subPath, true);
                    if (subFile == null || subFile.length() <= 2) continue;
                    return subFile;
                }
            }
            return "";
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "";
        }
    }

    public static String getOwningPath(String fileName) {
        try {
            if (Tools_FileSystem.exists_path(fileName)) {
                return fileName;
            }
            if (!Tools_FileSystem.exists_file(fileName)) {
                return "";
            }
            File file = new File(fileName);
            File parent = file.getParentFile();
            if (parent == null) {
                return "";
            }
            return parent.getAbsolutePath();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    public static String parentPath(String path) {
        try {
            if (!Tools_FileSystem.exists_path(path)) {
                return null;
            }
            File f = new File(path);
            File p = f.getParentFile();
            if (p == null) {
                return null;
            }
            return p.getAbsolutePath();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static boolean exists_path(String path) {
        try {
            if (path == null) {
                return false;
            }
            File f = new File(path);
            return f.exists() && f.isDirectory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public static boolean exists_file(String fileName) {
        try {
            if (fileName == null) {
                return false;
            }
            File f = new File(fileName);
            return f.exists() && f.isFile();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public static long length(String fileName) {
        try {
            if (fileName == null) {
                return 0L;
            }
            File f = new File(fileName);
            if (f.exists() && f.isFile()) {
                return f.length();
            }
            return 0L;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0L;
        }
    }

    public static void deleteFile(String fileName) throws Exception {
        try {
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            File f = new File(fileName);
            f.delete();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static boolean deletePath(File path) throws Exception {
        try {
            boolean subDeleted = true;
            if (path.exists()) {
                File[] files = path.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    subDeleted = files[i].isDirectory() ? subDeleted && Tools_FileSystem.deletePath(files[i]) : subDeleted && files[i].delete();
                }
            }
            boolean deleted = path.delete();
            return deleted;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void deletePathIfExists(String path) throws Exception {
        try {
            if (path == null) {
                return;
            }
            Tools_FileSystem.deletePath(new File(path));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTempFileFromResource(String file) {
        int BUFFER_SIZE = 5120;
        File tFile = null;
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("resources/" + file);
            tFile = File.createTempFile(file.substring(0, file.lastIndexOf(".") - 1), file.substring(file.lastIndexOf("."), file.length()));
            tFile.deleteOnExit();
            FileOutputStream out = new FileOutputStream(tFile);
            try {
                byte[] buffer = new byte[5120];
                int n = 0;
                while ((n = in.read(buffer, 0, 5120)) != -1) {
                    ((OutputStream)out).write(buffer, 0, n);
                }
                out.flush();
            }
            finally {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException ex) {
                    ExceptionMonitor.add(ex);
                }
                try {
                    in.close();
                }
                catch (IOException ex) {
                    ExceptionMonitor.add(ex);
                }
            }
        }
        catch (IOException ex) {
            ExceptionMonitor.add(ex);
        }
        return tFile;
    }

    public static void copyFile(String from, String to) throws Exception {
        try {
            if (!Tools_FileSystem.exists_file(from)) {
                return;
            }
            Path source = Paths.get(from, new String[0]);
            Path target = Paths.get(to, new String[0]);
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

