/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import java.io.Serializable;

public class Range_Double
implements Serializable {
    protected boolean m_rangeValid = false;
    protected double m_rangeMin = 0.0;
    protected double m_rangeMax = 0.0;

    public void print(String prefix) {
        try {
            Object s = "";
            s = this.m_rangeValid ? String.format("%s:  %f --> %f", prefix, Float.valueOf((float)this.m_rangeMin), Float.valueOf((float)this.m_rangeMax)) : prefix + ": range not valid";
            System.out.println((String)s);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setRange(Range_Double r) {
        try {
            if (r.rangeValid()) {
                this.m_rangeValid = true;
                this.m_rangeMin = r.rangeMin();
                this.m_rangeMax = r.rangeMax();
            } else {
                this.m_rangeValid = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean insideRange(double v) {
        if (!this.m_rangeValid) {
            return false;
        }
        return v >= this.m_rangeMin && v <= this.m_rangeMax;
    }

    public void clearRange() {
        this.m_rangeValid = false;
    }

    public boolean rangeValid() {
        return this.m_rangeValid;
    }

    public double range() throws Exception {
        if (!this.m_rangeValid) {
            throw new Exception("Range not valid");
        }
        return this.m_rangeMax - this.m_rangeMin;
    }

    public double rangeMin() throws Exception {
        if (!this.m_rangeValid) {
            throw new Exception("Range not valid");
        }
        return this.m_rangeMin;
    }

    public double rangeMax() throws Exception {
        if (!this.m_rangeValid) {
            throw new Exception("Range not valid");
        }
        return this.m_rangeMax;
    }

    public double rangeCenter() throws Exception {
        if (!this.m_rangeValid) {
            throw new Exception("Range not valid");
        }
        return 0.5 * (this.m_rangeMax + this.m_rangeMin);
    }

    public void addPercentBuffer(double percent) {
        try {
            if (!this.m_rangeValid) {
                return;
            }
            double diff = 0.005 * percent * (this.m_rangeMax - this.m_rangeMin);
            diff = Math.max(diff, 0.1);
            this.m_rangeMax += diff;
            this.m_rangeMin -= diff;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void expandRange(Range_Double r) {
        try {
            if (r == null) {
                return;
            }
            if (!r.rangeValid()) {
                return;
            }
            this.expandRange(r.rangeMax());
            this.expandRange(r.rangeMin());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void expandRange(float[] v, int maxSample) {
        try {
            if (v == null) {
                return;
            }
            if (v.length < 1) {
                return;
            }
            int num = Math.min(v.length, maxSample);
            for (int n = 0; n < num; ++n) {
                this.expandRange(v[n]);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void expandRange(double[] v) {
        try {
            if (v == null) {
                return;
            }
            if (v.length < 1) {
                return;
            }
            this.expandRange(v[0]);
            for (int n = 0; n < v.length; ++n) {
                this.m_rangeMin = Math.min(this.m_rangeMin, v[n]);
                this.m_rangeMax = Math.max(this.m_rangeMax, v[n]);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void expandRange(double v) {
        if (this.m_rangeValid) {
            this.m_rangeMin = Math.min(this.m_rangeMin, v);
            this.m_rangeMax = Math.max(this.m_rangeMax, v);
        } else {
            this.m_rangeMin = v;
            this.m_rangeMax = v;
            this.m_rangeValid = true;
        }
    }
}

