/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Shared;

import com.PecosCore.Shared.ChangeLog_Flatirons;
import com.PecosCore.Shared.ExceptionMonitorEntry;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.IExceptionMonitorRedirect;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class ExceptionMonitor
extends AbstractTableModel {
    protected GenericObjectListener m_listenerController = new GenericObjectListener();
    protected int m_errorCount = 0;
    protected ArrayList<ExceptionMonitorEntry> m_list = new ArrayList();
    protected int m_maxListSize = 200;
    protected boolean Verbose = true;
    protected IExceptionMonitorRedirect m_redirect = null;
    protected static ExceptionMonitor m_singleton = null;
    String _sPathOverride = "";

    public GenericObjectListener getListenerController() {
        return this.m_listenerController;
    }

    public void setIExceptionMonitorRedirect(IExceptionMonitorRedirect redirect) {
        this.m_redirect = redirect;
    }

    protected ExceptionMonitor() {
    }

    public void clear() {
        try {
            this.m_list.clear();
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int size() {
        return this.m_list.size();
    }

    public ExceptionMonitorEntry getEntry(int index) {
        try {
            if (index < 0 || index >= this.m_list.size()) {
                return null;
            }
            return this.m_list.get(index);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public int getErrorCount() {
        return this.m_errorCount;
    }

    protected void addError(Exception err) {
        try {
            if (this.m_redirect != null) {
                this.m_redirect.addException(err);
                return;
            }
            if (err == null) {
                return;
            }
            ++this.m_errorCount;
            this.m_list.add(0, new ExceptionMonitorEntry(err));
            if (this.Verbose) {
                err.printStackTrace();
            }
            while (this.m_list.size() > this.m_maxListSize) {
                this.m_list.remove(this.m_list.size() - 1);
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void add(Exception error) {
        try {
            ExceptionMonitor.instance().addError(error);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static ExceptionMonitor instance() {
        try {
            if (m_singleton == null) {
                m_singleton = new ExceptionMonitor();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setPath(String sPath) {
        this._sPathOverride = sPath;
    }

    public String saveCurrentState() {
        try {
            if (this.m_list.size() < 1) {
                JOptionPane.showMessageDialog(null, "No exceptions", "No exceptions to be saved", 1);
                return "No exceptions to be saved";
            }
            Calendar c = Calendar.getInstance();
            int year = c.get(1);
            int month = c.get(2) + 1;
            int day = c.get(5);
            String root = String.format("%d_%d_%d_Version", year, month, day);
            String dir = SharedApplicationData.singleton().homeSubDirectory("ExceptionFiles");
            int version = 1;
            Object fileName = dir + "/" + root + Integer.toString(version) + ".txt";
            while (Tools_FileSystem.exists_file((String)fileName)) {
                fileName = dir + "/" + root + Integer.toString(++version) + ".txt";
            }
            if (this._sPathOverride.length() > 1) {
                fileName = this._sPathOverride;
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter((String)fileName));
            String sep = "################################################################################";
            bufferedWriter.write("Flatirons\u2122 " + ChangeLog_Flatirons.singleton().currentVersion());
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("Most recent exception shown first");
            bufferedWriter.newLine();
            for (ExceptionMonitorEntry entry : this.m_list) {
                bufferedWriter.newLine();
                bufferedWriter.write(sep);
                bufferedWriter.newLine();
                bufferedWriter.write("Exception    " + entry.Error.getMessage());
                bufferedWriter.newLine();
                bufferedWriter.write("Time         " + entry.TimeAdded);
                bufferedWriter.newLine();
                bufferedWriter.write("Stack information:");
                bufferedWriter.newLine();
                StackTraceElement[] array = entry.getStackTraceArray();
                for (int n = 0; n < array.length; ++n) {
                    String s = String.format("  %30s%80s%8d%30s", array[n].getFileName(), array[n].getClassName(), array[n].getLineNumber(), array[n].getMethodName());
                    bufferedWriter.write(s);
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            this.m_listenerController.broadcast(this, (Object)Message.Saved);
            return "Saved in file: " + (String)fileName;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    @Override
    public int getRowCount() {
        return this.m_list.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            if (row < 0 || row >= this.m_list.size()) {
                return "";
            }
            if (column < 0 || column >= 2) {
                return "";
            }
            ExceptionMonitorEntry b = this.m_list.get(row);
            if (column == 0) {
                return b.Error.getLocalizedMessage();
            }
            if (column == 1) {
                return b.TimeAdded;
            }
            return "";
        }
        catch (Exception error) {
            error.printStackTrace();
            return "";
        }
    }

    @Override
    public String getColumnName(int column) {
        try {
            if (column == 0) {
                return "Error description";
            }
            if (column == 1) {
                return "Time";
            }
            return "bad column";
        }
        catch (Exception error) {
            error.printStackTrace();
            return "getColumnName exception";
        }
    }

    public static enum Message {
        ExceptionAdded,
        Saved;

    }
}

