/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Seismic.Segy;

import com.PecosCore.Seismic.Segy.Segy_SampleFormat;
import com.PecosCore.Shared.ExceptionMonitor;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.table.AbstractTableModel;

public class Segy_FileHeader
extends AbstractTableModel {
    public ByteBuffer HeaderBuffer = ByteBuffer.allocate(400);
    public ByteOrder FileByteOrder = ByteOrder.LITTLE_ENDIAN;
    public int BytesPerSample = 0;
    public int BytesPerTrace = 0;
    public Segy_SampleFormat SampleFormat = Segy_SampleFormat.INVALID;
    public int SamplesPerTrace = 0;
    public float SampleInterval = 4.0f;

    public void insertHeaderBytes(byte[] headerBytes) {
        try {
            this.SampleFormat = Segy_SampleFormat.INVALID;
            if (headerBytes == null) {
                return;
            }
            if (headerBytes.length != 400) {
                return;
            }
            ((Buffer)this.HeaderBuffer).rewind();
            this.HeaderBuffer.put(headerBytes);
            this.FileByteOrder = ByteOrder.LITTLE_ENDIAN;
            this.HeaderBuffer.order(this.FileByteOrder);
            int formatCode = this.getValue(Entry.FormatCode);
            this.SampleFormat = Segy_SampleFormat.getFormat(formatCode);
            if (this.SampleFormat == Segy_SampleFormat.INVALID) {
                this.FileByteOrder = ByteOrder.BIG_ENDIAN;
                this.HeaderBuffer.order(this.FileByteOrder);
                formatCode = this.getValue(Entry.FormatCode);
                this.SampleFormat = Segy_SampleFormat.getFormat(formatCode);
            }
            if (this.SampleFormat == Segy_SampleFormat.INVALID) {
                System.out.println("cannot figure out header format");
                return;
            }
            this.SamplesPerTrace = this.getValue(Entry.SamplesPerTrace);
            this.BytesPerSample = this.SampleFormat.BytesPerSample;
            this.BytesPerTrace = 240 + this.BytesPerSample * this.SamplesPerTrace;
            this.SampleInterval = 0.001f * (float)this.getValue(Entry.SampleIntervalMicro);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void hackSPT() {
        try {
            this.SamplesPerTrace = this.HeaderBuffer.getInt(Entry.SamplesPerTrace.ByteOffset);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean valid() {
        return this.SampleFormat != Segy_SampleFormat.INVALID;
    }

    public int getValue(Entry e) {
        try {
            if (e.ByteCount == 2) {
                return this.HeaderBuffer.getShort(e.ByteOffset);
            }
            return this.HeaderBuffer.getInt(e.ByteOffset);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -999999;
        }
    }

    @Override
    public String getColumnName(int column) {
        try {
            if (column == 0) {
                return "Header";
            }
            if (column == 1) {
                return "Value";
            }
            if (column == 2) {
                return "Bytes";
            }
            return "Error";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    @Override
    public int getRowCount() {
        return Entry.values().length;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            if (column == 0) {
                return Entry.values()[row];
            }
            if (column == 1) {
                int val = this.getValue(Entry.values()[row]);
                return Integer.toString(val);
            }
            if (column == 2) {
                int o1 = 1 + Entry.values()[row].ByteOffset;
                int o2 = Entry.values()[row].ByteCount + Entry.values()[row].ByteOffset;
                return Integer.toString(o1) + " - " + Integer.toString(o2);
            }
            return "Error";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    public static enum Entry {
        JobID(0, 4),
        LineNumber(4, 4),
        ReelNumber(8, 4),
        EnsembleTraceCount(12, 2),
        EnsembleTraceCountAuxiliary(14, 2),
        SampleIntervalMicro(16, 2),
        SampleIntervalMicroOriginal(18, 2),
        SamplesPerTrace(20, 2),
        SamplesPerTraceOriginal(22, 2),
        FormatCode(24, 2),
        TracesPerEnsembleExpected(26, 2),
        SortingCode(28, 2),
        SweepType(38, 2),
        Units(54, 2),
        CorrelatedTraces(48, 2),
        AmplitudeRecoveryMethod(52, 2),
        ImpulseSignalPolarity(56, 2);

        public final int ByteOffset;
        public final int ByteCount;

        private Entry(int off, int count) {
            this.ByteOffset = off;
            this.ByteCount = count;
        }
    }
}

