/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Seismic.Segy;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Seismic.ISeismicFile;
import com.PecosCore.Seismic.ImportLimit;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Seismic.Segy.Segy_FileHeader;
import com.PecosCore.Seismic.Segy.Segy_SampleFormat;
import com.PecosCore.Seismic.SeismicFileType;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_ByteArray;
import com.PecosCore.Tools.Tools_FileSystem;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class Segy
implements ISeismicFile {
    protected String m_fileName = null;
    protected String m_reasonObjectNotValid = "File name not set";
    protected long m_fileByteCount;
    protected byte[] m_ebcdicByteArray = new byte[3200];
    protected byte[] m_fileHeaderByteArray = new byte[400];
    protected Segy_FileHeader m_header = new Segy_FileHeader();
    protected byte[] m_traceHeaderByteArray = new byte[240];
    protected ByteBuffer m_traceHeaderByteBuffer = ByteBuffer.allocate(240);
    protected byte[] m_traceDataByteArray = null;
    protected float[] m_traceDataArray = null;
    public boolean CaptureRawHeaderBytes = false;
    protected long m_traceCount = 0L;
    public long ReadTime = 0L;
    protected Segy_Dictionary m_segyDictionary = null;
    protected GenericObjectListener m_listenerManager = new GenericObjectListener();
    protected RandomAccessFile m_pecosRAF = null;
    public ArrayList<ImportLimit> ImportLimitList = new ArrayList();
    protected ByteBuffer m_bufferSequentialRead = null;
    public ByteBuffer TempSequentialBuffer;
    public int TempBuffLen = 0;
    public int TempTraceCount;

    public String reasonObjectNotValid() {
        return this.m_reasonObjectNotValid;
    }

    public long fileByteCount() {
        return this.m_fileByteCount;
    }

    @Override
    public GenericObjectListener getListenerController() {
        return this.m_listenerManager;
    }

    public void changeSampleInterval(int microseconds) {
        try {
            if (!this.isFileOK()) {
                return;
            }
            RandomAccessFile raf = new RandomAccessFile(this.m_fileName, "rw");
            ByteBuffer headerBuffer = ByteBuffer.allocate(3600);
            raf.read(headerBuffer.array(), 0, 3600);
            headerBuffer.order(this.m_header.FileByteOrder);
            headerBuffer.putShort(3216, (short)microseconds);
            raf.seek(0L);
            raf.write(headerBuffer.array(), 0, 3600);
            raf.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void outputWindowedCompression(String outputFileName, int maxSamples) {
        try {
            if (!this.isFileOK()) {
                return;
            }
            float digi = this.m_header.SampleInterval;
            int numTracesPerChunk = 1000;
            maxSamples = Math.max(maxSamples, 10);
            maxSamples = Math.min(maxSamples, this.samplesPerTrace());
            byte[] inputByteArray = null;
            if (this.m_header.SampleFormat == Segy_SampleFormat.IBM) {
                inputByteArray = new byte[4 * maxSamples];
            }
            if (this.m_header.SampleFormat == Segy_SampleFormat.IEEE) {
                inputByteArray = new byte[4 * maxSamples];
            }
            if (this.m_header.SampleFormat == Segy_SampleFormat.Short) {
                inputByteArray = new byte[2 * maxSamples];
            }
            float[] inputFloatArray = new float[maxSamples];
            int bytesPerInputTrace = this.bytesPerTrace();
            int numBytesInInputChunk = numTracesPerChunk * bytesPerInputTrace;
            ByteBuffer headerBuffer = ByteBuffer.allocate(3600);
            ByteBuffer inputBuffer = ByteBuffer_Shared.buffer(0, numBytesInInputChunk);
            int samplesPerWindow = 10;
            int windowsPerTrace = maxSamples / samplesPerWindow;
            int bytesPerWindow = 4 + samplesPerWindow;
            int bytesPerOutputTrace = 4 + bytesPerWindow * windowsPerTrace;
            int samplesPerTrace = windowsPerTrace * samplesPerWindow;
            int numBytesInOutputChunk = numTracesPerChunk * bytesPerOutputTrace;
            ByteBuffer outputHeaderBuffer = ByteBuffer.allocate(100);
            int magic = 420024;
            int version = 1000;
            outputHeaderBuffer.putInt(0, magic);
            outputHeaderBuffer.putInt(4, version);
            outputHeaderBuffer.putFloat(8, digi);
            outputHeaderBuffer.putInt(12, samplesPerWindow);
            outputHeaderBuffer.putInt(16, windowsPerTrace);
            ByteBuffer outputBuffer = ByteBuffer_Shared.buffer(1, numBytesInOutputChunk);
            RandomAccessFile writer = new RandomAccessFile(outputFileName, "rw");
            RandomAccessFile reader = new RandomAccessFile(this.m_fileName, "r");
            reader.read(headerBuffer.array(), 0, 3600);
            headerBuffer.order(this.m_header.FileByteOrder);
            writer.write(outputHeaderBuffer.array(), 0, 100);
            int startIndex = 0;
            while ((long)startIndex < this.traceCount()) {
                int numTraces = numTracesPerChunk;
                int lastIndex = startIndex + numTraces - 1;
                if ((long)lastIndex >= this.traceCount()) {
                    lastIndex = (int)this.traceCount() - 1;
                }
                numTraces = lastIndex - startIndex + 1;
                reader.read(inputBuffer.array(), 0, numTraces * bytesPerInputTrace);
                byte[] input = inputBuffer.array();
                byte[] output = outputBuffer.array();
                int outputIndex = 0;
                int inputIndex = 0;
                for (int n = 0; n < numTraces; ++n) {
                    for (int k = 0; k < inputByteArray.length; ++k) {
                        inputByteArray[k] = input[inputIndex + 240 + k];
                    }
                    if (this.m_header.SampleFormat == Segy_SampleFormat.IBM) {
                        Tools_ByteArray.populateFloatUsingIBM(inputByteArray, inputFloatArray);
                    } else if (this.m_header.SampleFormat == Segy_SampleFormat.IEEE) {
                        Tools_ByteArray.populateFloatUsingIEEE(this.m_header.FileByteOrder, inputByteArray, inputFloatArray);
                    } else if (this.m_header.SampleFormat == Segy_SampleFormat.Short) {
                        Tools_ByteArray.populateFloatUsingShort(this.m_header.FileByteOrder, inputByteArray, inputFloatArray);
                    }
                    outputIndex = n * bytesPerOutputTrace;
                    outputBuffer.putFloat(outputIndex, 0.0f);
                    outputIndex += 4;
                    for (int w = 0; w < windowsPerTrace; ++w) {
                        float max = 1.0E-20f;
                        for (int s = 0; s < samplesPerWindow; ++s) {
                            float inputSample = inputFloatArray[s + w * samplesPerWindow];
                            max = Math.max(max, Math.abs(inputSample));
                        }
                        float scalar = 125.0f / max;
                        outputBuffer.putFloat(outputIndex, scalar);
                        outputIndex += 4;
                        for (int s = 0; s < samplesPerWindow; ++s) {
                            float inputSample = inputFloatArray[s + w * samplesPerWindow];
                            output[outputIndex++] = (byte)(scalar * inputSample);
                        }
                    }
                    inputIndex += bytesPerInputTrace;
                }
                writer.write(outputBuffer.array(), 0, numTraces * bytesPerOutputTrace);
                System.out.println("startIndex = " + (startIndex += numTraces));
            }
            reader.close();
            writer.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void outputHeaderFilteredVersion(String outputFileName, int header, int min, int max) {
        try {
            if (!this.isFileOK()) {
                return;
            }
            int samples = this.samplesPerTrace();
            int numTracesPerChunk = 1000;
            int bytesPerTrace = this.bytesPerTrace();
            int numBytesInChunk = numTracesPerChunk * bytesPerTrace;
            RandomAccessFile writer = new RandomAccessFile(outputFileName, "rw");
            RandomAccessFile reader = new RandomAccessFile(this.m_fileName, "r");
            ByteBuffer headerBuffer = ByteBuffer.allocate(3600);
            ByteBuffer inputBuffer = ByteBuffer_Shared.buffer(0, numBytesInChunk);
            ByteBuffer outputBuffer = ByteBuffer_Shared.buffer(1, numBytesInChunk);
            reader.read(headerBuffer.array(), 0, 3600);
            writer.write(headerBuffer.array(), 0, 3600);
            inputBuffer.order(this.m_header.FileByteOrder);
            int startIndex = 0;
            while ((long)startIndex < this.traceCount()) {
                int numTraces = numTracesPerChunk;
                int lastIndex = startIndex + numTraces - 1;
                if ((long)lastIndex >= this.traceCount()) {
                    lastIndex = (int)this.traceCount() - 1;
                }
                numTraces = lastIndex - startIndex + 1;
                reader.read(inputBuffer.array(), 0, numTraces * bytesPerTrace);
                byte[] input = inputBuffer.array();
                byte[] output = outputBuffer.array();
                int outputCount = 0;
                for (int n = 0; n < numTraces; ++n) {
                    int headerOffset = n * bytesPerTrace + header;
                    int headerValue = inputBuffer.getInt(headerOffset);
                    if (headerValue < min || headerValue > max) continue;
                    int inputIndex = n * bytesPerTrace;
                    int outputIndex = outputCount * bytesPerTrace;
                    for (int k = 0; k < bytesPerTrace; ++k) {
                        output[outputIndex + k] = input[inputIndex + k];
                    }
                    ++outputCount;
                }
                if (outputCount >= 1) {
                    writer.write(outputBuffer.array(), 0, outputCount * bytesPerTrace);
                }
                System.out.println("startIndex = " + (startIndex += numTraces));
            }
            reader.close();
            writer.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void outputCompressedVersion(String outputFileName, int maxSamples) {
        try {
            if (!this.isFileOK()) {
                return;
            }
            float digi = this.m_header.SampleInterval;
            if (Math.abs(2.0f - digi) < 0.01f) {
                this.outputCompressedVersion_SubSample(outputFileName, maxSamples);
                return;
            }
            maxSamples = Math.max(maxSamples, 10);
            maxSamples = Math.min(maxSamples, this.samplesPerTrace());
            int numTracesPerChunk = 1000;
            byte[] inputByteArray = null;
            if (this.m_header.SampleFormat == Segy_SampleFormat.IBM) {
                inputByteArray = new byte[4 * maxSamples];
            }
            if (this.m_header.SampleFormat == Segy_SampleFormat.IEEE) {
                inputByteArray = new byte[4 * maxSamples];
            }
            if (this.m_header.SampleFormat == Segy_SampleFormat.Short) {
                inputByteArray = new byte[2 * maxSamples];
            }
            float[] inputFloatArray = new float[maxSamples];
            int bytesPerOutputTrace = 240 + 2 * maxSamples;
            int bytesPerInputTrace = this.bytesPerTrace();
            int numBytesInOutputChunk = numTracesPerChunk * bytesPerOutputTrace;
            int numBytesInInputChunk = numTracesPerChunk * bytesPerInputTrace;
            RandomAccessFile writer = new RandomAccessFile(outputFileName, "rw");
            RandomAccessFile reader = new RandomAccessFile(this.m_fileName, "r");
            ByteBuffer headerBuffer = ByteBuffer.allocate(3600);
            ByteBuffer inputBuffer = ByteBuffer_Shared.buffer(0, numBytesInInputChunk);
            ByteBuffer outputBuffer = ByteBuffer_Shared.buffer(1, numBytesInOutputChunk);
            reader.read(headerBuffer.array(), 0, 3600);
            headerBuffer.order(this.m_header.FileByteOrder);
            outputBuffer.order(this.m_header.FileByteOrder);
            headerBuffer.putShort(3224, (short)3);
            headerBuffer.putShort(3220, (short)maxSamples);
            writer.write(headerBuffer.array(), 0, 3600);
            int startIndex = 0;
            while ((long)startIndex < this.traceCount()) {
                int numTraces = numTracesPerChunk;
                int lastIndex = startIndex + numTraces - 1;
                if ((long)lastIndex >= this.traceCount()) {
                    lastIndex = (int)this.traceCount() - 1;
                }
                numTraces = lastIndex - startIndex + 1;
                reader.read(inputBuffer.array(), 0, numTraces * bytesPerInputTrace);
                byte[] input = inputBuffer.array();
                byte[] output = outputBuffer.array();
                int outputIndex = 0;
                int inputIndex = 0;
                for (int n = 0; n < numTraces; ++n) {
                    int k;
                    for (k = 0; k < 240; ++k) {
                        output[outputIndex + k] = input[inputIndex + k];
                    }
                    for (k = 0; k < inputByteArray.length; ++k) {
                        inputByteArray[k] = input[inputIndex + 240 + k];
                    }
                    if (this.m_header.SampleFormat == Segy_SampleFormat.IBM) {
                        Tools_ByteArray.populateFloatUsingIBM(inputByteArray, inputFloatArray);
                    } else if (this.m_header.SampleFormat == Segy_SampleFormat.IEEE) {
                        Tools_ByteArray.populateFloatUsingIEEE(this.m_header.FileByteOrder, inputByteArray, inputFloatArray);
                    } else if (this.m_header.SampleFormat == Segy_SampleFormat.Short) {
                        Tools_ByteArray.populateFloatUsingShort(this.m_header.FileByteOrder, inputByteArray, inputFloatArray);
                    }
                    float max = 1.0E-30f;
                    for (int s = 0; s < maxSamples; ++s) {
                        max = Math.max(max, Math.abs(inputFloatArray[s]));
                    }
                    float scalar = 31000.0f / max;
                    for (int s = 0; s < maxSamples; ++s) {
                        short sample = (short)(scalar * inputFloatArray[s]);
                        outputBuffer.putShort(outputIndex + 240 + 2 * s, sample);
                    }
                    outputIndex += bytesPerOutputTrace;
                    inputIndex += bytesPerInputTrace;
                }
                writer.write(outputBuffer.array(), 0, numTraces * bytesPerOutputTrace);
                System.out.println("startIndex = " + (startIndex += numTraces));
            }
            reader.close();
            writer.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void outputCompressedVersion_SubSample(String outputFileName, int maxSamples) {
        try {
            if (!this.isFileOK()) {
                return;
            }
            maxSamples = Math.max(maxSamples, 10);
            int numOutputSamples = maxSamples = Math.min(maxSamples, this.samplesPerTrace() / 2);
            int numInputSamples = 2 * maxSamples;
            int numTracesPerChunk = 1000;
            byte[] inputByteArray = null;
            if (this.m_header.SampleFormat == Segy_SampleFormat.IBM) {
                inputByteArray = new byte[4 * numInputSamples];
            }
            if (this.m_header.SampleFormat == Segy_SampleFormat.IEEE) {
                inputByteArray = new byte[4 * numInputSamples];
            }
            if (this.m_header.SampleFormat == Segy_SampleFormat.Short) {
                inputByteArray = new byte[2 * numInputSamples];
            }
            float[] inputFloatArray = new float[numInputSamples];
            int bytesPerOutputTrace = 240 + 2 * numOutputSamples;
            int bytesPerInputTrace = this.bytesPerTrace();
            int numBytesInOutputChunk = numTracesPerChunk * bytesPerOutputTrace;
            int numBytesInInputChunk = numTracesPerChunk * bytesPerInputTrace;
            RandomAccessFile writer = new RandomAccessFile(outputFileName, "rw");
            RandomAccessFile reader = new RandomAccessFile(this.m_fileName, "r");
            ByteBuffer headerBuffer = ByteBuffer.allocate(3600);
            ByteBuffer inputBuffer = ByteBuffer_Shared.buffer(0, numBytesInInputChunk);
            ByteBuffer outputBuffer = ByteBuffer_Shared.buffer(1, numBytesInOutputChunk);
            reader.read(headerBuffer.array(), 0, 3600);
            headerBuffer.order(this.m_header.FileByteOrder);
            outputBuffer.order(this.m_header.FileByteOrder);
            headerBuffer.putShort(3224, (short)3);
            headerBuffer.putShort(3220, (short)numOutputSamples);
            headerBuffer.putShort(3216, (short)4000);
            writer.write(headerBuffer.array(), 0, 3600);
            int startIndex = 0;
            while ((long)startIndex < this.traceCount()) {
                int numTraces = numTracesPerChunk;
                int lastIndex = startIndex + numTraces - 1;
                if ((long)lastIndex >= this.traceCount()) {
                    lastIndex = (int)this.traceCount() - 1;
                }
                numTraces = lastIndex - startIndex + 1;
                reader.read(inputBuffer.array(), 0, numTraces * bytesPerInputTrace);
                byte[] input = inputBuffer.array();
                byte[] output = outputBuffer.array();
                int outputIndex = 0;
                int inputIndex = 0;
                for (int n = 0; n < numTraces; ++n) {
                    int k;
                    for (k = 0; k < 240; ++k) {
                        output[outputIndex + k] = input[inputIndex + k];
                    }
                    for (k = 0; k < inputByteArray.length; ++k) {
                        inputByteArray[k] = input[inputIndex + 240 + k];
                    }
                    if (this.m_header.SampleFormat == Segy_SampleFormat.IBM) {
                        Tools_ByteArray.populateFloatUsingIBM(inputByteArray, inputFloatArray);
                    } else if (this.m_header.SampleFormat == Segy_SampleFormat.IEEE) {
                        Tools_ByteArray.populateFloatUsingIEEE(this.m_header.FileByteOrder, inputByteArray, inputFloatArray);
                    } else if (this.m_header.SampleFormat == Segy_SampleFormat.Short) {
                        Tools_ByteArray.populateFloatUsingShort(this.m_header.FileByteOrder, inputByteArray, inputFloatArray);
                    }
                    float max = 1.0E-30f;
                    for (int s = 0; s < inputFloatArray.length; ++s) {
                        max = Math.max(max, Math.abs(inputFloatArray[s]));
                    }
                    float scalar = 31000.0f / max;
                    for (int s = 0; s < numOutputSamples; ++s) {
                        float inputm1 = 0.0f;
                        float input0 = inputFloatArray[2 * s];
                        float inputp1 = 0.0f;
                        int index = 2 * s - 1;
                        if (index >= 0) {
                            inputm1 = inputFloatArray[index];
                        }
                        if ((index = 2 * s + 1) < inputFloatArray.length) {
                            inputp1 = inputFloatArray[index];
                        }
                        float outVal = 0.25f * inputm1 + 0.5f * input0 + 0.25f * inputp1;
                        short sample = (short)(scalar * outVal);
                        outputBuffer.putShort(outputIndex + 240 + 2 * s, sample);
                    }
                    outputIndex += bytesPerOutputTrace;
                    inputIndex += bytesPerInputTrace;
                }
                writer.write(outputBuffer.array(), 0, numTraces * bytesPerOutputTrace);
                System.out.println("startIndex = " + (startIndex += numTraces));
            }
            reader.close();
            writer.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setSegyDictionary(Segy_Dictionary dict) {
        this.m_segyDictionary = dict;
    }

    @Override
    public void setDictionary(Object objDict) {
        if (objDict instanceof Segy_Dictionary) {
            Segy_Dictionary dict = (Segy_Dictionary)objDict;
            this.setSegyDictionary(dict);
        }
    }

    @Override
    public String getName() {
        File file = new File(this.m_fileName);
        return file.getName();
    }

    @Override
    public String getDirectory() {
        File file = new File(this.m_fileName);
        return file.getParent();
    }

    public Segy_Dictionary dictionary() {
        return this.m_segyDictionary;
    }

    public String fileName() {
        try {
            if (this.m_fileName != null) {
                return this.m_fileName;
            }
            return "";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    public String getFilePath() {
        return this.fileName();
    }

    public int bytesPerTrace() {
        try {
            return this.m_header.BytesPerTrace;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0;
        }
    }

    @Override
    public float sampleInterval() {
        try {
            return this.m_header.SampleInterval;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 4.0f;
        }
    }

    @Override
    public int samplesPerTrace() {
        try {
            return this.m_header.SamplesPerTrace;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0;
        }
    }

    @Override
    public long traceCount() {
        return this.m_traceCount;
    }

    @Override
    public boolean isFileOK() {
        return this.m_fileName != null;
    }

    public byte[] ebcdicBytes() {
        return this.m_ebcdicByteArray;
    }

    public byte[] headerBytes() {
        return this.m_fileHeaderByteArray;
    }

    public Segy_FileHeader binaryHeader() {
        return this.m_header;
    }

    public void setFileName(String fileName) {
        try {
            this.setFileName(fileName, true);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void setFileName(String fileName, boolean showDialog) {
        try {
            this.m_fileName = null;
            if (!Tools_FileSystem.exists_file((String)fileName)) {
                if (SharedApplicationData.singleton().isWindows() && ((String)fileName).startsWith("/")) {
                    fileName = "\\" + ((String)fileName).replace("/", "\\");
                    System.out.println("UNC garbage? fileName = " + (String)fileName);
                }
                if (!Tools_FileSystem.exists_file((String)fileName)) {
                    System.out.println("Tools_FileSystem.exists_file(fileName) == false");
                    this.m_reasonObjectNotValid = "File name not valid";
                    try {
                        if (showDialog) {
                            JOptionPane.showMessageDialog(null, "The file (" + (String)fileName + ") does not exist", " ", 0);
                        }
                    }
                    catch (Exception mse) {
                        mse.printStackTrace();
                    }
                    this.m_fileName = null;
                    this.m_listenerManager.broadcast(this, null);
                    return;
                }
            }
            this.m_fileName = fileName;
            RandomAccessFile reader = new RandomAccessFile(this.m_fileName, "r");
            if (reader == null) {
                try {
                    if (showDialog) {
                        JOptionPane.showMessageDialog(null, "Could not open file (" + (String)fileName + ") ", " ", 0);
                    }
                }
                catch (Exception mse) {
                    mse.printStackTrace();
                }
                this.m_reasonObjectNotValid = "Failed to open reader object";
                System.out.println("reader == null");
                this.m_fileName = null;
                reader.close();
                this.m_listenerManager.broadcast(this, null);
                return;
            }
            if (reader.length() < 3600L) {
                this.m_reasonObjectNotValid = "Not a valid segy file";
                try {
                    if (showDialog) {
                        JOptionPane.showMessageDialog(null, "File (" + (String)fileName + ") less than 3600 bytes", " ", 0);
                    }
                }
                catch (Exception mse) {
                    mse.printStackTrace();
                }
                System.out.println("reader.length() < 3600");
                this.m_fileName = null;
                reader.close();
                this.m_listenerManager.broadcast(this, null);
                return;
            }
            this.m_fileByteCount = reader.length();
            if (reader.read(this.m_ebcdicByteArray, 0, 3200) != 3200) {
                this.m_reasonObjectNotValid = "EBCDIC read fail";
                try {
                    if (showDialog) {
                        JOptionPane.showMessageDialog(null, "Could not read EBCDIC (" + (String)fileName + ")", " ", 0);
                    }
                }
                catch (Exception mse) {
                    mse.printStackTrace();
                }
                System.out.println("reader.read(m_ebcdicByteArray, 0, 3200) != 3200");
                this.m_fileName = null;
                reader.close();
                this.m_listenerManager.broadcast(this, null);
                return;
            }
            if (reader.read(this.m_fileHeaderByteArray) != 400) {
                try {
                    if (showDialog) {
                        JOptionPane.showMessageDialog(null, "Could not read 400 byte binary header (" + (String)fileName + ")", " ", 0);
                    }
                }
                catch (Exception mse) {
                    mse.printStackTrace();
                }
                this.m_reasonObjectNotValid = "Binary header read fail";
                System.out.println("reader.read(m_ebcdicByteArray, 0, 400) != 400");
                this.m_fileName = null;
                reader.close();
                this.m_listenerManager.broadcast(this, null);
                return;
            }
            reader.close();
            this.m_header.insertHeaderBytes(this.m_fileHeaderByteArray);
            if (!this.m_header.valid()) {
                try {
                    if (showDialog) {
                        JOptionPane.showMessageDialog(null, "Could not interpret contents of 400 byte binary header (" + (String)fileName + ")", " ", 0);
                    }
                }
                catch (Exception mse) {
                    mse.printStackTrace();
                }
                this.m_reasonObjectNotValid = "Header interpretation failed - not a SEG-Y file?";
                System.out.println("if (m_header.valid() == false)");
                this.m_fileName = null;
                this.m_listenerManager.broadcast(this, null);
                return;
            }
            this.m_traceCount = (this.m_fileByteCount - 3600L) / (long)this.m_header.BytesPerTrace;
            int dataArrayByteCount = this.m_header.BytesPerSample * this.m_header.SamplesPerTrace;
            if (dataArrayByteCount < 1) {
                this.m_traceDataByteArray = null;
                this.m_traceDataArray = null;
            } else {
                if (this.m_traceDataByteArray == null) {
                    this.m_traceDataByteArray = new byte[dataArrayByteCount];
                }
                if (this.m_traceDataArray == null) {
                    this.m_traceDataArray = new float[this.m_header.SamplesPerTrace];
                }
                if (dataArrayByteCount != this.m_traceDataByteArray.length) {
                    this.m_traceDataByteArray = new byte[dataArrayByteCount];
                }
                if (this.m_header.SamplesPerTrace != this.m_traceDataArray.length) {
                    this.m_traceDataArray = new float[this.m_header.SamplesPerTrace];
                }
            }
            this.m_listenerManager.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void openPecosRAF() {
        try {
            if (this.m_pecosRAF != null) {
                try {
                    this.m_pecosRAF.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.m_pecosRAF = null;
            }
            this.m_pecosRAF = new RandomAccessFile(this.m_fileName, "r");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void closePecosRAF() {
        block4: {
            try {
                if (this.m_pecosRAF == null) break block4;
                try {
                    this.m_pecosRAF.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.m_pecosRAF = null;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }

    @Override
    public void populateEnsembleWithData(Ensemble ensemble, int fileID) throws Exception {
        this.populateEnsembleWithData(ensemble, fileID, true, true);
    }

    @Override
    public void populateEnsembleWithData(Ensemble ensemble, int fileID, boolean bReadHeaders, boolean bReadSamples) throws Exception {
        try {
            if (!this.isFileOK()) {
                throw new Exception("!this.isFileOK()");
            }
            if (!ensemble.dictionary().containsEntry("Trace", "FileID")) {
                throw new Exception("(Trace,FileID) not valid");
            }
            if (!ensemble.dictionary().containsEntry("Trace", "IndexInFile")) {
                throw new Exception("(Trace,IndexInFile) not valid");
            }
            int headerIndexFileID = ensemble.dictionary().getEntryIndex("Trace", "FileID");
            int headerIndexIndex = ensemble.dictionary().getEntryIndex("Trace", "IndexInFile");
            int headerIndexShotTimeShift = -9999;
            if (ensemble.dictionary().containsEntry("Shot", "TimeShift")) {
                headerIndexShotTimeShift = ensemble.dictionary().getEntryIndex("Shot", "TimeShift");
            }
            int headerIndexRecTimeShift = -9999;
            if (ensemble.dictionary().containsEntry("Receiver", "TimeShift")) {
                headerIndexRecTimeShift = ensemble.dictionary().getEntryIndex("Receiver", "TimeShift");
            }
            int count = 0;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                int fid = ensemble.trace(n).header().getInt(headerIndexFileID);
                if (fid != fileID) continue;
                ++count;
            }
            if (count < 1) {
                return;
            }
            RandomAccessFile reader = null;
            boolean closeStream = true;
            if (this.m_pecosRAF != null) {
                reader = this.m_pecosRAF;
                closeStream = false;
            }
            if (reader == null) {
                reader = new RandomAccessFile(this.m_fileName, "r");
                closeStream = true;
            }
            for (int k = 0; k < ensemble.traceCount(); ++k) {
                EnsembleTrace trace = ensemble.trace(k);
                int fid = trace.header().getInt(headerIndexFileID);
                if (fid != fileID) continue;
                long traceNumber = trace.header().getLong(headerIndexIndex);
                long offset = 3600L + traceNumber * (long)this.m_header.BytesPerTrace;
                reader.seek(offset);
                if (reader.getFilePointer() != offset) {
                    reader.close();
                    throw new Exception("Filed to seek to offset");
                }
                if (reader.read(this.m_traceHeaderByteArray) != 240) {
                    reader.close();
                    throw new Exception("reader.read(this.m_bytes_TraceHeader) != 240");
                }
                if (this.CaptureRawHeaderBytes) {
                    trace.insertRawSegyHeaderBytes(this.m_traceHeaderByteArray);
                }
                if (reader.read(this.m_traceDataByteArray) != this.m_traceDataByteArray.length) {
                    reader.close();
                    throw new Exception("reader.read(this.m_bytes_TraceData) != length");
                }
                if (this.m_header.SampleFormat == Segy_SampleFormat.IBM) {
                    Tools_ByteArray.populateFloatUsingIBM(this.m_traceDataByteArray, this.m_traceDataArray);
                } else if (this.m_header.SampleFormat == Segy_SampleFormat.IEEE) {
                    Tools_ByteArray.populateFloatUsingIEEE(this.m_header.FileByteOrder, this.m_traceDataByteArray, this.m_traceDataArray);
                } else if (this.m_header.SampleFormat == Segy_SampleFormat.Short) {
                    Tools_ByteArray.populateFloatUsingShort(this.m_header.FileByteOrder, this.m_traceDataByteArray, this.m_traceDataArray);
                }
                float traceTime0 = 0.0f;
                if (headerIndexShotTimeShift >= 0) {
                    traceTime0 += trace.header().getFloat(headerIndexShotTimeShift);
                }
                if (headerIndexRecTimeShift >= 0) {
                    traceTime0 += trace.header().getFloat(headerIndexRecTimeShift);
                }
                trace.data().insertArray(this.m_traceDataArray, this.m_traceDataArray.length);
                trace.data().setFirstSampleCoord(traceTime0);
                trace.data().setSampleInterval(this.m_header.SampleInterval);
            }
            if (closeStream) {
                reader.close();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void addImportLimit(int header, int type, int min, int max) {
        ImportLimit lim = new ImportLimit();
        lim.Header = header;
        lim.Min = min;
        lim.Max = max;
        lim.Type = type;
        this.ImportLimitList.add(lim);
    }

    @Override
    public void addImportLimit(ImportLimit il) {
        ImportLimit lim = new ImportLimit();
        lim.Header = il.Header;
        lim.Min = il.Min;
        lim.Max = il.Max;
        lim.Type = il.Type;
        lim.Column = il.Column;
        lim.Header = il.Header;
        this.ImportLimitList.add(lim);
    }

    @Override
    public void clearImportLimitList() {
        this.ImportLimitList.clear();
    }

    @Override
    public void populateEnsemble(Ensemble ensemble, long[] indices, int indexCount, boolean bGetHeaders, boolean bGetData) throws Exception {
        try {
            if (!this.isFileOK()) {
                throw new Exception("!this.isFileOK()");
            }
            long startTime = System.nanoTime();
            boolean bl = bGetHeaders = bGetHeaders && this.m_segyDictionary != null;
            if (bGetHeaders) {
                this.m_segyDictionary.prepareSeismicHeaderDictionary(ensemble.dictionary());
            }
            bGetData = bGetData && this.m_header.SamplesPerTrace > 0 && this.m_traceDataArray != null;
            RandomAccessFile reader = new RandomAccessFile(this.m_fileName, "r");
            boolean isFirstTrace = true;
            float traceTime0 = 0.0f;
            indexCount = Math.min(indexCount, indices.length);
            for (int k = 0; k < indexCount; ++k) {
                long n = indices[k];
                if (n < 0L || n >= this.m_traceCount) continue;
                long offset = 3600L + n * (long)this.m_header.BytesPerTrace;
                reader.seek(offset);
                if (reader.getFilePointer() != offset) {
                    reader.close();
                    throw new Exception("Filed to seek to offset");
                }
                if (reader.read(this.m_traceHeaderByteArray) != 240) {
                    reader.close();
                    throw new Exception("reader.read(this.m_bytes_TraceHeader) != 240");
                }
                this.m_traceHeaderByteBuffer.rewind();
                this.m_traceHeaderByteBuffer.put(this.m_traceHeaderByteArray);
                this.m_traceHeaderByteBuffer.order(this.m_header.FileByteOrder);
                boolean importTrace = true;
                try {
                    if (this.ImportLimitList.size() >= 1) {
                        for (ImportLimit lim : this.ImportLimitList) {
                            int v;
                            if (lim.Type == 0 && ((v = this.m_traceHeaderByteBuffer.getInt(lim.Header - 1)) < lim.Min || v > lim.Max)) {
                                importTrace = false;
                            }
                            if (lim.Type != 1 || (v = (int)this.m_traceHeaderByteBuffer.getShort(lim.Header - 1)) >= lim.Min && v <= lim.Max) continue;
                            importTrace = false;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!importTrace) continue;
                if (bGetData) {
                    int s;
                    if (reader.read(this.m_traceDataByteArray) != this.m_traceDataByteArray.length) {
                        reader.close();
                        throw new Exception("reader.read(this.m_bytes_TraceData) != length");
                    }
                    if (this.m_header.SampleFormat == Segy_SampleFormat.IBM) {
                        Tools_ByteArray.populateFloatUsingIBM(this.m_traceDataByteArray, this.m_traceDataArray);
                    } else if (this.m_header.SampleFormat == Segy_SampleFormat.IEEE) {
                        Tools_ByteArray.populateFloatUsingIEEE(this.m_header.FileByteOrder, this.m_traceDataByteArray, this.m_traceDataArray);
                    } else if (this.m_header.SampleFormat == Segy_SampleFormat.Short) {
                        Tools_ByteArray.populateFloatUsingShort(this.m_header.FileByteOrder, this.m_traceDataByteArray, this.m_traceDataArray);
                    }
                    boolean shitty = false;
                    for (s = 0; s < this.m_traceDataArray.length; ++s) {
                        float v = this.m_traceDataArray[s];
                        shitty = shitty || Float.isInfinite(v) || Float.isNaN(v);
                    }
                    if (shitty) {
                        for (s = 0; s < this.m_traceDataArray.length; ++s) {
                            this.m_traceDataArray[s] = 0.0f;
                        }
                    }
                    if (isFirstTrace) {
                        isFirstTrace = false;
                    }
                }
                EnsembleTrace trace = ensemble.addTrace();
                if (this.CaptureRawHeaderBytes) {
                    trace.insertRawSegyHeaderBytes(this.m_traceHeaderByteArray);
                }
                if (bGetHeaders) {
                    this.m_segyDictionary.fillTraceHeader(this.m_traceHeaderByteBuffer, trace.header());
                }
                if (!bGetData) continue;
                trace.data().insertArray(this.m_traceDataArray, this.m_traceDataArray.length);
                trace.data().setFirstSampleCoord(traceTime0);
                trace.data().setSampleInterval(this.m_header.SampleInterval);
            }
            reader.close();
            this.ReadTime = System.nanoTime() - startTime;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void setBufferForSequentialRead(ByteBuffer b) {
        this.m_bufferSequentialRead = b;
    }

    public void populateEnsemble(Ensemble ensemble, long startIndex, int count, boolean bGetHeaders, boolean bGetData) throws Exception {
        try {
            if (!this.isFileOK()) {
                throw new Exception("!this.isFileOK()");
            }
            long startTime = System.nanoTime();
            boolean bl = bGetHeaders = bGetHeaders && this.m_segyDictionary != null;
            if (bGetHeaders) {
                this.m_segyDictionary.prepareSeismicHeaderDictionary(ensemble.dictionary());
            }
            bGetData = bGetData && this.m_header.SamplesPerTrace > 0 && this.m_traceDataArray != null;
            RandomAccessFile reader = new RandomAccessFile(this.m_fileName, "r");
            startIndex = Math.max(startIndex, 0L);
            long lastIndex = startIndex + (long)count - 1L;
            count = (int)((lastIndex = Math.min(lastIndex, this.m_traceCount - 1L)) - startIndex + 1L);
            if (count < 1) {
                return;
            }
            int numBytes = count * this.m_header.BytesPerTrace;
            ByteBuffer buff = null;
            buff = this.m_bufferSequentialRead != null ? this.m_bufferSequentialRead : ByteBuffer_Shared.buffer(0, numBytes);
            this.TempSequentialBuffer = buff;
            this.TempBuffLen = numBytes;
            this.TempTraceCount = count;
            buff.order(this.m_header.FileByteOrder);
            long offset = 3600L + startIndex * (long)this.m_header.BytesPerTrace;
            reader.seek(offset);
            int numRead = reader.read(buff.array(), 0, numBytes);
            reader.close();
            float traceTime0 = 0.0f;
            if (numRead != numBytes) {
                return;
            }
            for (int n = 0; n < count; ++n) {
                int headerOffset = n * this.m_header.BytesPerTrace;
                int dataOffset = headerOffset + 240;
                if (bGetData) {
                    int s;
                    if (this.m_header.SampleFormat == Segy_SampleFormat.IBM) {
                        Tools_ByteArray.populateFloatUsingIBM(buff.array(), dataOffset, this.m_traceDataArray);
                    }
                    if (this.m_header.SampleFormat == Segy_SampleFormat.IEEE) {
                        Tools_ByteArray.populateFloatUsingIEEE(this.m_header.FileByteOrder, buff.array(), dataOffset, this.m_traceDataArray);
                    }
                    if (this.m_header.SampleFormat == Segy_SampleFormat.Short) {
                        Tools_ByteArray.populateFloatUsingShort(this.m_header.FileByteOrder, buff.array(), dataOffset, this.m_traceDataArray);
                    }
                    boolean shitty = false;
                    for (s = 0; s < this.m_traceDataArray.length; ++s) {
                        float v = this.m_traceDataArray[s];
                        shitty = shitty || Float.isInfinite(v) || Float.isNaN(v);
                    }
                    if (shitty) {
                        for (s = 0; s < this.m_traceDataArray.length; ++s) {
                            this.m_traceDataArray[s] = 0.0f;
                        }
                    }
                }
                EnsembleTrace trace = ensemble.addTrace();
                if (bGetHeaders) {
                    this.m_segyDictionary.fillTraceHeader(buff, headerOffset, trace.header());
                }
                if (!bGetData) continue;
                trace.data().insertArray(this.m_traceDataArray, this.m_traceDataArray.length);
                trace.data().setFirstSampleCoord(traceTime0);
                trace.data().setSampleInterval(this.m_header.SampleInterval);
            }
            this.ReadTime = System.nanoTime() - startTime;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Ensemble createNewEnsemble(long[] indices, int indexCount, boolean bGetHeaders, boolean bGetData) throws Exception {
        try {
            Ensemble ensemble = new Ensemble();
            this.populateEnsemble(ensemble, indices, indexCount, bGetHeaders, bGetData);
            return ensemble;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public SeismicFileType getFileType() {
        return SeismicFileType.Segy;
    }
}

