/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Project;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Seismic.CubicTraceInterpolator;
import com.PecosCore.Data.Seismic.SparseCmpGatherManager;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge_Wrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Geometry.TableParser;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Plugins.PluginManager;
import com.PecosCore.Shared.ChangeLog_Flatirons;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProjectCreator {
    public boolean m_valid = false;
    public ArrayList<String> m_errorReasons = new ArrayList();
    protected String m_canonHome;
    protected String m_projectName;
    protected String m_projectNameExtended;
    protected String m_projectSource;
    protected String m_projectPath;
    protected boolean m_createCompressedData = false;
    protected float m_maxTime = 2000.0f;
    protected CubicTraceInterpolator m_cti = new CubicTraceInterpolator();
    protected float[] m_outputData;
    protected int m_marineDecimation = 1;
    protected Logger m_logger;
    protected Grid3D_Conversion m_grid3D = new Grid3D_Conversion();
    protected String m_units = "Meters";
    protected String m_dimension = "2D";
    protected Tools_Ensemble m_noiseTool = new Tools_Ensemble();
    protected boolean m_killNoisy = false;
    protected float m_noiseWindowLength = 100.0f;
    protected float m_noiseCutoff = 10.0f;
    protected Table_Abstract m_shotTable = new Table_Memory();
    protected TableParser m_shotParser;
    protected Table_Abstract m_receiverTable = new Table_Memory();
    protected TableParser m_receiverParser;
    protected Table_Abstract m_fileTable = new Table_Memory();
    protected int m_fileIndex_FileID;
    protected int m_fileIndex_Name;
    protected int m_fileIndex_Path;
    protected TraceTable_Huge m_diskTable;
    protected String m_traceTablePath = "";
    protected long m_traceCount = 0L;
    protected int m_fileID = 999;
    protected long m_traceID = 999L;
    protected SparseCmpGatherManager m_sparseCmpGathers = null;
    protected int m_inputSampleCount;
    protected int m_outputSampleCount;
    protected float m_inputTraceSampleInterval;
    protected float m_outputTraceSampleInterval;
    protected int m_samplesPerWindow = 10;
    protected int m_windowsPerTrace;
    protected int m_bytesPerWindow;
    protected int m_bytesPerTrace;
    protected String m_dataFileName;
    protected String m_dataFileName_Full;
    protected long m_numTracesAdded = 0L;
    protected float[] m_inputData;

    public boolean valid() {
        return this.m_valid;
    }

    public ArrayList<String> errorReasons() {
        return this.m_errorReasons;
    }

    public Table_Abstract shotTable() {
        return this.m_shotTable;
    }

    public TableParser shotParser() {
        return this.m_shotParser;
    }

    public Table_Abstract receiverTable() {
        return this.m_receiverTable;
    }

    public TableParser receiverParser() {
        return this.m_receiverParser;
    }

    public ProjectCreator(Logger logger, String canonHome, String projectName, String projectSource, boolean createCompressedData, float maxTime, int inputSampleCount, float inputTraceSampleInterval, EnsembleHeaderDictionary dict, boolean meters, boolean dim3D, boolean resample, float outputSampleInterval) throws Exception {
        try {
            this.m_outputTraceSampleInterval = outputSampleInterval;
            this.m_outputTraceSampleInterval = Math.max(2.0f, this.m_outputTraceSampleInterval);
            this.m_logger = logger;
            this.m_valid = false;
            this.m_canonHome = canonHome;
            this.m_projectName = projectName;
            this.m_projectNameExtended = this.m_projectName + ".xtref";
            this.m_projectSource = Tools_Strings.removeCrap(projectSource);
            this.m_createCompressedData = createCompressedData;
            this.m_maxTime = maxTime;
            if (!Tools_FileSystem.exists_path(this.m_canonHome)) {
                this.m_errorReasons.add("The CanonHome path does not exist: " + this.m_canonHome);
                this.m_logger.log(Level.INFO, "The CanonHome path does not exist: " + this.m_canonHome);
                return;
            }
            if (this.m_projectName.length() < 2) {
                this.m_errorReasons.add("The project name is too short: " + this.m_projectName);
                this.m_logger.log(Level.INFO, "The project name is too short: " + this.m_projectName);
                return;
            }
            String projectContainerPath = "";
            projectContainerPath = this.m_projectSource.equalsIgnoreCase("SEISSPACE") ? SharedApplicationData.staticsProjectPath() : Tools_FileSystem.confirmSubDirectoryExists(this.m_canonHome, "RefractionProjects");
            this.m_projectPath = projectContainerPath + "/" + this.m_projectName;
            String projectPathWithExtension = projectContainerPath + "/" + this.m_projectNameExtended;
            if (Tools_FileSystem.exists_path(this.m_projectPath) || Tools_FileSystem.exists_path(projectPathWithExtension)) {
                this.m_errorReasons.add("A project with this name already exists: " + this.m_projectName);
                this.m_logger.log(Level.INFO, "A project with this name already exists: " + this.m_projectName);
                throw new Exception("File name already exists");
            }
            this.m_logger.log(Level.INFO, "Okay so far, project path =  " + this.m_projectPath);
            if (!this.confirmHeader(dict, "Shot", "PointNumber")) {
                return;
            }
            if (!this.confirmHeader(dict, "Shot", "Easting")) {
                return;
            }
            if (!this.confirmHeader(dict, "Shot", "Northing")) {
                return;
            }
            if (!this.confirmHeader(dict, "Shot", "Elevation")) {
                return;
            }
            if (!this.confirmHeader(dict, "Receiver", "PointNumber")) {
                return;
            }
            if (!this.confirmHeader(dict, "Receiver", "Easting")) {
                return;
            }
            if (!this.confirmHeader(dict, "Receiver", "Northing")) {
                return;
            }
            if (!this.confirmHeader(dict, "Receiver", "Elevation")) {
                return;
            }
            this.m_logger.log(Level.INFO, "Required geometry headers found");
            if (!this.m_createCompressedData) {
                if (!this.confirmHeader(dict, "Trace", "FileID")) {
                    return;
                }
                if (!this.confirmHeader(dict, "Trace", "IndexInFile")) {
                    return;
                }
            }
            if (this.m_createCompressedData) {
                if (!this.prepareCompressionOptions(inputSampleCount, inputTraceSampleInterval)) {
                    return;
                }
                this.m_logger.log(Level.INFO, "Compression options detected");
            }
            this.m_projectPath = Tools_FileSystem.confirmSubDirectoryExists(projectContainerPath, this.m_projectNameExtended);
            if (!this.prepareTables()) {
                this.m_logger.log(Level.INFO, "Failed to prepare database tables");
                Tools_FileSystem.deletePathIfExists(this.m_projectPath);
                return;
            }
            if (this.m_createCompressedData && !this.prepareCompressionFile()) {
                Tools_FileSystem.deletePathIfExists(this.m_projectPath);
                return;
            }
            this.m_units = meters ? "Meters" : "Feet";
            double gridSize = Pecos.gridSize(this.m_units);
            this.m_grid3D.setBinSize(gridSize, gridSize);
            this.m_dimension = dim3D ? "3D" : "2D";
            this.m_valid = true;
        }
        catch (Exception error) {
            this.m_logger.log(Level.INFO, "Exception in const: " + error.getMessage());
            throw error;
        }
    }

    public void prepareReceiverMarineOptions(double recBinSize, int decimation) {
        try {
            this.m_marineDecimation = decimation;
            this.m_receiverParser.IsMarine = true;
            this.m_receiverParser.RecBinSize = recBinSize;
        }
        catch (Exception error) {
            this.m_logger.log(Level.INFO, "Exception in const: " + error.getMessage());
        }
    }

    public void prepareSparseCmpOptions(double spacing, double radius) {
        try {
            String sparsePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "SparseCMP");
            this.m_sparseCmpGathers = new SparseCmpGatherManager(sparsePath);
            this.m_sparseCmpGathers.MaxOffset = 100000.0;
            this.m_sparseCmpGathers.MinOffset = 0.0;
            this.m_sparseCmpGathers.prepare(spacing, radius);
        }
        catch (Exception error) {
            this.m_logger.log(Level.INFO, "Exception in const: " + error.getMessage());
        }
    }

    public void abort() {
        try {
            System.out.println("ProjectCreator: Enter abort()");
        }
        catch (Exception error) {
            this.m_logger.log(Level.INFO, "Exception in abort: " + error.getMessage());
        }
    }

    public void done() {
        try {
            this.m_logger.log(Level.INFO, "ProjectCreator: Enter done()");
            System.out.println("ProjectCreator: Enter done()");
            if (!this.m_valid) {
                System.out.println("ProjectCreator: m_valid == false");
                return;
            }
            this.m_valid = false;
            String driverName = "SQLITE";
            if (this.m_createCompressedData) {
                // empty if block
            }
            System.out.println("ProjectCreator:  call finishedAppending");
            this.m_logger.log(Level.INFO, "call m_diskTable.finishedAppending()");
            this.m_diskTable.finishedAppending(this.m_logger);
            this.m_logger.log(Level.INFO, "after m_diskTable.finishedAppending()");
            this.m_diskTable = null;
            TraceTable_Huge_Wrapper wrapper = new TraceTable_Huge_Wrapper(this.m_traceTablePath);
            this.m_logger.log(Level.INFO, "call m_fileTable.saveToPath( m_projectPath )");
            this.m_fileTable.saveToPath(this.m_projectPath);
            String importTablePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "ImportedTables");
            this.m_shotTable.saveBinary(importTablePath + "/Shot.bin");
            this.m_receiverTable.saveBinary(importTablePath + "/Receiver.bin");
            this.m_fileTable.saveBinary(importTablePath + "/FileList.bin");
            this.m_logger.log(Level.INFO, "after saveBinary()");
            System.out.println("ProjectCreator:  create grid");
            String gridFile = this.m_projectPath + "/GridDefinition3D.xml";
            this.m_grid3D.save(gridFile);
            System.out.println("ProjectCreator:  create ParameterTree");
            ParameterTree p = new ParameterTree();
            Date date = new Date();
            String dateCreated = date.toString();
            p.string_put("DriverName", driverName);
            p.string_put("Units", this.m_units);
            p.string_put("Dimension", this.m_dimension);
            p.bool_put("HasSeismic", true);
            p.bool_put("HasShots", true);
            p.bool_put("HasReceivers", true);
            p.bool_put("HasCompressed", this.m_createCompressedData);
            p.int_put("ShotCount", this.m_shotTable.row_count());
            p.int_put("ReceiverCount", this.m_receiverTable.row_count());
            p.long_put("TraceCount", this.m_traceCount);
            p.string_put("Origin", this.m_projectSource);
            p.string_put("DateCreated", dateCreated);
            p.string_put("VersionCreated", ChangeLog_Flatirons.singleton().currentVersion());
            String paramFileName = this.m_projectPath + "/ProjectDescription.xml";
            p.save(paramFileName);
            System.out.println("ProjectCreator ParameterTree");
            p.print(0);
            this.m_logger.log(Level.INFO, "after save paramFileName");
            String shotConFile = this.m_projectPath + "/ShotConflicts.xml";
            this.m_shotParser.saveConflicts(shotConFile);
            String recConFile = this.m_projectPath + "/ReceiverConflicts.xml";
            this.m_receiverParser.saveConflicts(recConFile);
            if (this.m_sparseCmpGathers != null) {
                this.m_sparseCmpGathers.flush(true);
            }
            this.m_logger.log(Level.INFO, "done() finished");
        }
        catch (Exception error) {
            this.m_logger.log(Level.INFO, "done exception " + error.getMessage());
        }
    }

    protected void marineDecimation(Ensemble ensemble) {
        try {
            int numStart = ensemble.traceCount();
            int indexX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            int indexKilled = ensemble.dictionary().addEntry("Trace", "Killed", DataType.Bool);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                boolean okay;
                EnsembleTrace trace = ensemble.trace(n);
                double x = trace.header().getDouble(indexX);
                double y = trace.header().getDouble(indexY);
                int line = (int)(0.5 + y / this.m_receiverParser.RecBinSize);
                int point = (int)(0.5 + x / this.m_receiverParser.RecBinSize);
                boolean bl = okay = line % this.m_marineDecimation == 0 && point % this.m_marineDecimation == 0;
                if (!okay) {
                    trace.header().putBool(indexKilled, true);
                    continue;
                }
                trace.header().putBool(indexKilled, false);
                trace.header().putDouble(indexX, (double)point * this.m_receiverParser.RecBinSize);
                trace.header().putDouble(indexY, (double)line * this.m_receiverParser.RecBinSize);
            }
            ensemble.removeKilledTraces();
            int numEnd = ensemble.traceCount();
            int n = numStart - numEnd;
        }
        catch (Exception error) {
            this.m_logger.log(Level.INFO, "marineDecimation exception " + error.getMessage());
        }
    }

    protected void appendData(Ensemble ensemble) {
        try {
            if (ensemble.traceCount() < 1) {
                return;
            }
            if (this.m_numTracesAdded != this.m_traceCount) {
                this.m_valid = false;
                return;
            }
            int numBytesInOutputChunk = ensemble.traceCount() * this.m_bytesPerTrace;
            ByteBuffer outputBuffer = ByteBuffer_Shared.buffer(1, numBytesInOutputChunk);
            byte[] output = outputBuffer.array();
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                FloatArrayWrapper wrapper = trace.data();
                if (this.m_inputData.length < wrapper.length()) {
                    this.m_inputData = new float[wrapper.length()];
                }
                wrapper.copyToArray(this.m_inputData);
                this.m_cti.prepareInput(this.m_inputData, 0.0f, this.m_inputTraceSampleInterval);
                this.m_cti.interpolate(this.m_outputData, 0.0f, this.m_outputTraceSampleInterval);
                int outputIndex = n * this.m_bytesPerTrace;
                float time0 = 0.0f;
                outputBuffer.putFloat(outputIndex, time0);
                outputIndex += 4;
                for (int w = 0; w < this.m_windowsPerTrace; ++w) {
                    float max = 1.0E-20f;
                    for (int s = 0; s < this.m_samplesPerWindow; ++s) {
                        float inputSample = this.m_outputData[s + w * this.m_samplesPerWindow];
                        max = Math.max(max, Math.abs(inputSample));
                    }
                    float scalar = 125.0f / max;
                    outputBuffer.putFloat(outputIndex, scalar);
                    outputIndex += 4;
                    for (int s = 0; s < this.m_samplesPerWindow; ++s) {
                        float inputSample = this.m_outputData[s + w * this.m_samplesPerWindow];
                        output[outputIndex++] = (byte)(scalar * inputSample);
                    }
                }
                ++this.m_numTracesAdded;
            }
            RandomAccessFile dataRAF = new RandomAccessFile(this.m_dataFileName_Full, "rw");
            long length = dataRAF.length();
            dataRAF.seek(length);
            dataRAF.write(outputBuffer.array(), 0, numBytesInOutputChunk);
            length = dataRAF.length();
            long predicted = 100L + this.m_numTracesAdded * (long)this.m_bytesPerTrace;
            if (predicted != length) {
                System.out.println("predicted != length");
            }
            dataRAF.close();
        }
        catch (Exception error) {
            this.m_logger.log(Level.INFO, "Exception in appendData: " + error.getMessage());
            this.m_valid = false;
        }
    }

    protected boolean prepareCompressionOptions(int inputSampleCount, float inputTraceSampleInterval) {
        try {
            if (inputSampleCount < 5) {
                this.m_logger.log(Level.INFO, "Data must have at least 5 samples! ");
                this.m_errorReasons.add("The input traces must have at least five samples");
                return false;
            }
            this.m_inputSampleCount = inputSampleCount;
            this.m_inputData = new float[this.m_inputSampleCount];
            this.m_inputTraceSampleInterval = inputTraceSampleInterval;
            if (this.m_inputTraceSampleInterval < 0.1f) {
                this.m_inputTraceSampleInterval = 0.1f;
            }
            this.m_outputSampleCount = (int)(0.5 + (double)(this.m_maxTime / this.m_outputTraceSampleInterval));
            this.m_windowsPerTrace = this.m_outputSampleCount / this.m_samplesPerWindow;
            this.m_windowsPerTrace = Math.max(this.m_windowsPerTrace, 1);
            this.m_outputSampleCount = this.m_samplesPerWindow * this.m_windowsPerTrace;
            this.m_outputData = new float[this.m_outputSampleCount];
            this.m_bytesPerWindow = 4 + this.m_samplesPerWindow;
            this.m_bytesPerTrace = 4 + this.m_bytesPerWindow * this.m_windowsPerTrace;
            return true;
        }
        catch (Exception error) {
            this.m_logger.log(Level.INFO, "Exception in prepComp: " + error.getMessage());
            this.m_errorReasons.add(error.getMessage());
            return false;
        }
    }

    protected boolean prepareCompressionFile() {
        try {
            String dataPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "Data");
            this.m_dataFileName = dataPath + "/" + this.m_projectName + "_data.sgy";
            this.m_dataFileName_Full = this.m_dataFileName + "_wcf";
            RandomAccessFile dataRAF = new RandomAccessFile(this.m_dataFileName_Full, "rw");
            int row = this.m_fileTable.row_increment();
            this.m_fileTable.putInt(row, this.m_fileIndex_FileID, 1000);
            String baseName = "";
            if (this.m_projectName.endsWith(".xtref")) {
                int endChar = this.m_projectName.length() - ".xtref".length();
                baseName = this.m_projectName.substring(0, endChar);
            } else {
                baseName = this.m_projectName;
            }
            this.m_fileTable.putString(row, this.m_fileIndex_Name, baseName + "_data.sgy");
            this.m_fileTable.putString(row, this.m_fileIndex_Path, dataPath);
            ByteBuffer outputHeaderBuffer = ByteBuffer.allocate(100);
            int magic = 420024;
            int version = 1000;
            outputHeaderBuffer.putInt(0, magic);
            outputHeaderBuffer.putInt(4, version);
            outputHeaderBuffer.putFloat(8, this.m_outputTraceSampleInterval);
            outputHeaderBuffer.putInt(12, this.m_samplesPerWindow);
            outputHeaderBuffer.putInt(16, this.m_windowsPerTrace);
            dataRAF.write(outputHeaderBuffer.array(), 0, 100);
            dataRAF.close();
            return true;
        }
        catch (Exception error) {
            this.m_logger.log(Level.INFO, "Exception in prepareCompFile: " + error.getMessage());
            this.m_errorReasons.add(error.getMessage());
            return false;
        }
    }

    public void killNoisyTraces(float windowLength, float cutoff) {
        try {
            this.m_killNoisy = true;
            this.m_noiseCutoff = Math.max(cutoff, 0.5f);
            this.m_noiseCutoff = Math.min(this.m_noiseCutoff, 90.0f);
            this.m_noiseWindowLength = Math.max(windowLength, 50.0f);
            this.m_noiseWindowLength = Math.min(this.m_noiseWindowLength, 500.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void mergeEnsemble(Ensemble ensemble) {
        try {
            int numAdded;
            if (!this.m_valid) {
                this.m_logger.log(Level.INFO, "cannot mergeEnsemble, m_valid = false");
                return;
            }
            if (this.m_createCompressedData && this.m_receiverParser.IsMarine && this.m_marineDecimation >= 2) {
                this.marineDecimation(ensemble);
            }
            if (this.m_createCompressedData) {
                Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FileID", 0, 1000, 0);
                Tools_Ensemble.setHeaderLong(ensemble, "Trace", "IndexInFile", 0, this.m_traceCount, 1L);
                this.appendData(ensemble);
            }
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "Flags", 0, 0, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "Killed", 0, 0, 0);
            if (!ensemble.dictionary().containsEntry("Trace", "FBP_User")) {
                Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_User", 0, -9999, 0);
            }
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_Back1", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_Back2", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_Back3", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_PickPredDT", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_PickPredVNS", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_AMP", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_PickT", 0, -9999, 0);
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FBP_TAP", 0, -9999, 0);
            if (PluginManager.singleton().currentPlugin() != null) {
                PluginManager.singleton().currentPlugin().addFBPTraceHeaderValues(ensemble);
            }
            if (this.m_killNoisy) {
                try {
                    this.m_noiseTool.computeNoiseLevel(ensemble, false, true, this.m_noiseWindowLength, this.m_noiseCutoff, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_shotParser.IgnoreTraceCode = true;
            this.m_receiverParser.IgnoreTraceCode = true;
            this.m_shotParser.handleEnsemble(ensemble);
            this.m_receiverParser.handleEnsemble(ensemble);
            Tools_Ensemble.computeInlineCrossline(ensemble, this.m_grid3D);
            if (this.m_diskTable == null) {
                ensemble.dictionary().addEntry("Trace", "FBP_User", DataType.Float);
                ensemble.dictionary().addEntry("Trace", "FileID", DataType.Int);
                ensemble.dictionary().addEntry("Trace", "IndexInFile", DataType.Long);
                this.m_diskTable = new TraceTable_Huge(this.m_traceTablePath, "Trace", ensemble, 6);
            }
            if ((numAdded = this.m_diskTable.appendEnsemble(ensemble)) != ensemble.traceCount()) {
                System.out.println("numAdded != ensemble.traceCount()");
            }
            try {
                if (this.m_sparseCmpGathers != null) {
                    Tools_Ensemble.setHeaderLong(ensemble, "Trace", "TraceIndex", 0, this.m_traceCount, 1L);
                    this.m_sparseCmpGathers.append(ensemble);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_traceCount += (long)numAdded;
        }
        catch (Exception error) {
            this.m_logger.log(Level.INFO, "Exception in mergeEns: " + error.getMessage());
        }
    }

    protected boolean prepareTables() {
        try {
            this.m_fileTable.setName("FileList");
            this.m_fileIndex_FileID = this.m_fileTable.column_append("FileID", DataType.Int);
            this.m_fileIndex_Name = this.m_fileTable.column_append("Name", DataType.Text);
            this.m_fileIndex_Path = this.m_fileTable.column_append("Directory", DataType.Text);
            this.m_traceTablePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "TraceTable");
            this.m_receiverTable.setName("Receiver");
            this.m_receiverParser = new TableParser(this.m_receiverTable);
            this.m_shotTable.setName("Shot");
            this.m_shotParser = new TableParser(this.m_shotTable);
            return true;
        }
        catch (Exception error) {
            this.m_logger.log(Level.INFO, "Exception in preptab: " + error.getMessage());
            this.m_errorReasons.add(error.getMessage());
            return false;
        }
    }

    protected boolean confirmHeader(EnsembleHeaderDictionary dict, String tableName, String columnName) {
        try {
            if (!dict.containsEntry(tableName, columnName)) {
                this.m_errorReasons.add("Required header not present: " + tableName + "," + columnName);
                this.m_logger.log(Level.INFO, "The dictionary does not contain " + tableName + ":" + columnName);
                return false;
            }
            return true;
        }
        catch (Exception error) {
            this.m_logger.log(Level.INFO, "Exception in confirmHeader: " + error.getMessage());
            this.m_errorReasons.add(error.getMessage());
            return false;
        }
    }
}

