/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Math;

import com.PecosCore.Shared.ExceptionMonitor;

public class Vector3D {
    public double X = 0.0;
    public double Y = 0.0;
    public double Z = 0.0;

    public void set(double x, double y, double z) {
        this.X = x;
        this.Y = y;
        this.Z = z;
    }

    public void normalize() {
        try {
            double lensq = this.X * this.X + this.Y * this.Y + this.Z * this.Z;
            if (lensq < 1.0E-20) {
                return;
            }
            double len = Math.sqrt(lensq);
            this.X /= len;
            this.Y /= len;
            this.Z /= len;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void crossProduct(Vector3D v1, Vector3D v2) {
        try {
            this.X = v1.Y * v2.Z - v1.Z * v2.Y;
            this.Y = v1.Z * v2.X - v1.X * v2.Z;
            this.Z = v1.X * v2.Y - v1.Y * v2.X;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void dotProduct(Vector3D v1, Vector3D v2) {
        try {
            this.X = v1.X * v2.X;
            this.Y = v1.Y * v2.Y;
            this.Z = v1.Z - v1.Z;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

