/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Math;

public class GridSmoother {
    protected float[][] m_temp = new float[3][3];

    public void smooth(float[][] input, int radius) {
        try {
            int y;
            int x;
            boolean realloc;
            int nx = input.length;
            int ny = input[0].length;
            boolean bl = realloc = nx != this.m_temp.length || ny != this.m_temp[0].length;
            if (realloc) {
                this.m_temp = new float[nx][ny];
            }
            for (x = 0; x < nx; ++x) {
                for (y = 0; y < ny; ++y) {
                    this.m_temp[x][y] = input[x][y];
                }
            }
            for (x = 0; x < nx; ++x) {
                for (y = 0; y < ny; ++y) {
                    int minx = Math.max(x - radius, 0);
                    int maxx = Math.min(x + radius, nx - 1);
                    int miny = Math.max(y - radius, 0);
                    int maxy = Math.min(y + radius, ny - 1);
                    float sum1 = 0.0f;
                    int sum2 = 0;
                    for (int x1 = minx; x1 <= maxx; ++x1) {
                        for (int y1 = miny; y1 <= maxy; ++y1) {
                            sum1 += this.m_temp[x1][y1];
                            ++sum2;
                        }
                    }
                    input[x][y] = sum1 / (float)sum2;
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }
}

