/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Math;

import com.PecosCore.Math.ComplexMatrix;
import com.PecosCore.Shared.ExceptionMonitor;

public class ComplexMatrix_Tools {
    protected ComplexMatrix m_tempColumn = new ComplexMatrix();
    protected ComplexMatrix m_pnext = new ComplexMatrix();
    protected ComplexMatrix m_pt = new ComplexMatrix();
    protected ComplexMatrix m_tempMatrix = new ComplexMatrix();
    protected ComplexMatrix m_scalar = new ComplexMatrix();
    protected ComplexMatrix m_transposeA = new ComplexMatrix();
    protected ComplexMatrix m_d = new ComplexMatrix();
    protected ComplexMatrix m_t = new ComplexMatrix();
    protected ComplexMatrix m_p = new ComplexMatrix();
    protected ComplexMatrix m_r = new ComplexMatrix();
    protected ComplexMatrix m_dold = new ComplexMatrix();
    protected ComplexMatrix m_told = new ComplexMatrix();
    protected ComplexMatrix m_pold = new ComplexMatrix();
    protected ComplexMatrix m_rold = new ComplexMatrix();

    public static void createT(ComplexMatrix matrix, int numX, int numY, int[] connector) {
        try {
            matrix.allocate(numY, numX);
            double[][] real = matrix.real();
            double[][] imag = matrix.imag();
            for (int k = 0; k < numY; ++k) {
                for (int m = 0; m < numX; ++m) {
                    real[k][m] = 0.0;
                    imag[k][m] = 0.0;
                    if (connector[m] == k) {
                        real[k][m] = 1.0;
                    }
                    if (!(real[k][m] > 0.1)) continue;
                    String s = String.format("row = %d  col = %d  val = %f", k, m, Float.valueOf((float)real[k][m]));
                    System.out.println(s);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void testFourierMatrix() {
        try {
            int M = 10;
            ComplexMatrix f = new ComplexMatrix();
            ComplexMatrix_Tools.createFourierMatrix(f, M);
            ComplexMatrix f1 = new ComplexMatrix();
            f1.conjugateTranspose(f);
            ComplexMatrix fm = new ComplexMatrix();
            fm.multiply(f1, f);
            for (int i = 0; i < M; ++i) {
                for (int j = 0; j < M; ++j) {
                    String s = String.format("%d  %d  %f  %f", i, j, Float.valueOf((float)fm.real()[i][j]), Float.valueOf((float)fm.imag()[i][j]));
                    System.out.println(s);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void createFourierMatrix(ComplexMatrix matrix, int M) {
        try {
            matrix.allocate(M, M);
            double[][] real = matrix.real();
            double[][] imag = matrix.imag();
            double scalar = 1.0 / Math.sqrt(M);
            double fac = Math.PI * 2 / (double)M;
            for (int k = 0; k < M; ++k) {
                for (int m = 0; m < M; ++m) {
                    real[k][m] = scalar * Math.cos(fac * (double)k * (double)m);
                    imag[k][m] = -scalar * Math.sin(fac * (double)k * (double)m);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void testConjugateGradientSolution() {
        try {
            ComplexMatrix_Tools tools = new ComplexMatrix_Tools();
            ComplexMatrix A = new ComplexMatrix(2, 2);
            A.real()[0][0] = 4.0;
            A.real()[0][1] = 1.0;
            A.real()[1][0] = 1.0;
            A.real()[1][1] = 3.0;
            ComplexMatrix b = new ComplexMatrix(2, 1);
            b.real()[0][0] = 1.0;
            b.real()[1][0] = 2.0;
            ComplexMatrix x = new ComplexMatrix(2, 1);
            x.real()[0][0] = 2.0;
            x.real()[1][0] = 1.0;
            tools.conjugateGradientSolution(A, b, x, 2);
            b.imag()[0][0] = 1.0;
            x.real()[0][0] = 0.0;
            x.real()[1][0] = 0.0;
            x.imag()[0][0] = 0.0;
            x.imag()[1][0] = 0.0;
            tools.conjugateGradientSolution(A, b, x, 2);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void conjugateGradientSolution(ComplexMatrix A, ComplexMatrix b, ComplexMatrix x, int maxIterations) throws Exception {
        try {
            if (A.columnCount() != A.rowCount()) {
                throw new Exception("matrix.columnCount() != matrix.rowCount()");
            }
            if (b.rowCount() != A.rowCount()) {
                throw new Exception("if (b.rowCount() != matrix.rowCount())");
            }
            if (b.columnCount() != 1) {
                throw new Exception("b.columnCount() != 1");
            }
            x.allocate(b.rowCount(), 1);
            this.m_tempColumn.multiply(A, x);
            this.m_r.copy(b);
            this.m_r.subtract(this.m_tempColumn, 1.0);
            this.m_p.copy(this.m_r);
            double rsold = this.m_r.magnitude();
            for (int iter = 0; iter < maxIterations; ++iter) {
                this.m_tempColumn.multiply(A, this.m_p);
                this.m_pt.conjugateTranspose(this.m_p);
                this.m_scalar.multiply(this.m_pt, this.m_tempColumn);
                double scalarReal = this.m_scalar.real()[0][0];
                double scalarImag = this.m_scalar.imag()[0][0];
                double alpha = rsold / scalarReal;
                x.add(this.m_p, alpha);
                this.m_r.subtract(this.m_tempColumn, alpha);
                double rsnew = this.m_r.magnitude();
                this.m_pnext.copy(this.m_r);
                this.m_pnext.add(this.m_p, rsnew / rsold);
                this.m_p.copy(this.m_pnext);
                rsold = rsnew;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void conjugateGradientSolution_NonSquare(ComplexMatrix A, ComplexMatrix b, ComplexMatrix x, int maxIterations) throws Exception {
        try {
            if (b.rowCount() != A.rowCount()) {
                throw new Exception("if (b.rowCount() != matrix.rowCount())");
            }
            if (b.columnCount() != 1) {
                throw new Exception("b.columnCount() != 1");
            }
            x.allocate(A.columnCount(), 1);
            this.m_transposeA.conjugateTranspose(A);
            x.set(0.0, 0.0);
            this.m_d.copy(b);
            this.m_r.multiply(this.m_transposeA, b);
            this.m_p.copy(this.m_r);
            this.m_t.multiply(A, this.m_p);
            for (int iter = 0; iter < maxIterations; ++iter) {
                this.m_told.copy(this.m_t);
                this.m_rold.copy(this.m_r);
                this.m_pold.copy(this.m_p);
                this.m_dold.copy(this.m_d);
                double rmagold = this.m_rold.magnitude();
                double tmagold = this.m_told.magnitude();
                double alpha = rmagold / tmagold;
                x.add(this.m_p, alpha);
                this.m_d.subtract(this.m_t, alpha);
                this.m_r.multiply(this.m_transposeA, this.m_d);
                double rmagnew = this.m_r.magnitude();
                double beta = rmagnew / rmagold;
                this.m_p.add(this.m_pt, alpha);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

