/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Math;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;

public class AzimuthSelector {
    protected boolean m_symmetric = false;
    protected double m_direction = 0.0;
    protected double m_angle = 0.0;
    protected double m_dx1;
    protected double m_dy1;
    protected double m_dx2;
    protected double m_dy2;
    protected double m_minAllowed = 0.0;

    public AzimuthSelector() {
        this.setLimits(0.0, 1.0, true);
    }

    public void removeTraces(Ensemble e) {
    }

    public boolean accept(double az) {
        try {
            double dot2;
            double dtx = Math.cos(az);
            double dty = Math.sin(az);
            double dot1 = dtx * this.m_dx1 + dty * this.m_dy1;
            if (dot1 >= this.m_minAllowed) {
                return true;
            }
            return this.m_symmetric && (dot2 = dtx * this.m_dx2 + dty * this.m_dy2) >= this.m_minAllowed;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public void setLimits(double direction, double angle, boolean symmetric) {
        try {
            this.m_symmetric = symmetric;
            this.m_direction = direction;
            this.m_angle = angle;
            this.m_angle = Math.max(this.m_angle, 0.001);
            this.m_angle = Math.min(this.m_angle, 3.1405926535897932);
            this.m_minAllowed = Math.cos(0.5 * this.m_angle);
            while (this.m_direction > Math.PI * 2) {
                this.m_direction -= Math.PI * 2;
            }
            while (this.m_direction < 0.0) {
                this.m_direction += Math.PI * 2;
            }
            this.m_dx1 = Math.cos(this.m_direction);
            this.m_dy1 = Math.sin(this.m_direction);
            this.m_dx2 = Math.cos(this.m_direction + Math.PI);
            this.m_dy2 = Math.sin(this.m_direction + Math.PI);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

