/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Geometry;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Geometry.LPIMapper;
import com.PecosCore.Geometry.TableParserConflict;
import com.PecosCore.Map.HashKey_Integer;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_XML;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TableParser {
    public boolean ForceLineToBeDefault = false;
    public int DefaultLineNumber = 1000;
    public int DefaultPointIndex = 1;
    public Table_Abstract Table;
    public int NextID = 1000;
    public String ColumnNameID;
    public String TableName;
    public int ColumnIndex_ID;
    public int ColumnIndex_Line;
    public int ColumnIndex_Point;
    public int ColumnIndex_Index;
    public int ColumnIndex_X;
    public int ColumnIndex_Y;
    public int ColumnIndex_Z;
    public int ColumnIndex_Fold;
    protected HashMap_Integers<Integer> m_mapLPI = new HashMap_Integers();
    public HashMap_Integers<Integer> MapFoldLPI = new HashMap_Integers();
    protected HashMap_Integers<ArrayList<NewIndexEntry>> m_mapLP = new HashMap_Integers();
    protected HashKey_Integer m_keyID = new HashKey_Integer(1);
    protected HashMap_Integer m_mapID = new HashMap_Integer();
    protected int[] m_columnIndex = new int[60];
    protected int[] m_headerIndex = new int[60];
    protected DataType[] m_dataType = new DataType[60];
    protected boolean[] m_checkForConflict = new boolean[60];
    protected int m_totalConflicts = 0;
    protected int m_maxConflicts = 100000;
    protected HashMap_Integers<TableParserConflict> m_conflictLPI = new HashMap_Integers();
    public boolean IgnoreTraceCode = false;
    public boolean IsMarine = false;
    public double RecBinSize = 25.0;
    public boolean CreateLPIMapper = false;
    public LPIMapper Mapper;

    public void print_hashmap_counts() {
        try {
            ArrayList<ArrayList<NewIndexEntry>> aa = this.m_mapLP.getValues();
            int num = 0;
            for (ArrayList<NewIndexEntry> a : aa) {
                num += a.size();
            }
            System.out.println("TableParser hashmap fold for table" + this.TableName);
            System.out.println("       m_mapLP " + this.m_mapLP.size());
            System.out.println("       NewIndexEntry count " + num);
            System.out.println("       MapFoldLPI " + this.MapFoldLPI.size());
            System.out.println("       m_mapLPI " + this.m_mapLPI.size());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int totalConflicts() {
        return this.m_totalConflicts;
    }

    public TableParser(Table_Abstract table, boolean setFoldToZero) {
        try {
            this.prepTable(table, setFoldToZero);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public TableParser(Table_Abstract table) {
        try {
            this.prepTable(table, true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepTable(Table_Abstract table, boolean setFoldToZero) {
        try {
            this.Table = table;
            this.TableName = table.name();
            this.ColumnNameID = this.TableName + "ID";
            this.ColumnIndex_ID = this.Table.column_append(this.ColumnNameID, DataType.Int);
            this.ColumnIndex_Line = this.Table.column_append("LineNumber", DataType.Int);
            this.ColumnIndex_Point = this.Table.column_append("PointNumber", DataType.Int);
            this.ColumnIndex_Index = this.Table.column_append("PointIndex", DataType.Int);
            this.ColumnIndex_Fold = this.Table.column_append("Fold", DataType.Int);
            this.ColumnIndex_X = this.Table.column_append("Easting", DataType.Double);
            this.ColumnIndex_Y = this.Table.column_append("Northing", DataType.Double);
            this.ColumnIndex_Z = this.Table.column_append("Elevation", DataType.Double);
            for (int n = 0; n < this.Table.row_count(); ++n) {
                if (setFoldToZero) {
                    this.Table.putInt(n, this.ColumnIndex_Fold, 0);
                }
                int id = this.Table.getInt(n, this.ColumnIndex_ID);
                this.m_mapID.put(id, n);
                this.NextID = Math.max(this.NextID, id + 1);
                int line = this.Table.getInt(n, this.ColumnIndex_Line);
                int point = this.Table.getInt(n, this.ColumnIndex_Point);
                int index = this.Table.getInt(n, this.ColumnIndex_Index);
                this.m_mapLPI.put(new Integer(n), line, point, index);
                int fold = this.Table.getInt(n, this.ColumnIndex_Fold);
                this.MapFoldLPI.put(new Integer(fold), line, point, index);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Table_Abstract createSimpleTable() {
        try {
            Table_Memory table = new Table_Memory();
            int indexLine = ((Table_Abstract)table).column_append("LineNumber", DataType.Int);
            int indexPoint = ((Table_Abstract)table).column_append("PointNumber", DataType.Int);
            int indexIndex = ((Table_Abstract)table).column_append("PointIndex", DataType.Int);
            int indexColumn = ((Table_Abstract)table).column_append("Column", DataType.Text);
            int indexFirst = ((Table_Abstract)table).column_append("Value", DataType.Double);
            int indexLast = ((Table_Abstract)table).column_append("Conflict", DataType.Double);
            int maxRows = 10000;
            for (TableParserConflict tpc : this.m_conflictLPI.getValues()) {
                int row = ((Table_Abstract)table).row_increment();
                ((Table_Abstract)table).putInt(row, indexLine, tpc.Line);
                ((Table_Abstract)table).putInt(row, indexPoint, tpc.Point);
                ((Table_Abstract)table).putInt(row, indexIndex, tpc.Index);
                ((Table_Abstract)table).putString(row, indexColumn, tpc.Columns.get((int)0).Name);
                ((Table_Abstract)table).putDouble(row, indexFirst, tpc.Columns.get((int)0).InitialValue);
                ((Table_Abstract)table).putDouble(row, indexLast, tpc.Columns.get((int)0).Entries.get((int)0).Value);
                if (row < maxRows) continue;
                return table;
            }
            return table;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void writeToNode(Element node) throws Exception {
        try {
            ArrayList<TableParserConflict> vals = this.m_conflictLPI.getValues();
            for (TableParserConflict con : vals) {
                Element entryNode = node.getOwnerDocument().createElement("Entry");
                node.appendChild(entryNode);
                entryNode.setAttribute("ID", Integer.toString(con.ID));
                entryNode.setAttribute("Row", Integer.toString(con.Row));
                entryNode.setAttribute("Line", Integer.toString(con.Line));
                entryNode.setAttribute("Point", Integer.toString(con.Point));
                entryNode.setAttribute("Index", Integer.toString(con.Index));
                ArrayList<TableParserConflict.ConflictColumn> cols = con.Columns;
                for (TableParserConflict.ConflictColumn column : cols) {
                    Element colNode = node.getOwnerDocument().createElement("Column");
                    entryNode.appendChild(colNode);
                    colNode.setAttribute("ColumnName", column.Name);
                    colNode.setAttribute("FirstValue", Double.toString(column.InitialValue));
                    ArrayList<TableParserConflict.ConflictEntry> entries = column.Entries;
                    for (TableParserConflict.ConflictEntry conEntry : entries) {
                        Element conEntryNode = node.getOwnerDocument().createElement("Conflict");
                        colNode.appendChild(conEntryNode);
                        conEntryNode.setAttribute("ConflictingValue", Double.toString(conEntry.Value));
                        conEntryNode.setAttribute("FileID", Integer.toString(conEntry.FileID));
                        conEntryNode.setAttribute("IndexInFile", Long.toString(conEntry.IndexInFile));
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static HashMap_Integers<TableParserConflict> readConflicts(String fileName) {
        try {
            HashMap_Integers<TableParserConflict> hash = new HashMap_Integers<TableParserConflict>();
            return hash;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return new HashMap_Integers<TableParserConflict>();
        }
    }

    public void saveConflicts(String fileName) {
        try {
            Document document = Tools_XML.createDocument();
            Element root = document.createElement("ImportConflicts");
            document.appendChild(root);
            this.writeToNode(root);
            Tools_XML.writeDocumentToFile(document, fileName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected TableParserConflict getConflictEntry(int id, int row, int line, int point, int index) {
        try {
            if (!this.m_conflictLPI.containsKey(line, point, index)) {
                TableParserConflict tpc = new TableParserConflict();
                tpc.ID = id;
                tpc.Row = row;
                tpc.Line = line;
                tpc.Point = point;
                tpc.Index = index;
                this.m_conflictLPI.put(tpc, line, point, index);
            }
            return this.m_conflictLPI.get(line, point, index);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void handleEnsemble(Ensemble ensemble) {
        try {
            if (this.IsMarine) {
                this.handleMarineEnsemble(ensemble);
                return;
            }
            EnsembleHeaderDictionary dict = ensemble.dictionary();
            if (!dict.containsEntry(this.TableName, "PointNumber")) {
                return;
            }
            int headerIndexFileID = -9999;
            if (dict.containsEntry("Trace", "FileID")) {
                headerIndexFileID = dict.getEntryIndex("Trace", "FileID");
            }
            int headerIndexIndex = -9999;
            if (dict.containsEntry("Trace", "IndexInFile")) {
                headerIndexIndex = dict.getEntryIndex("Trace", "IndexInFile");
            }
            int indexTraceCode = -9999;
            if (ensemble.dictionary().containsEntry("Trace", "TraceCode")) {
                indexTraceCode = ensemble.dictionary().getEntryIndex("Trace", "TraceCode");
            }
            int headerIndex_Point = dict.getEntryIndex(this.TableName, "PointNumber");
            int headerIndex_Line = -9999;
            int headerIndex_Index = -9999;
            if (dict.containsEntry(this.TableName, "LineNumber")) {
                headerIndex_Line = dict.getEntryIndex(this.TableName, "LineNumber");
            }
            if (dict.containsEntry(this.TableName, "PointIndex")) {
                headerIndex_Index = dict.getEntryIndex(this.TableName, "PointIndex");
            }
            int headerIndex_Easting = -9999;
            int headerIndex_Northing = -9999;
            if (dict.containsEntry(this.TableName, "Easting")) {
                headerIndex_Easting = dict.getEntryIndex(this.TableName, "Easting");
            }
            if (dict.containsEntry(this.TableName, "Northing")) {
                headerIndex_Northing = dict.getEntryIndex(this.TableName, "Northing");
            }
            boolean coordOkay = headerIndex_Easting >= 0 && headerIndex_Northing >= 0;
            int headerIndex_ID = dict.addEntry(this.TableName, this.ColumnNameID, DataType.Int);
            int headerIndex_TraceID = dict.addEntry("Trace", this.ColumnNameID, DataType.Int);
            if (this.m_columnIndex.length < dict.size()) {
                this.m_columnIndex = new int[dict.size() + 10];
                this.m_headerIndex = new int[dict.size() + 10];
                this.m_dataType = new DataType[dict.size() + 10];
                this.m_checkForConflict = new boolean[dict.size() + 10];
            }
            int numConnections = 0;
            for (int n = 0; n < dict.size(); ++n) {
                boolean ignoreConflicts;
                EnsembleHeaderDictionary.Entry entry = dict.getEntry(n);
                boolean bl = ignoreConflicts = entry.Column.equalsIgnoreCase(this.ColumnNameID) || entry.Column.equalsIgnoreCase("LineNumber") || entry.Column.equalsIgnoreCase("PointNumber") || entry.Column.equalsIgnoreCase("PointIndex");
                if (!entry.Table.equalsIgnoreCase(this.TableName)) continue;
                this.m_headerIndex[numConnections] = entry.Index;
                this.m_dataType[numConnections] = entry.PreferredType;
                this.m_columnIndex[numConnections] = this.Table.column_append(entry.Column, entry.PreferredType);
                boolean check = entry.Column.equalsIgnoreCase("Easting") || entry.Column.equalsIgnoreCase("Northing");
                this.m_checkForConflict[numConnections] = check && !ignoreConflicts;
                ++numConnections;
            }
            int line = this.DefaultLineNumber;
            int index = this.DefaultPointIndex;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                Column_Abstract header = ensemble.trace(n).header();
                int point = header.getInt(headerIndex_Point);
                if (headerIndex_Line >= 0) {
                    line = header.getInt(headerIndex_Line);
                }
                if (this.ForceLineToBeDefault) {
                    line = this.DefaultLineNumber;
                }
                if (coordOkay && headerIndex_Index < 0) {
                    double x = header.getDouble(headerIndex_Easting);
                    double y = header.getDouble(headerIndex_Northing);
                    if (this.m_mapLP.containsKey(line, point)) {
                        list = this.m_mapLP.get(line, point);
                        boolean sameCoordsFound = false;
                        int maxIndex = 1;
                        for (NewIndexEntry newIndexEntry : list) {
                            double dist = Math.abs(x - newIndexEntry.X) + Math.abs(y - newIndexEntry.Y);
                            if (dist < 2.0) {
                                sameCoordsFound = true;
                                index = newIndexEntry.Index;
                                continue;
                            }
                            maxIndex = Math.max(maxIndex, newIndexEntry.Index);
                        }
                        if (!sameCoordsFound) {
                            index = maxIndex + 1;
                            list.add(new NewIndexEntry(line, point, index, x, y));
                        }
                    } else {
                        index = 1;
                        list = new ArrayList();
                        list.add(new NewIndexEntry(line, point, index, x, y));
                        this.m_mapLP.put(list, line, point);
                    }
                } else if (headerIndex_Index >= 0) {
                    index = header.getInt(headerIndex_Index);
                }
                int traceCode = 1;
                if (indexTraceCode >= 0) {
                    traceCode = header.getInt(indexTraceCode);
                }
                int id = -9999;
                if (this.IgnoreTraceCode || traceCode == 1) {
                    if (this.m_mapLPI.containsKey(line, point, index)) {
                        int row = this.m_mapLPI.get(line, point, index);
                        int fold = this.Table.getInt(row, this.ColumnIndex_Fold);
                        this.Table.putInt(row, this.ColumnIndex_Fold, fold + 1);
                        this.MapFoldLPI.put(new Integer(fold + 1), line, point, index);
                        id = this.Table.getInt(row, this.ColumnIndex_ID);
                        for (int k = 0; k < numConnections; ++k) {
                            String colName;
                            if (!this.m_checkForConflict[k]) continue;
                            if (this.m_dataType[k] == DataType.Int || this.m_dataType[k] == DataType.Short) {
                                String colName2;
                                int oldHeaderValue;
                                int newHeaderValue = header.getInt(this.m_headerIndex[k]);
                                if (newHeaderValue == (oldHeaderValue = this.Table.getInt(row, this.m_columnIndex[k])) || this.m_totalConflicts >= this.m_maxConflicts || headerIndexFileID < 0 || headerIndexIndex < 0) continue;
                                int fileID = header.getInt(headerIndexFileID);
                                long l = header.getLong(headerIndexIndex);
                                TableParserConflict tpc = this.getConflictEntry(id, row, line, point, index);
                                if (!tpc.addConflict(colName2 = this.Table.column_name(this.m_columnIndex[k]), oldHeaderValue, newHeaderValue, fileID, l)) continue;
                                ++this.m_totalConflicts;
                                continue;
                            }
                            double newHeaderValue = header.getDouble(this.m_headerIndex[k]);
                            double oldHeaderValue = this.Table.getDouble(row, this.m_columnIndex[k]);
                            if (!(Math.abs(oldHeaderValue - newHeaderValue) > 0.5) || this.m_totalConflicts >= this.m_maxConflicts || headerIndexFileID < 0 || headerIndexIndex < 0) continue;
                            int fileID = header.getInt(headerIndexFileID);
                            long indexInFile = header.getLong(headerIndexIndex);
                            TableParserConflict tpc = this.getConflictEntry(id, row, line, point, index);
                            if (!tpc.addConflict(colName = this.Table.column_name(this.m_columnIndex[k]), oldHeaderValue, newHeaderValue, fileID, indexInFile)) continue;
                            ++this.m_totalConflicts;
                        }
                    } else {
                        id = this.NextID;
                        if (this.CreateLPIMapper) {
                            if (this.Mapper == null) {
                                this.Mapper = new LPIMapper();
                                this.Mapper.UseLineNumber = headerIndex_Line >= 0;
                                this.Mapper.UsePointIndex = headerIndex_Index >= 0;
                            }
                            this.Mapper.add(id, line, point, index);
                        }
                        int row = this.Table.row_increment();
                        this.Table.putInt(row, this.ColumnIndex_Fold, 1);
                        this.MapFoldLPI.put(new Integer(1), line, point, index);
                        for (int k = 0; k < numConnections; ++k) {
                            if (this.m_dataType[k] == DataType.Int || this.m_dataType[k] == DataType.Short) {
                                int v = header.getInt(this.m_headerIndex[k]);
                                this.Table.putInt(row, this.m_columnIndex[k], v);
                                continue;
                            }
                            double v = header.getDouble(this.m_headerIndex[k]);
                            this.Table.putDouble(row, this.m_columnIndex[k], v);
                        }
                        this.Table.putInt(row, this.ColumnIndex_ID, id);
                        this.Table.putInt(row, this.ColumnIndex_Line, line);
                        this.Table.putInt(row, this.ColumnIndex_Point, point);
                        this.Table.putInt(row, this.ColumnIndex_Index, index);
                        this.m_mapLPI.put(new Integer(row), line, point, index);
                        ++this.NextID;
                    }
                }
                header.putInt(headerIndex_TraceID, id);
                header.putInt(headerIndex_ID, id);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void handleMarineEnsemble(Ensemble ensemble) {
        try {
            boolean coordOkay;
            EnsembleHeaderDictionary dict = ensemble.dictionary();
            int indexTraceCode = -9999;
            if (ensemble.dictionary().containsEntry("Trace", "TraceCode")) {
                indexTraceCode = ensemble.dictionary().getEntryIndex("Trace", "TraceCode");
            }
            int headerIndex_Easting = -9999;
            int headerIndex_Northing = -9999;
            if (dict.containsEntry(this.TableName, "Easting")) {
                headerIndex_Easting = dict.getEntryIndex(this.TableName, "Easting");
            }
            if (dict.containsEntry(this.TableName, "Northing")) {
                headerIndex_Northing = dict.getEntryIndex(this.TableName, "Northing");
            }
            boolean bl = coordOkay = headerIndex_Easting >= 0 && headerIndex_Northing >= 0;
            if (!coordOkay) {
                return;
            }
            int headerIndex_WaterDepth = -9999;
            int headerIndex_PointDepth = -9999;
            if (dict.containsEntry(this.TableName, "WaterDepth")) {
                headerIndex_WaterDepth = dict.getEntryIndex(this.TableName, "WaterDepth");
            }
            if (dict.containsEntry(this.TableName, "PointDepth")) {
                headerIndex_PointDepth = dict.getEntryIndex(this.TableName, "PointDepth");
            }
            boolean importWaterDepth = headerIndex_WaterDepth >= 0;
            boolean importPointDepth = headerIndex_PointDepth >= 0;
            int columnIndex_WaterDepth = -9999;
            int columnIndex_PointDepth = -9999;
            if (importWaterDepth) {
                columnIndex_WaterDepth = this.Table.column_append("WaterDepth", DataType.Double);
            }
            if (importPointDepth) {
                columnIndex_PointDepth = this.Table.column_append("PointDepth", DataType.Double);
            }
            int headerIndex_ID = dict.addEntry(this.TableName, this.ColumnNameID, DataType.Int);
            int headerIndex_TraceID = dict.addEntry("Trace", this.ColumnNameID, DataType.Int);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                Column_Abstract header = ensemble.trace(n).header();
                double x = header.getDouble(headerIndex_Easting);
                double y = header.getDouble(headerIndex_Northing);
                int line = (int)(0.5 + y / this.RecBinSize);
                int point = (int)(0.5 + x / this.RecBinSize);
                int index = 1;
                x = (double)point * this.RecBinSize;
                y = (double)line * this.RecBinSize;
                header.putDouble(headerIndex_Easting, x);
                header.putDouble(headerIndex_Northing, y);
                int traceCode = 1;
                if (indexTraceCode >= 0) {
                    traceCode = header.getInt(indexTraceCode);
                }
                int id = -9999;
                if (this.IgnoreTraceCode || traceCode == 1) {
                    if (this.m_mapLPI.containsKey(line, point, index)) {
                        row = this.m_mapLPI.get(line, point, index);
                        int fold = this.Table.getInt(row, this.ColumnIndex_Fold);
                        if (importWaterDepth) {
                            double watersum = this.Table.getDouble(row, columnIndex_WaterDepth) * (double)fold;
                            watersum += header.getDouble(headerIndex_WaterDepth);
                            this.Table.putDouble(row, columnIndex_WaterDepth, watersum /= (double)(fold + 1));
                        }
                        if (importPointDepth) {
                            double depthsum = this.Table.getDouble(row, columnIndex_PointDepth) * (double)fold;
                            depthsum += header.getDouble(headerIndex_PointDepth);
                            this.Table.putDouble(row, columnIndex_PointDepth, depthsum /= (double)(fold + 1));
                        }
                        this.Table.putInt(row, this.ColumnIndex_Fold, fold + 1);
                        id = this.Table.getInt(row, this.ColumnIndex_ID);
                    } else {
                        id = this.NextID;
                        row = this.Table.row_increment();
                        this.Table.putInt(row, this.ColumnIndex_Fold, 1);
                        this.Table.putInt(row, this.ColumnIndex_ID, id);
                        this.Table.putInt(row, this.ColumnIndex_Line, line);
                        this.Table.putInt(row, this.ColumnIndex_Point, point);
                        this.Table.putInt(row, this.ColumnIndex_Index, index);
                        this.Table.putDouble(row, this.ColumnIndex_X, x);
                        this.Table.putDouble(row, this.ColumnIndex_Y, y);
                        if (importWaterDepth) {
                            this.Table.putDouble(row, columnIndex_WaterDepth, header.getDouble(headerIndex_WaterDepth));
                        }
                        if (importPointDepth) {
                            this.Table.putDouble(row, columnIndex_PointDepth, header.getDouble(headerIndex_PointDepth));
                        }
                        this.m_mapLPI.put(new Integer(row), line, point, index);
                        ++this.NextID;
                    }
                }
                header.putInt(headerIndex_TraceID, id);
                header.putInt(headerIndex_ID, id);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class NewIndexEntry {
        public int Line;
        public int Point;
        public int Index;
        public double X;
        public double Y;

        public NewIndexEntry(int line, int point, int index, double x, double y) {
            this.Line = line;
            this.Point = point;
            this.Index = index;
            this.X = x;
            this.Y = y;
        }
    }
}

