/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.FFT;

import com.PecosCore.FFT.FFT_1D_Wrapper;
import com.PecosCore.Map.HashKey_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import java.util.HashMap;

public class FFT_Server {
    protected HashMap<HashKey_Integer, FFT_1D_Wrapper> m_fftOneDim = new HashMap();
    protected HashKey_Integer m_tempKey = new HashKey_Integer(0);
    protected static FFT_Server m_singleton = null;

    protected FFT_Server() {
        try {
            for (int len = 16; len <= 4096; len *= 2) {
                FFT_1D_Wrapper fft = new FFT_1D_Wrapper(len);
                HashKey_Integer key = new HashKey_Integer(len);
                this.m_fftOneDim.put(key, fft);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static FFT_1D_Wrapper fft1D(int len) {
        try {
            return FFT_Server.singleton().getFFT_1D(len);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public FFT_1D_Wrapper getFFT_1D(int len) {
        try {
            int fftLen;
            for (fftLen = 16; fftLen < len; fftLen *= 2) {
            }
            this.m_tempKey.Key = fftLen;
            if (!this.m_fftOneDim.containsKey(this.m_tempKey)) {
                FFT_1D_Wrapper fft = new FFT_1D_Wrapper(fftLen);
                HashKey_Integer key = new HashKey_Integer(fftLen);
                this.m_fftOneDim.put(key, fft);
            }
            return this.m_fftOneDim.get(this.m_tempKey);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public static FFT_Server singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new FFT_Server();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

